/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.provision;

import java.util.concurrent.TimeUnit;
import org.opennms.core.utils.ThreadCategory;
import org.opennms.netmgt.provision.ProvisioningAdapterException;
import org.opennms.netmgt.provision.SimpleQueuedProvisioningAdapter;

public abstract class SimplerQueuedProvisioningAdapter
extends SimpleQueuedProvisioningAdapter {
    private String m_name;
    private long m_delay = 1L;
    private TimeUnit m_timeUnit = TimeUnit.SECONDS;

    public SimplerQueuedProvisioningAdapter(String name) {
        this.m_name = name;
    }

    public void setTimeUnit(TimeUnit timeUnit) {
        this.m_timeUnit = timeUnit;
    }

    public void setDelay(long delay) {
        this.m_delay = delay;
    }

    public String getName() {
        return this.m_name;
    }

    SimpleQueuedProvisioningAdapter.AdapterOperationSchedule createScheduleForNode(int nodeId, SimpleQueuedProvisioningAdapter.AdapterOperationType adapterOperationType) {
        return new SimpleQueuedProvisioningAdapter.AdapterOperationSchedule(this, this.m_delay, 0L, 1, this.m_timeUnit);
    }

    public boolean isNodeReady(SimpleQueuedProvisioningAdapter.AdapterOperation op) {
        return true;
    }

    public void processPendingOperationForNode(SimpleQueuedProvisioningAdapter.AdapterOperation op) throws ProvisioningAdapterException {
        SimplerQueuedProvisioningAdapter.log().info("processPendingOperationForNode: Handling Operation: " + op);
        switch (op.getType()) {
            case ADD: {
                this.doAddNode(op.getNodeId());
                break;
            }
            case UPDATE: {
                this.doUpdateNode(op.getNodeId());
                break;
            }
            case DELETE: {
                this.doDeleteNode(op.getNodeId());
                break;
            }
            case CONFIG_CHANGE: {
                this.doNotifyConfigChange(op.getNodeId());
            }
        }
    }

    public void init() {
        this.assertNotNull((Object)this.m_timeUnit, "timeUnit must be set");
    }

    private void assertNotNull(Object o, String msg) {
        this.assertTrue(o != null, msg);
    }

    private void assertTrue(boolean b, String m) {
        if (!b) {
            throw new IllegalStateException(m);
        }
    }

    public void doAddNode(int nodeid) {
    }

    public void doUpdateNode(int nodeid) {
    }

    public void doDeleteNode(int nodeid) {
    }

    public void doNotifyConfigChange(int nodeid) {
    }

    private static ThreadCategory log() {
        return ThreadCategory.getInstance(SimplerQueuedProvisioningAdapter.class);
    }
}

