/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.provision;

import java.util.LinkedHashMap;
import java.util.Map;
import org.opennms.core.utils.ThreadCategory;
import org.opennms.netmgt.provision.annotations.Require;
import org.springframework.beans.BeanWrapper;
import org.springframework.beans.BeanWrapperImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BasePolicy<T> {
    private Match m_match = Match.ANY_PARAMETER;
    private final LinkedHashMap<String, String> m_criteria = new LinkedHashMap();

    protected boolean match(String s, String matcher) {
        if (s == null) {
            return false;
        }
        if (matcher.startsWith("~")) {
            matcher = matcher.replaceFirst("~", "");
            return s.matches(matcher);
        }
        return s.equals(matcher);
    }

    @Require(value={"ANY_PARAMETER", "ALL_PARAMETERS", "NO_PARAMETERS"})
    public String getMatchBehavior() {
        return this.getMatch().toString();
    }

    public void setMatchBehavior(String matchBehavior) {
        if (matchBehavior != null && matchBehavior.toUpperCase().contains("ALL")) {
            this.setMatch(Match.ALL_PARAMETERS);
        } else if (matchBehavior != null && matchBehavior.toUpperCase().contains("NO")) {
            this.setMatch(Match.NO_PARAMETERS);
        } else {
            this.setMatch(Match.ANY_PARAMETER);
        }
    }

    protected void setMatch(Match match) {
        this.m_match = match;
    }

    protected Match getMatch() {
        return this.m_match;
    }

    protected String getCriteria(String key) {
        return this.getCriteria().get(key);
    }

    protected String putCriteria(String key, String expression) {
        return this.getCriteria().put(key, expression);
    }

    protected LinkedHashMap<String, String> getCriteria() {
        return this.m_criteria;
    }

    protected boolean matches(T iface) {
        switch (this.getMatch()) {
            case ALL_PARAMETERS: {
                return this.matchAll(iface);
            }
            case NO_PARAMETERS: {
                return this.matchNone(iface);
            }
        }
        return this.matchAny(iface);
    }

    private boolean matchAll(T iface) {
        BeanWrapperImpl bean = new BeanWrapperImpl(iface);
        for (Map.Entry<String, String> term : this.getCriteria().entrySet()) {
            String matchExpression;
            String val = this.getPropertyValueAsString((BeanWrapper)bean, term.getKey());
            if (this.match(val, matchExpression = term.getValue())) continue;
            return false;
        }
        return true;
    }

    private boolean matchAny(T iface) {
        BeanWrapperImpl bean = new BeanWrapperImpl(iface);
        for (Map.Entry<String, String> term : this.getCriteria().entrySet()) {
            String matchExpression;
            String val = this.getPropertyValueAsString((BeanWrapper)bean, term.getKey());
            if (!this.match(val, matchExpression = term.getValue())) continue;
            return true;
        }
        return false;
    }

    private boolean matchNone(T iface) {
        return !this.matchAny(iface);
    }

    private String getPropertyValueAsString(BeanWrapper bean, String propertyName) {
        return (String)bean.convertIfNecessary(bean.getPropertyValue(propertyName), String.class);
    }

    public abstract T act(T var1);

    public T apply(T iface) {
        if (iface == null) {
            return null;
        }
        if (this.matches(iface)) {
            this.debug("Found Match %s for %s", iface, this);
            return this.act(iface);
        }
        this.debug("No Match Found: %s for %s", iface, this);
        return iface;
    }

    protected void debug(String format, Object ... args) {
        ThreadCategory log = ThreadCategory.getInstance(this.getClass());
        if (log.isDebugEnabled()) {
            log.debug(String.format(format, args));
        }
    }

    protected void info(String format, Object ... args) {
        ThreadCategory log = ThreadCategory.getInstance(this.getClass());
        if (log.isInfoEnabled()) {
            log.info(String.format(format, args));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Match {
        ANY_PARAMETER,
        ALL_PARAMETERS,
        NO_PARAMETERS;

    }
}

