/*
 * Decompiled with CFR 0.152.
 */
package org.snmp4j.agent.request;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import org.snmp4j.CommandResponderEvent;
import org.snmp4j.PDU;
import org.snmp4j.PDUv1;
import org.snmp4j.ScopedPDU;
import org.snmp4j.agent.DefaultMOContextScope;
import org.snmp4j.agent.MOQuery;
import org.snmp4j.agent.MOScope;
import org.snmp4j.agent.ManagedObject;
import org.snmp4j.agent.mo.snmp.CoexistenceInfo;
import org.snmp4j.agent.request.AbstractRequest;
import org.snmp4j.agent.request.Request;
import org.snmp4j.agent.request.RequestStatus;
import org.snmp4j.agent.request.RequestStatusEvent;
import org.snmp4j.agent.request.RequestStatusListener;
import org.snmp4j.agent.request.SubRequest;
import org.snmp4j.agent.request.SubRequestIterator;
import org.snmp4j.agent.request.SubRequestIteratorSupport;
import org.snmp4j.log.LogAdapter;
import org.snmp4j.log.LogFactory;
import org.snmp4j.smi.OID;
import org.snmp4j.smi.OctetString;
import org.snmp4j.smi.VariableBinding;

public class SnmpRequest
extends AbstractRequest {
    private static final LogAdapter logger = LogFactory.getLogger((Class)(class$org$snmp4j$agent$request$SnmpRequest == null ? (class$org$snmp4j$agent$request$SnmpRequest = SnmpRequest.class$("org.snmp4j.agent.request.SnmpRequest")) : class$org$snmp4j$agent$request$SnmpRequest));
    public static final OctetString DEFAULT_CONTEXT = new OctetString();
    private CommandResponderEvent requestEvent;
    private CoexistenceInfo coexistenceInfo;
    private PDU response;
    private OctetString viewName;
    private static int nextTransactionID = 0;
    protected Map processingUserObjects;
    static /* synthetic */ Class class$org$snmp4j$agent$request$SnmpRequest;

    public SnmpRequest(CommandResponderEvent request, CoexistenceInfo cinfo) {
        this.requestEvent = request;
        this.coexistenceInfo = cinfo;
        this.correctRequestValues();
        this.transactionID = SnmpRequest.nextTransactionID();
    }

    public static int nextTransactionID() {
        return nextTransactionID++;
    }

    protected synchronized void setupSubRequests() {
        int capacity = this.requestEvent.getPDU().size();
        int totalRepetitions = this.requestEvent.getPDU() instanceof PDUv1 ? 0 : this.repeaterRowSize * this.requestEvent.getPDU().getMaxRepetitions();
        this.subrequests = new ArrayList(capacity + totalRepetitions);
        if (this.response == null) {
            this.response = this.createResponse();
        }
        for (int i = 0; i < this.requestEvent.getPDU().size(); ++i) {
            SnmpSubRequest subReq = new SnmpSubRequest(this.requestEvent.getPDU().get(i), i);
            this.addSubRequest(subReq);
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("SnmpSubRequests initialized: " + this.subrequests));
        }
    }

    public synchronized int getCompleteRepetitions() {
        int i = 0;
        Iterator it = this.subrequests.iterator();
        while (it.hasNext()) {
            SnmpSubRequest sreq = (SnmpSubRequest)it.next();
            if (!sreq.isComplete()) {
                return i / this.getRepeaterCount();
            }
            ++i;
        }
        return i / this.getRepeaterCount();
    }

    public int getMaxRepetitions() {
        return this.requestEvent.getPDU().getMaxRepetitions();
    }

    public int getNonRepeaters() {
        return this.requestEvent.getPDU().getNonRepeaters();
    }

    private void addSubRequest(SubRequest subReq) {
        this.subrequests.add(subReq);
        this.response.add(subReq.getVariableBinding());
    }

    protected int getMaxPhase() {
        return this.is2PC() ? 4 : 0;
    }

    public int size() {
        return this.requestEvent.getPDU().size();
    }

    public Object getSource() {
        return this.requestEvent;
    }

    public CommandResponderEvent getInitiatingEvent() {
        return this.requestEvent;
    }

    public void setRequestEvent(CommandResponderEvent requestEvent) {
        this.requestEvent = requestEvent;
    }

    protected void assignErrorStatus2Response() {
        int errStatus = this.getErrorStatus();
        if (this.requestEvent.getMessageProcessingModel() == 0) {
            switch (errStatus) {
                case 6: 
                case 11: 
                case 17: 
                case 18: {
                    this.response.setErrorStatus(2);
                    break;
                }
                case 13: 
                case 14: 
                case 15: 
                case 16: {
                    this.response.setErrorStatus(5);
                    break;
                }
                case 7: 
                case 8: 
                case 10: 
                case 12: {
                    this.response.setErrorStatus(3);
                    break;
                }
                default: {
                    this.response.setErrorStatus(errStatus);
                }
            }
            for (int i = 0; i < this.response.size(); ++i) {
                VariableBinding vb = this.response.get(i);
                if (!vb.isException()) continue;
                this.response.setErrorStatus(2);
                this.response.setErrorIndex(i + 1);
                this.response.set(i, new VariableBinding(vb.getOid()));
                return;
            }
        } else {
            this.response.setErrorStatus(errStatus);
        }
        this.response.setErrorIndex(this.getErrorIndex());
    }

    private PDU createResponse() {
        PDU resp = (PDU)this.requestEvent.getPDU().clone();
        resp.clear();
        resp.setType(-94);
        resp.setRequestID(this.requestEvent.getPDU().getRequestID());
        resp.setErrorIndex(0);
        resp.setErrorStatus(0);
        return resp;
    }

    private void correctRequestValues() {
        PDU request = this.requestEvent.getPDU();
        if (!(request instanceof PDUv1)) {
            if (request.getMaxRepetitions() < 0) {
                request.setMaxRepetitions(0);
            }
            if (request.getNonRepeaters() < 0) {
                request.setNonRepeaters(0);
            }
            this.repeaterStartIndex = request.getNonRepeaters();
            this.repeaterRowSize = Math.max(request.size() - this.repeaterStartIndex, 0);
        } else {
            this.repeaterStartIndex = 0;
            this.repeaterRowSize = request.size();
        }
    }

    public PDU getResponsePDU() {
        return (PDU)this.getResponse();
    }

    public Object getResponse() {
        if (this.response == null) {
            this.response = this.createResponse();
        }
        this.assignErrorStatus2Response();
        return this.response;
    }

    public Iterator iterator() {
        this.initSubRequests();
        return new SnmpSubRequestIterator();
    }

    protected boolean is2PC() {
        return this.requestEvent.getPDU().getType() == -93;
    }

    public OctetString getContext() {
        if (this.coexistenceInfo != null) {
            return this.coexistenceInfo.getContextName();
        }
        if (this.requestEvent.getPDU() instanceof ScopedPDU) {
            return ((ScopedPDU)this.requestEvent.getPDU()).getContextName();
        }
        return DEFAULT_CONTEXT;
    }

    public OctetString getViewName() {
        return this.viewName;
    }

    public void setViewName(OctetString viewName) {
        this.viewName = viewName;
    }

    public int getSecurityLevel() {
        return this.requestEvent.getSecurityLevel();
    }

    public int getSecurityModel() {
        return this.requestEvent.getSecurityModel();
    }

    public OctetString getSecurityName() {
        if (this.coexistenceInfo != null) {
            return this.coexistenceInfo.getSecurityName();
        }
        return new OctetString(this.requestEvent.getSecurityName());
    }

    public int getViewType() {
        return SnmpRequest.getViewType(this.requestEvent.getPDU().getType());
    }

    public static final int getViewType(int pduType) {
        switch (pduType) {
            case -96: 
            case -95: 
            case -91: {
                return 1;
            }
            case -92: 
            case -90: 
            case -89: {
                return 0;
            }
        }
        return 2;
    }

    protected synchronized void addRepeaterSubRequest() {
        int predecessorIndex = this.subrequests.size() - this.repeaterRowSize;
        SnmpSubRequest sreq = new SnmpSubRequest((SnmpSubRequest)this.subrequests.get(predecessorIndex), this.subrequests.size());
        this.addSubRequest(sreq);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Added sub request '" + sreq + "' to response '" + this.response + "'"));
        }
    }

    public int getErrorIndex() {
        if (this.errorStatus == 0) {
            return 0;
        }
        this.initSubRequests();
        int index = 1;
        Iterator it = this.subrequests.iterator();
        while (it.hasNext()) {
            SubRequest sreq = (SubRequest)it.next();
            if (sreq.getStatus().getErrorStatus() != 0) {
                return index;
            }
            ++index;
        }
        return 0;
    }

    public int getTransactionID() {
        return this.transactionID;
    }

    public CoexistenceInfo getCoexistenceInfo() {
        return this.coexistenceInfo;
    }

    private List lastRow(int upperBoundIndex) {
        if (this.repeaterRowSize == 0 || upperBoundIndex <= this.repeaterStartIndex) {
            return null;
        }
        int rows = (upperBoundIndex - this.repeaterStartIndex) / this.repeaterRowSize;
        int startIndex = this.repeaterStartIndex + this.repeaterRowSize * (rows - 1);
        int endIndex = this.repeaterStartIndex + this.repeaterRowSize * rows;
        if (startIndex < this.repeaterStartIndex || endIndex > this.subrequests.size()) {
            return null;
        }
        return this.subrequests.subList(startIndex, endIndex);
    }

    public int getMessageProcessingModel() {
        return this.requestEvent.getMessageProcessingModel();
    }

    public int getRepeaterCount() {
        PDU reqPDU = this.requestEvent.getPDU();
        return Math.max(reqPDU.size() - reqPDU.getNonRepeaters(), 0);
    }

    public boolean isPhaseComplete() {
        SnmpSubRequestIterator it;
        if (this.errorStatus == 0) {
            this.initSubRequests();
            it = this.subrequests.iterator();
            while (it.hasNext()) {
                SubRequest subreq = (SubRequest)it.next();
                RequestStatus status = subreq.getStatus();
                if (status.getErrorStatus() != 0) {
                    return true;
                }
                if (status.isPhaseComplete()) continue;
                return false;
            }
        }
        if (this.requestEvent.getPDU().getType() == -91) {
            it = new SnmpSubRequestIterator(this.subrequests.size(), 1);
            return !it.hasNext();
        }
        return true;
    }

    public boolean isBulkRequest() {
        return this.requestEvent.getPDU().getType() == -91;
    }

    public synchronized Object getProcessingUserObject(Object key) {
        if (this.processingUserObjects != null) {
            return this.processingUserObjects.get(key);
        }
        return null;
    }

    public synchronized Object setProcessingUserObject(Object key, Object value) {
        if (this.processingUserObjects == null) {
            this.processingUserObjects = new HashMap(5);
        }
        return this.processingUserObjects.put(key, value);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public class SnmpSubRequest
    implements org.snmp4j.agent.request.SnmpSubRequest,
    RequestStatusListener {
        private RequestStatus status;
        private VariableBinding vb;
        private Object undoValue;
        private MOScope scope;
        private ManagedObject targetMO;
        private MOQuery query;
        private int index;
        private volatile Object userObject;

        protected SnmpSubRequest(VariableBinding subrequest, int index) {
            this.vb = subrequest;
            this.index = index;
            switch (SnmpRequest.this.requestEvent.getPDU().getType()) {
                case -95: 
                case -91: {
                    this.scope = this.getNextScope(new OID(this.vb.getOid()));
                    break;
                }
                default: {
                    OID oid = this.vb.getOid();
                    this.scope = new DefaultMOContextScope(SnmpRequest.this.getContext(), oid, true, oid, true);
                }
            }
            this.status = new RequestStatus();
            this.status.addRequestStatusListener(this);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Created subrequest " + index + " with scope " + this.scope + " from " + subrequest));
            }
        }

        protected MOScope getNextScope(OID previousOID) {
            return new DefaultMOContextScope(SnmpRequest.this.getContext(), previousOID, false, null, false);
        }

        protected SnmpSubRequest(SnmpSubRequest predecessor, int index) {
            this(new VariableBinding(predecessor.getVariableBinding().getOid()), index);
        }

        public Request getRequest() {
            return SnmpRequest.this;
        }

        public RequestStatus getStatus() {
            return this.status;
        }

        public VariableBinding getVariableBinding() {
            return this.vb;
        }

        public void setStatus(RequestStatus status) {
            this.status = status;
        }

        public Object getUndoValue() {
            return this.undoValue;
        }

        public void setUndoValue(Object undoInformation) {
            this.undoValue = undoInformation;
        }

        public void requestStatusChanged(RequestStatusEvent event) {
            int newStatus = event.getStatus().getErrorStatus();
            this.setErrorStatus(newStatus);
            if (logger.isDebugEnabled() && newStatus != 0) {
                new Exception("Error '" + PDU.toErrorStatusText((int)event.getStatus().getErrorStatus()) + "' generated at: " + this.vb).printStackTrace();
            }
        }

        public MOScope getScope() {
            return this.scope;
        }

        public void completed() {
            this.status.setPhaseComplete(true);
        }

        public boolean hasError() {
            return this.getStatus().getErrorStatus() != 0;
        }

        public boolean isComplete() {
            return this.status.isPhaseComplete();
        }

        public void setTargetMO(ManagedObject managedObject) {
            this.targetMO = managedObject;
        }

        public ManagedObject getTargetMO() {
            return this.targetMO;
        }

        public SnmpRequest getSnmpRequest() {
            return SnmpRequest.this;
        }

        public void setErrorStatus(int errorStatus) {
            SnmpRequest.this.setErrorStatus(errorStatus);
        }

        public int getIndex() {
            return this.index;
        }

        public void setQuery(MOQuery query) {
            this.query = query;
        }

        public MOQuery getQuery() {
            return this.query;
        }

        public String toString() {
            return this.getClass().getName() + "[scope=" + this.scope + ",vb=" + this.vb + ",status=" + this.status + ",query=" + this.query + ",index=" + this.index + ",targetMO=" + this.targetMO + "]";
        }

        public SubRequestIterator repetitions() {
            return this.repetitions(false);
        }

        private SubRequestIterator repetitions(boolean noAppending) {
            SnmpRequest.this.initSubRequests();
            if (SnmpRequest.this.isBulkRequest()) {
                int repeaters = SnmpRequest.this.requestEvent.getPDU().size() - SnmpRequest.this.requestEvent.getPDU().getNonRepeaters();
                SnmpSubRequestIterator it = new SnmpSubRequestIterator(this.getIndex(), repeaters);
                it.setNoAppending(noAppending);
                return it;
            }
            return new SubRequestIteratorSupport(Collections.EMPTY_LIST.iterator());
        }

        public void updateNextRepetition() {
            if (!SnmpRequest.this.isBulkRequest()) {
                return;
            }
            this.query = null;
            SubRequestIterator repetitions = this.repetitions(true);
            repetitions.next();
            while (repetitions.hasNext()) {
                SnmpSubRequest nsreq = (SnmpSubRequest)repetitions.nextSubRequest();
                if (this.getStatus().getErrorStatus() == 0 && !this.vb.isException()) {
                    nsreq.query = null;
                    nsreq.scope = this.getNextScope(this.vb.getOid());
                    nsreq.getVariableBinding().setOid(this.vb.getOid());
                    continue;
                }
                if (!this.vb.isException()) continue;
                nsreq.query = null;
                nsreq.getVariableBinding().setOid(this.vb.getOid());
                nsreq.getVariableBinding().setVariable(this.vb.getVariable());
                nsreq.getStatus().setPhaseComplete(true);
            }
        }

        public final int getErrorStatus() {
            return this.getStatus().getErrorStatus();
        }

        public Object getUserObject() {
            return this.userObject;
        }

        public void setUserObject(Object userObject) {
            this.userObject = userObject;
        }
    }

    public class SnmpSubRequestIterator
    implements SubRequestIterator {
        private int cursor = 0;
        private int increment = 1;
        private boolean noAppending;

        protected SnmpSubRequestIterator() {
            this.cursor = 0;
        }

        protected SnmpSubRequestIterator(int offset, int increment) {
            this.cursor = offset;
            this.increment = increment;
        }

        protected void setNoAppending(boolean noAppending) {
            this.noAppending = noAppending;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean hasNext() {
            SnmpRequest snmpRequest = SnmpRequest.this;
            synchronized (snmpRequest) {
                PDU reqPDU = SnmpRequest.this.requestEvent.getPDU();
                if (reqPDU.getType() == -91) {
                    if (this.noAppending && this.cursor >= SnmpRequest.this.subrequests.size()) {
                        return false;
                    }
                    if (this.cursor < Math.min(reqPDU.size(), reqPDU.getNonRepeaters())) {
                        return true;
                    }
                    if (this.cursor < reqPDU.getNonRepeaters() + reqPDU.getMaxRepetitions() * SnmpRequest.this.getRepeaterCount()) {
                        List lastRow = SnmpRequest.this.lastRow(this.cursor);
                        if (lastRow != null) {
                            boolean allEndOfMibView = true;
                            SubRequest sreq = null;
                            Iterator it = lastRow.iterator();
                            while (it.hasNext()) {
                                sreq = (SubRequest)it.next();
                                if (sreq.getVariableBinding().getSyntax() == 130) continue;
                                allEndOfMibView = false;
                                break;
                            }
                            if (allEndOfMibView) {
                                if (sreq != null && sreq.getIndex() < SnmpRequest.this.subrequests.size()) {
                                    int lastElementIndex = sreq.getIndex();
                                    List tail = SnmpRequest.this.subrequests.subList(lastElementIndex + 1, SnmpRequest.this.subrequests.size());
                                    tail.clear();
                                    tail = SnmpRequest.this.response.getVariableBindings().subList(lastElementIndex + 1, SnmpRequest.this.response.size());
                                    tail.clear();
                                }
                                return false;
                            }
                        }
                        return SnmpRequest.this.response.getBERLength() < SnmpRequest.this.requestEvent.getMaxSizeResponsePDU();
                    }
                    return false;
                }
                return this.cursor < reqPDU.size();
            }
        }

        public SubRequest nextSubRequest() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            if (SnmpRequest.this.requestEvent.getPDU().getType() == -91 && this.cursor >= SnmpRequest.this.subrequests.size()) {
                while (this.cursor >= SnmpRequest.this.subrequests.size()) {
                    SnmpRequest.this.addRepeaterSubRequest();
                }
            }
            SubRequest sreq = (SubRequest)SnmpRequest.this.subrequests.get(this.cursor);
            this.cursor += this.increment;
            return sreq;
        }

        public void remove() {
            throw new UnsupportedOperationException("Remove is not supported on sub-requests");
        }

        public Object next() {
            return this.nextSubRequest();
        }

        public boolean equals(Object other) {
            if (other instanceof Request) {
                return ((Request)other).getTransactionID() == SnmpRequest.this.getTransactionID();
            }
            return false;
        }

        public int hashCode() {
            return SnmpRequest.this.getTransactionID();
        }
    }
}

