/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.sms.reflector.smsservice.internal;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.opennms.sms.reflector.smsservice.GatewayGroup;
import org.opennms.sms.reflector.smsservice.OnmsInboundMessageNotification;
import org.opennms.sms.reflector.smsservice.SmsService;
import org.opennms.sms.reflector.smsservice.internal.SmsServiceRegistrar;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.smslib.AGateway;
import org.smslib.GatewayException;
import org.smslib.ICallNotification;
import org.smslib.IGatewayStatusNotification;
import org.smslib.IInboundMessageNotification;
import org.smslib.IOutboundMessageNotification;
import org.smslib.IQueueSendingNotification;
import org.smslib.IUSSDNotification;
import org.smslib.InboundMessage;
import org.smslib.Message;
import org.smslib.OutboundMessage;
import org.smslib.Phonebook;
import org.smslib.SMSLibException;
import org.smslib.Service;
import org.smslib.Settings;
import org.smslib.TimeoutException;
import org.smslib.USSDRequest;
import org.smslib.balancing.LoadBalancer;
import org.smslib.crypto.KeyManager;
import org.smslib.queues.QueueManager;
import org.smslib.routing.Router;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SmsServiceImpl
implements SmsService {
    private static Logger log = LoggerFactory.getLogger(SmsServiceImpl.class);
    private Service m_service = new Service();
    private String m_modemId;
    private String m_modemPort;
    private int m_baudRate;
    private String m_manufacturer;
    private String m_model;
    private List<IOutboundMessageNotification> m_outboundListeners;
    private List<OnmsInboundMessageNotification> m_inboundListeners;
    private List<IGatewayStatusNotification> m_gatewayStatusListeners;
    private List<GatewayGroup> m_gatewayGroup;

    public List<IOutboundMessageNotification> getOutboundListeners() {
        return this.m_outboundListeners;
    }

    public void setOutboundListeners(List<IOutboundMessageNotification> outboundListeners) {
        this.m_outboundListeners = outboundListeners;
    }

    public List<OnmsInboundMessageNotification> getInboundListeners() {
        return this.m_inboundListeners;
    }

    public List<IGatewayStatusNotification> getGatewayStatusListeners() {
        return this.m_gatewayStatusListeners;
    }

    public void setGatewayStatusListeners(List<IGatewayStatusNotification> gatewayStatusListeners) {
        this.m_gatewayStatusListeners = gatewayStatusListeners;
    }

    public String getModemId() {
        return this.m_modemId;
    }

    public void setModemId(String modemId) {
        this.m_modemId = modemId;
    }

    public String getModemPort() {
        return this.m_modemPort;
    }

    public void setModemPort(String modemPort) {
        this.m_modemPort = modemPort;
    }

    public int getBaudRate() {
        return this.m_baudRate;
    }

    public void setBaudRate(int baudRate) {
        this.m_baudRate = baudRate;
    }

    public String getManufacturer() {
        return this.m_manufacturer;
    }

    public void setManufacturer(String manufacturer) {
        this.m_manufacturer = manufacturer;
    }

    public String getModel() {
        return this.m_model;
    }

    public void setModel(String model) {
        this.m_model = model;
    }

    public void start() {
        try {
            this.m_service.startService();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void stop() {
        this.m_service.stopService();
    }

    public void refresh(Map properties) {
        log.debug("Received a configuration refresh! " + properties);
    }

    @Override
    public void addGateway(AGateway gateway) throws GatewayException {
        this.m_service.addGateway(gateway);
    }

    @Override
    public boolean addToGroup(String groupName, String number) {
        return this.m_service.addToGroup(groupName, number);
    }

    @Override
    public boolean createGroup(String groupName) {
        return this.m_service.createGroup(groupName);
    }

    @Override
    public boolean deleteMessage(InboundMessage msg) throws TimeoutException, GatewayException, IOException, InterruptedException {
        return this.m_service.deleteMessage(msg);
    }

    @Override
    public ArrayList<String> expandGroup(String groupName) {
        return this.m_service.expandGroup(groupName);
    }

    @Override
    public AGateway findGateway(String gatewayId) {
        return this.m_service.findGateway(gatewayId);
    }

    @Override
    public ICallNotification getCallNotification() {
        return this.m_service.getCallNotification();
    }

    @Override
    public IGatewayStatusNotification getGatewayStatusNotification() {
        return this.m_service.getGatewayStatusNotification();
    }

    @Override
    public Collection<AGateway> getGateways() {
        return this.m_service.getGateways();
    }

    @Override
    public AGateway[] getGatewaysNET() {
        return this.m_service.getGatewaysNET();
    }

    @Override
    public int getInboundMessageCount(String gatewayId) {
        return this.m_service.getInboundMessageCount(gatewayId);
    }

    @Override
    public int getInboundMessageCount(AGateway gateway) {
        return this.m_service.getInboundMessageCount(gateway);
    }

    @Override
    public int getInboundMessageCount() {
        return this.m_service.getInboundMessageCount();
    }

    @Override
    public OnmsInboundMessageNotification getInboundNotification() {
        return ((InboundNotificationAdapter)this.m_service.getInboundNotification()).getOnmsInboundMessageNotification();
    }

    @Override
    public KeyManager getKeyManager() {
        return this.m_service.getKeyManager();
    }

    @Override
    public LoadBalancer getLoadBalancer() {
        return this.m_service.getLoadBalancer();
    }

    @Override
    public int getOutboundMessageCount(String gatewayId) {
        return this.m_service.getOutboundMessageCount(gatewayId);
    }

    @Override
    public int getOutboundMessageCount(AGateway gateway) {
        return this.m_service.getOutboundMessageCount(gateway);
    }

    @Override
    public int getOutboundMessageCount() {
        return this.m_service.getOutboundMessageCount();
    }

    @Override
    public IOutboundMessageNotification getOutboundNotification() {
        return this.m_service.getOutboundNotification();
    }

    @Override
    public QueueManager getQueueManager() {
        return this.m_service.getQueueManager();
    }

    @Override
    public IQueueSendingNotification getQueueSendingNotification() {
        return this.m_service.getQueueSendingNotification();
    }

    @Override
    public Router getRouter() {
        return this.m_service.getRouter();
    }

    @Override
    public Service.ServiceStatus getServiceStatus() {
        return this.m_service.getServiceStatus();
    }

    @Override
    public Settings getSettings() {
        return this.m_service.getSettings();
    }

    @Override
    public long getStartMillis() {
        return this.m_service.getStartMillis();
    }

    @Override
    public boolean queueMessage(OutboundMessage msg) {
        return this.m_service.queueMessage(msg);
    }

    @Override
    public boolean queueMessage(OutboundMessage msg, String gatewayId) {
        return this.m_service.queueMessage(msg, gatewayId);
    }

    @Override
    public int queueMessages(Collection<OutboundMessage> msgList) {
        return this.m_service.queueMessages(msgList);
    }

    @Override
    public int queueMessages(OutboundMessage[] msgArray) {
        return this.m_service.queueMessages(msgArray);
    }

    @Override
    public int queueMessages(Collection<OutboundMessage> msgList, String gatewayId) {
        return this.m_service.queueMessages(msgList, gatewayId);
    }

    @Override
    public int queueMessages(OutboundMessage[] msgArray, String gatewayId) {
        return this.m_service.queueMessages(msgArray, gatewayId);
    }

    @Override
    public InboundMessage readMessage(String gatewayId, String memLoc, int memIndex) throws TimeoutException, GatewayException, IOException, InterruptedException {
        return this.m_service.readMessage(gatewayId, memLoc, memIndex);
    }

    @Override
    public int readMessages(Collection<InboundMessage> msgList, InboundMessage.MessageClasses msgClass) throws TimeoutException, GatewayException, IOException, InterruptedException {
        return this.m_service.readMessages(msgList, msgClass);
    }

    @Override
    public InboundMessage[] readMessages(InboundMessage.MessageClasses msgClass) throws TimeoutException, GatewayException, IOException, InterruptedException {
        return this.m_service.readMessages(msgClass);
    }

    @Override
    public int readMessages(Collection<InboundMessage> msgList, InboundMessage.MessageClasses msgClass, String gatewayId) throws TimeoutException, GatewayException, IOException, InterruptedException {
        return this.m_service.readMessages(msgList, msgClass, gatewayId);
    }

    @Override
    public InboundMessage[] readMessages(InboundMessage.MessageClasses msgClass, String gatewayId) throws TimeoutException, GatewayException, IOException, InterruptedException {
        return this.m_service.readMessages(msgClass, gatewayId);
    }

    @Override
    public int readMessages(Collection<InboundMessage> msgList, InboundMessage.MessageClasses msgClass, AGateway gateway) throws TimeoutException, GatewayException, IOException, InterruptedException {
        return this.m_service.readMessages(msgList, msgClass, gateway);
    }

    @Override
    public InboundMessage[] readMessages(InboundMessage.MessageClasses msgClass, AGateway gateway) throws TimeoutException, GatewayException, IOException, InterruptedException {
        return this.m_service.readMessages(msgClass, gateway);
    }

    @Override
    public int readPhonebook(Phonebook phonebook, String gatewayId) throws TimeoutException, GatewayException, IOException, InterruptedException {
        return this.m_service.readPhonebook(phonebook, gatewayId);
    }

    @Override
    public boolean removeFromGroup(String groupName, String number) {
        return this.m_service.removeFromGroup(groupName, number);
    }

    @Override
    public boolean removeGateway(AGateway gateway) throws GatewayException {
        return this.m_service.removeGateway(gateway);
    }

    @Override
    public boolean removeGroup(String groupName) {
        return this.m_service.removeGroup(groupName);
    }

    @Override
    public boolean removeMessage(OutboundMessage msg) {
        return this.m_service.removeMessage(msg);
    }

    @Override
    public boolean sendMessage(OutboundMessage msg) throws TimeoutException, GatewayException, IOException, InterruptedException {
        return this.m_service.sendMessage(msg);
    }

    @Override
    public boolean sendMessage(OutboundMessage msg, String gatewayId) throws TimeoutException, GatewayException, IOException, InterruptedException {
        return this.m_service.sendMessage(msg, gatewayId);
    }

    @Override
    public int sendMessages(Collection<OutboundMessage> msgList) throws TimeoutException, GatewayException, IOException, InterruptedException {
        return this.m_service.sendMessages(msgList);
    }

    @Override
    public int sendMessages(OutboundMessage[] msgArray) throws TimeoutException, GatewayException, IOException, InterruptedException {
        return this.m_service.sendMessages(msgArray);
    }

    @Override
    public int sendMessages(Collection<OutboundMessage> msgList, String gatewayId) throws TimeoutException, GatewayException, IOException, InterruptedException {
        return this.m_service.sendMessages(msgList, gatewayId);
    }

    @Override
    public int sendMessages(OutboundMessage[] msgArray, String gatewayId) throws TimeoutException, GatewayException, IOException, InterruptedException {
        return this.m_service.sendMessages(msgArray, gatewayId);
    }

    @Override
    public void setCallNotification(ICallNotification callNotification) {
        this.m_service.setCallNotification(callNotification);
    }

    @Override
    public void setGatewayStatusNotification(IGatewayStatusNotification gatewayStatusNotification) {
        this.m_service.setGatewayStatusNotification(gatewayStatusNotification);
    }

    @Override
    public void setInboundNotification(OnmsInboundMessageNotification inboundNotification) {
        InboundNotificationAdapter adapter = new InboundNotificationAdapter(inboundNotification);
        this.m_service.setInboundNotification((IInboundMessageNotification)adapter);
    }

    @Override
    public void setLoadBalancer(LoadBalancer loadBalancer) {
        this.m_service.setLoadBalancer(loadBalancer);
    }

    @Override
    public void setOutboundNotification(IOutboundMessageNotification outboundNotification) {
        this.m_service.setOutboundNotification(outboundNotification);
    }

    @Override
    public void setQueueSendingNotification(IQueueSendingNotification queueSendingNotification) {
        this.m_service.setQueueSendingNotification(queueSendingNotification);
    }

    @Override
    public void setRouter(Router router) {
        this.m_service.setRouter(router);
    }

    @Override
    public void startService() throws SMSLibException, TimeoutException, GatewayException, IOException, InterruptedException {
        this.m_service.startService();
    }

    @Override
    public void stopService() throws TimeoutException, GatewayException, IOException, InterruptedException {
        this.m_service.stopService();
    }

    public void setService(Service m_service) {
        this.m_service = m_service;
    }

    public Service getService() {
        return this.m_service;
    }

    public void setGatewayGroup(List<GatewayGroup> m_gatewayGroup) {
        this.m_gatewayGroup = m_gatewayGroup;
    }

    public List<GatewayGroup> getGatewayGroup() {
        return this.m_gatewayGroup;
    }

    public void register(SmsServiceRegistrar smsServiceRegistrar) {
        smsServiceRegistrar.registerSmsService(this);
    }

    public void unregister(SmsServiceRegistrar smsServiceRegistrar) {
        smsServiceRegistrar.unregisterSmsService(this);
    }

    @Override
    public IUSSDNotification getUSSDNotification() {
        return this.m_service.getUSSDNotification();
    }

    @Override
    public boolean sendUSSDRequest(USSDRequest req, String gatewayId) throws GatewayException, TimeoutException, IOException, InterruptedException {
        return this.m_service.sendUSSDRequest(req, gatewayId);
    }

    @Override
    public void setUSSDNotification(IUSSDNotification notif) {
        this.m_service.setUSSDNotification(notif);
    }

    private class InboundNotificationAdapter
    implements IInboundMessageNotification {
        private OnmsInboundMessageNotification m_inboundNotification;

        public InboundNotificationAdapter(OnmsInboundMessageNotification onmsInbound) {
            this.m_inboundNotification = onmsInbound;
        }

        public void process(String gatewayId, Message.MessageTypes msgType, InboundMessage msg) {
            this.m_inboundNotification.process(SmsServiceImpl.this.findGateway(gatewayId), msgType, msg);
        }

        public OnmsInboundMessageNotification getOnmsInboundMessageNotification() {
            return this.m_inboundNotification;
        }
    }
}

