/*
 * Decompiled with CFR 0.152.
 */
package org.mvel.integration.impl;

import org.mvel.CompileException;
import org.mvel.integration.VariableResolver;

public class ClassImportResolver
implements VariableResolver {
    private String name;
    private Class type;

    public ClassImportResolver(String fqcn, String name) {
        this.name = name;
        try {
            this.type = Thread.currentThread().getContextClassLoader().loadClass(fqcn);
        }
        catch (Exception e) {
            throw new CompileException("failed import", e);
        }
    }

    public ClassImportResolver(String name, Class type) {
        this.name = name;
        this.type = type;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setStaticType(Class knownType) {
        this.type = knownType;
    }

    public String getName() {
        return this.name;
    }

    public Class getType() {
        Class<?> clazz;
        try {
            clazz = Class.forName("java.lang.Class");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        return clazz;
    }

    public Object getValue() {
        return this.type;
    }

    public int getFlags() {
        return 0;
    }

    public void setValue(Object value) {
    }
}

