/*
 * Decompiled with CFR 0.152.
 */
package org.mvel.conversion;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.HashMap;
import java.util.Map;
import org.mvel.ConversionException;
import org.mvel.ConversionHandler;
import org.mvel.conversion.Converter;

public class ShortCH
implements ConversionHandler {
    private static final Short TRUE;
    private static final Short FALSE;
    private static final Map<Class, Converter> CNV;

    static {
        Class<?> clazz;
        Class<?> clazz2;
        Class<?> clazz3;
        Class<?> clazz4;
        Class<?> clazz5;
        Class<?> clazz6;
        Class<?> clazz7;
        Class<?> clazz8;
        Class<?> clazz9;
        Class<?> clazz10;
        TRUE = new Short(1);
        FALSE = new Short(0);
        CNV = new HashMap<Class, Converter>();
        try {
            clazz10 = Class.forName("java.lang.String");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        CNV.put(clazz10, new Converter(){

            public Short convert(Object o) {
                return new Short(Short.parseShort((String)o));
            }
        });
        try {
            clazz9 = Class.forName("java.lang.Object");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        CNV.put(clazz9, new Converter(){

            public Object convert(Object o) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("java.lang.String");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                return ((Converter)CNV.get(clazz)).convert(String.valueOf(o));
            }
        });
        try {
            clazz8 = Class.forName("java.math.BigDecimal");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        CNV.put(clazz8, new Converter(){

            public Short convert(Object o) {
                return new Short(((BigDecimal)o).shortValue());
            }
        });
        try {
            clazz7 = Class.forName("java.math.BigInteger");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        CNV.put(clazz7, new Converter(){

            public Short convert(Object o) {
                return new Short(((BigInteger)o).shortValue());
            }
        });
        try {
            clazz6 = Class.forName("java.lang.Short");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        CNV.put(clazz6, new Converter(){

            public Object convert(Object o) {
                return o;
            }
        });
        try {
            clazz5 = Class.forName("java.lang.Integer");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        CNV.put(clazz5, new Converter(){

            public Short convert(Object o) {
                if ((Integer)o > Short.MAX_VALUE) {
                    throw new ConversionException("cannot coerce Integer to Short since the value (" + String.valueOf(o) + ") exceeds that maximum precision of Integer.");
                }
                return new Short(((Integer)o).shortValue());
            }
        });
        try {
            clazz4 = Class.forName("java.lang.Float");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        CNV.put(clazz4, new Converter(){

            public Short convert(Object o) {
                if (((Float)o).floatValue() > 32767.0f) {
                    throw new ConversionException("cannot coerce Float to Short since the value (" + String.valueOf(o) + ") exceeds that maximum precision of Integer.");
                }
                return new Short(((Float)o).shortValue());
            }
        });
        try {
            clazz3 = Class.forName("java.lang.Double");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        CNV.put(clazz3, new Converter(){

            public Short convert(Object o) {
                if ((Double)o > 32767.0) {
                    throw new ConversionException("cannot coerce Double to Short since the value (" + String.valueOf(o) + ") exceeds that maximum precision of Integer.");
                }
                return new Short(((Double)o).shortValue());
            }
        });
        try {
            clazz2 = Class.forName("java.lang.Long");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        CNV.put(clazz2, new Converter(){

            public Short convert(Object o) {
                if ((Long)o > 32767L) {
                    throw new ConversionException("cannot coerce Integer to Short since the value (" + String.valueOf(o) + ") exceeds that maximum precision of Integer.");
                }
                return new Short(((Long)o).shortValue());
            }
        });
        try {
            clazz = Class.forName("java.lang.Boolean");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        CNV.put(clazz, new Converter(){

            public Short convert(Object o) {
                if (((Boolean)o).booleanValue()) {
                    return TRUE;
                }
                return FALSE;
            }
        });
    }

    public Object convertFrom(Object in) {
        if (!CNV.containsKey(in.getClass())) {
            Class<?> clazz;
            try {
                clazz = Class.forName("java.lang.Short");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            throw new ConversionException("cannot convert type: " + in.getClass().getName() + " to: " + clazz.getName());
        }
        return CNV.get(in.getClass()).convert(in);
    }

    public boolean canConvertFrom(Class cls) {
        return CNV.containsKey(cls);
    }
}

