/*
 * Decompiled with CFR 0.152.
 */
package org.mvel.ast;

import java.lang.reflect.Method;
import org.mvel.ASTNode;
import org.mvel.Accessor;
import org.mvel.integration.VariableResolverFactory;
import org.mvel.optimizers.AccessorOptimizer;
import org.mvel.optimizers.OptimizerFactory;
import org.mvel.util.ArrayTools;
import org.mvel.util.ParseTools;

public class StaticMethodNode
extends ASTNode {
    private transient Accessor accessor;
    private String method;
    private Class declaringClass;

    public StaticMethodNode(char[] expr, int fields) {
        super(expr, fields);
        this.method = new String(ParseTools.subset(expr, ArrayTools.findFirst('(', expr)));
    }

    public Object getReducedValueAccelerated(Object ctx, Object thisValue, VariableResolverFactory factory) {
        try {
            return this.valRet(this.accessor.getValue(this.declaringClass, thisValue, factory));
        }
        catch (NullPointerException e) {
            if (this.accessor == null) {
                AccessorOptimizer aO = OptimizerFactory.getThreadAccessorOptimizer();
                this.declaringClass = ((Method)factory.getVariableResolver(this.method).getValue()).getDeclaringClass();
                this.accessor = aO.optimizeAccessor(this.name, this.declaringClass, thisValue, factory, false);
                return this.valRet(aO.getResultOptPass());
            }
            throw e;
        }
    }

    public Object getReducedValue(Object ctx, Object thisValue, VariableResolverFactory factory) {
        return super.getReducedValue(ctx, thisValue, factory);
    }
}

