/*
 * Decompiled with CFR 0.152.
 */
package org.openoss.ossj.fm.monitor.spring;

import java.io.Serializable;
import java.rmi.RMISecurityManager;
import java.util.Properties;
import javax.jms.InvalidDestinationException;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.ObjectMessage;
import javax.jms.Queue;
import javax.jms.QueueConnection;
import javax.jms.QueueConnectionFactory;
import javax.jms.QueueSender;
import javax.jms.QueueSession;
import javax.jms.TextMessage;
import javax.jms.Topic;
import javax.jms.TopicConnection;
import javax.jms.TopicConnectionFactory;
import javax.jms.TopicPublisher;
import javax.jms.TopicSession;
import javax.naming.InitialContext;
import javax.naming.NameNotFoundException;
import javax.naming.NamingException;
import javax.oss.UnsupportedOperationException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.openoss.ossj.fm.monitor.spring.AlarmMonitorDaoImpl;
import org.openoss.ossj.fm.monitor.spring.OssBean;
import org.openoss.ossj.fm.monitor.spring.OssBeanImpl;
import org.openoss.ossj.fm.monitor.spring.OssBeanTransmitter;

public class OssBeanTransmitterImpl
extends OssBeanImpl
implements OssBean,
OssBeanTransmitter {
    protected Properties env;
    protected InitialContext ic = null;
    protected Topic eventTopicJVT = null;
    protected TopicSession jmsSessionJVT = null;
    protected TopicConnection connJVT = null;
    protected TopicPublisher jvtEventPublisher = null;
    protected TopicPublisher xvtEventPublisher = null;
    protected boolean connected = false;
    protected String logname = "not set";
    protected TopicSession jmsSessionXVT = null;
    protected TopicConnection connXVT = null;
    protected Topic eventTopicXVT = null;
    protected QueueSession jmsSessionQueue = null;
    protected QueueConnection queueConnection = null;
    protected Queue xmlMessageQueue = null;
    protected QueueSender queueSender = null;
    int sentJvtEventTopic_count = 0;
    int sentXvtEventTopic_count = 0;
    int sentMessageQue_count = 0;
    int sentReplyMessageQue_count = 0;
    protected static Log logger = LogFactory.getLog(AlarmMonitorDaoImpl.class);
    protected String ossBeanName = "name_not_set";
    private int connection_retry_period = 10000;
    private String jndi_fact_class_name = null;
    private String jndi_url = null;
    private String bean_naming_package = null;
    private String jvt_home = null;
    private String topic_connector_factory_name = null;
    private String jvt_event_topic_name = null;
    private String xvt_event_topic_name = null;
    private String queue_connection_factory_name = null;
    private String message_queue = null;
    private String jmsuser = "guest";
    private String jmspassword = "guest";

    public void setLogName(String _logName) {
        this.logname = _logName;
        logger = LogFactory.getLog((String)_logName);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("TX:" + this.ossBeanName + ":" + this.getClass().getSimpleName() + ".setLogger() alarm logger set; Logname: " + _logName));
        }
    }

    public String getLogName() {
        return this.logname;
    }

    public String getName() {
        return this.ossBeanName;
    }

    public void setName(String _name) {
        if (_name == null) {
            throw new IllegalStateException("OssBean" + this.getClass().getSimpleName() + " Name cannot be set null");
        }
        this.ossBeanName = _name;
    }

    public void setConnection_retry_period(int _connection_retry_period) {
        this.connection_retry_period = _connection_retry_period;
    }

    public void setJmsuser(String jmsuser) {
        this.jmsuser = jmsuser;
    }

    public String getJmsuser() {
        return this.jmsuser;
    }

    public void setJmspassword(String jmspassword) {
        this.jmspassword = jmspassword;
    }

    public String getJmspassword() {
        return this.jmspassword;
    }

    public void setbean_naming_package(String _bean_naming_package) {
        this.bean_naming_package = _bean_naming_package;
    }

    public void setjndi_fact_class_name(String _jndi_fact_class_name) {
        this.jndi_fact_class_name = _jndi_fact_class_name;
    }

    public void setjndi_url(String _jndi_url) {
        this.jndi_url = _jndi_url;
    }

    public void setjvt_home(String _jvt_home) {
        this.jvt_home = _jvt_home;
    }

    public void setjvt_event_topic_name(String _jvt_event_topic_name) {
        this.jvt_event_topic_name = _jvt_event_topic_name;
    }

    public void settopic_connector_factory_name(String _topic_connector_factory_name) {
        this.topic_connector_factory_name = _topic_connector_factory_name;
    }

    public void setxvt_event_topic_name(String _xvt_event_topic_name) {
        this.xvt_event_topic_name = _xvt_event_topic_name;
    }

    public void setmessage_queue(String _message_queue) {
        this.message_queue = _message_queue;
    }

    public void setqueue_connection_factory_name(String _queue_connection_factory_name) {
        this.queue_connection_factory_name = _queue_connection_factory_name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        this.runBean.setRun(true);
        this.connected = false;
        while (this.runBean.isRun()) {
            if (this.runBean.isRun() && !this.connected) {
                this.runBean.setStatus(1);
                this.initialise_JMS_transmitter();
                if (this.connected) {
                    this.runBean.setStatus(3);
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("TX:" + this.ossBeanName + ":" + this.getClass().getSimpleName() + ": CONNECTED : ready to transmit messages"));
                    }
                } else if (logger.isDebugEnabled()) {
                    logger.debug((Object)("TX:" + this.ossBeanName + ":" + this.getClass().getSimpleName() + ": NOT CONNECTED Waiting " + this.connection_retry_period + "ms before trying to reconnect"));
                }
            }
            if (!this.runBean.isRun()) continue;
            OssBeanTransmitterImpl ossBeanTransmitterImpl = this;
            synchronized (ossBeanTransmitterImpl) {
                try {
                    this.wait(this.connection_retry_period);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
        this.runBean.setStatus(4);
        try {
            this.kill();
            this.runBean.setStatus(5);
        }
        catch (Exception ex) {
            logger.error((Object)("TX:" + this.ossBeanName + ":" + this.getClass().getSimpleName() + ".run(): Exception in kill(): " + ex));
        }
        finally {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("TX:" + this.ossBeanName + ":" + this.getClass().getSimpleName() + ": STOPPED"));
            }
            this.runBean.setStatus(5);
        }
    }

    public synchronized void stop() {
        if (this.runBean.isRun()) {
            this.runBean.setStatus(4);
            this.runBean.setRun(false);
            this.connected = false;
        }
        this.notify();
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("TX:" + this.ossBeanName + ":" + this.getClass().getSimpleName() + ".stop(): stopping process"));
        }
    }

    private synchronized void initialise_JMS_transmitter() {
        if (this.connected) {
            throw new IllegalStateException("TX:" + this.ossBeanName + ":" + this.getClass().getSimpleName() + "initialise_JMS_transmitter(): Receiver Already Initialised. Use Stop() before re-initialising");
        }
        try {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("TX:" + this.ossBeanName + ":" + this.getClass().getSimpleName() + "initialise_JMS_transmitter(): NOT connected - Trying to Initialise Session"));
            }
            this.setupConnections();
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("TX:" + this.ossBeanName + ":" + this.getClass().getSimpleName() + "initialise_JMS_transmitter(): Session Initialised "));
            }
            if (this.jmsSessionXVT != null) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("TX:" + this.ossBeanName + ":" + this.getClass().getSimpleName() + "initialise_JMS_transmitter(): Subscribing to OSS/J XVT jms session: "));
                }
                this.xvtEventPublisher = this.jmsSessionXVT.createPublisher(this.eventTopicXVT);
            }
            if (this.jmsSessionJVT != null) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("TX:" + this.ossBeanName + ":" + this.getClass().getSimpleName() + "initialise_JMS_transmitter(): Subscribing to OSS/J JVT jms session: "));
                }
                this.jvtEventPublisher = this.jmsSessionXVT.createPublisher(this.eventTopicJVT);
            }
            if (this.jmsSessionQueue != null) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("TX:" + this.ossBeanName + ":" + this.getClass().getSimpleName() + "initialise_JMS_transmitter(): Subscribing to OSS/J XVT message queue: "));
                }
                this.queueSender = this.jmsSessionQueue.createSender(this.xmlMessageQueue);
            }
            this.connected = true;
        }
        catch (Exception ex) {
            logger.error((Object)("TX:" + this.ossBeanName + ":" + this.getClass().getSimpleName() + "initialise_JMS_transmitter(): while connecting: Exception: " + ex));
            try {
                this.connected = false;
                this.kill();
            }
            catch (Exception ex2) {
                logger.error((Object)("TX:" + this.ossBeanName + ":" + this.getClass().getSimpleName() + "initialise_JMS_transmitter(): while connecting: Exception in kill(): " + ex2));
            }
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("TX:" + this.ossBeanName + ":" + this.getClass().getSimpleName() + "initialise_JMS_transmitter(): jms connected - use run() to wait for events ;"));
        }
    }

    public void init() {
        if (!this.isConnected()) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("TX:" + this.ossBeanName + ":" + this.getClass().getSimpleName() + "init(): running initialise_JMS_transmitter(): to connect to jms"));
            }
            this.initialise_JMS_transmitter();
        } else if (logger.isDebugEnabled()) {
            logger.debug((Object)("TX:" + this.ossBeanName + ":" + this.getClass().getSimpleName() + "init(): already connected to jms not running initialise_JMS_transmitter()"));
        }
    }

    public void pause() throws UnsupportedOperationException {
        logger.error((Object)"AlarmEventReceiverImpl().pause() PAUSE NOT IMPLIMENTED");
        throw new UnsupportedOperationException("AlarmEventReceiverImpl().pause() PAUSE NOT IMPLIMENTED");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setupConnections() throws Exception {
        block44: {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)this.getStaticConfiguration());
            }
            this.ic = null;
            try {
                this.env = new Properties();
                this.env.setProperty("java.naming.provider.url", this.jndi_url);
                this.env.setProperty("java.naming.factory.initial", this.jndi_fact_class_name);
                this.env.setProperty("java.naming.factory.url.pkgs", this.bean_naming_package);
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("TX:" + this.ossBeanName + ":" + this.getClass().getSimpleName() + ": InitialContext env property java.naming.provider.url= " + this.env.getProperty("java.naming.provider.url")));
                    logger.debug((Object)("TX:" + this.ossBeanName + ":" + this.getClass().getSimpleName() + ": InitialContext env property java.naming.factory.initial= " + this.env.getProperty("java.naming.factory.initial")));
                    logger.debug((Object)("TX:" + this.ossBeanName + ":" + this.getClass().getSimpleName() + ": InitialContext env property java.naming.factory.url.pkgs= " + this.env.getProperty("java.naming.factory.url.pkgs")));
                }
                if (System.getSecurityManager() == null) {
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("TX:" + this.ossBeanName + ":" + this.getClass().getSimpleName() + ": setting java.security.policy= " + System.getProperty("java.security.policy")));
                    }
                    System.setSecurityManager(new RMISecurityManager());
                }
                this.ic = new InitialContext(this.env);
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("TX:" + this.ossBeanName + ":" + this.getClass().getSimpleName() + ": Initial context created"));
                }
            }
            catch (NamingException ne) {
                logger.error((Object)("TX:" + this.ossBeanName + ":" + this.getClass().getSimpleName() + ": Problem creating InitialContext:" + ne));
                this.ic = null;
            }
            if (this.ic != null) {
                try {
                    try {
                        if (logger.isDebugEnabled()) {
                            logger.debug((Object)("TX:" + this.ossBeanName + ":" + this.getClass().getSimpleName() + ": Trying to connect to message topics and queues"));
                        }
                        TopicConnectionFactory tcf = null;
                        if (this.topic_connector_factory_name != null) {
                            try {
                                if (logger.isDebugEnabled()) {
                                    logger.debug((Object)("TX:" + this.ossBeanName + ":" + this.getClass().getSimpleName() + ": trying to connect to TopicConnectionFactory"));
                                }
                                tcf = (TopicConnectionFactory)this.ic.lookup(this.topic_connector_factory_name);
                                if (logger.isDebugEnabled()) {
                                    logger.debug((Object)("TX:" + this.ossBeanName + ":" + this.getClass().getSimpleName() + ": success - connected to TopicConnectionFactory"));
                                }
                            }
                            catch (NamingException ne) {
                                logger.error((Object)("TX:" + this.ossBeanName + ":" + this.getClass().getSimpleName() + ": Problem connecting to TopicConnectionFactory: " + ne));
                                tcf = null;
                            }
                        }
                        if (tcf != null) {
                            if (this.jvt_event_topic_name != null) {
                                try {
                                    if (logger.isDebugEnabled()) {
                                        logger.debug((Object)("TX:" + this.ossBeanName + ":" + this.getClass().getSimpleName() + ": trying to connect to JVT event topic"));
                                    }
                                    this.connJVT = tcf.createTopicConnection(this.jmsuser, this.jmspassword);
                                    this.jmsSessionJVT = this.connJVT.createTopicSession(false, 1);
                                    this.eventTopicJVT = (Topic)this.ic.lookup(this.jvt_event_topic_name);
                                    this.connJVT.start();
                                    if (logger.isDebugEnabled()) {
                                        logger.debug((Object)("TX:" + this.ossBeanName + ":" + this.getClass().getSimpleName() + ": success - connected to JVT event topic"));
                                    }
                                }
                                catch (NamingException ne) {
                                    logger.error((Object)("TX:" + this.ossBeanName + ":" + this.getClass().getSimpleName() + ": Problem connecting to JVT event topic: " + ne));
                                    this.jmsSessionJVT = null;
                                    this.eventTopicJVT = null;
                                    this.connJVT = null;
                                }
                            }
                            if (this.xvt_event_topic_name != null) {
                                try {
                                    if (logger.isDebugEnabled()) {
                                        logger.debug((Object)("TX:" + this.ossBeanName + ":" + this.getClass().getSimpleName() + ": trying to connect to XVT event topic"));
                                    }
                                    this.connXVT = tcf.createTopicConnection(this.jmsuser, this.jmspassword);
                                    this.jmsSessionXVT = this.connXVT.createTopicSession(false, 1);
                                    this.eventTopicXVT = (Topic)this.ic.lookup(this.xvt_event_topic_name);
                                    this.connXVT.start();
                                    if (logger.isDebugEnabled()) {
                                        logger.debug((Object)("TX:" + this.ossBeanName + ":" + this.getClass().getSimpleName() + ": success - connected to XVT event topic"));
                                    }
                                }
                                catch (NamingException ne) {
                                    logger.error((Object)("TX:" + this.ossBeanName + ":" + this.getClass().getSimpleName() + ": Problem connecting to XVT event topic: " + ne));
                                    this.jmsSessionXVT = null;
                                    this.eventTopicXVT = null;
                                    this.connXVT = null;
                                }
                            }
                        }
                        QueueConnectionFactory qcf = null;
                        if (this.queue_connection_factory_name != null) {
                            try {
                                if (logger.isDebugEnabled()) {
                                    logger.debug((Object)("TX:" + this.ossBeanName + ":" + this.getClass().getSimpleName() + ": trying to connect to QueueConnectionFactory"));
                                }
                                qcf = (QueueConnectionFactory)this.ic.lookup(this.queue_connection_factory_name);
                                if (logger.isDebugEnabled()) {
                                    logger.debug((Object)("TX:" + this.ossBeanName + ":" + this.getClass().getSimpleName() + ": success - connected to QueueConnectionFactory"));
                                }
                            }
                            catch (NamingException ne) {
                                logger.error((Object)("TX:" + this.ossBeanName + ":" + this.getClass().getSimpleName() + ": Problem connecting to QueueConnectionFactory: " + ne));
                                qcf = null;
                            }
                        }
                        if (qcf == null || this.message_queue == null) break block44;
                        try {
                            if (logger.isDebugEnabled()) {
                                logger.debug((Object)("TX:" + this.ossBeanName + ":" + this.getClass().getSimpleName() + ": trying to create queueConnection"));
                            }
                            this.queueConnection = qcf.createQueueConnection(this.jmsuser, this.jmspassword);
                            this.jmsSessionQueue = this.queueConnection.createQueueSession(false, 1);
                            if (!"".equals(this.message_queue)) {
                                this.xmlMessageQueue = (Queue)this.ic.lookup(this.message_queue);
                            } else if (logger.isDebugEnabled()) {
                                logger.debug((Object)("TX:" + this.ossBeanName + ":" + this.getClass().getSimpleName() + ": message Queue name is empty. You can only use sendMessageQueueMsgToQueue()"));
                            }
                            this.queueConnection.start();
                            if (logger.isDebugEnabled()) {
                                logger.debug((Object)("TX:" + this.ossBeanName + ":" + this.getClass().getSimpleName() + ": success - queueConnection started"));
                            }
                        }
                        catch (NamingException ne) {
                            logger.error((Object)("TX:" + this.ossBeanName + ":" + this.getClass().getSimpleName() + ": Problem connecting to XML MESSAGE QUEUES :" + ne));
                            this.queueConnection = null;
                            this.xmlMessageQueue = null;
                            this.jmsSessionQueue = null;
                        }
                    }
                    catch (Exception ex) {
                        logger.error((Object)("TX:" + this.ossBeanName + ":" + this.getClass().getSimpleName() + ": Problem connecting to JMS sessions :" + ex));
                    }
                }
                catch (Exception ex) {
                    logger.error((Object)("TX:" + this.ossBeanName + ":" + this.getClass().getSimpleName() + ": Unknown problem connecting receiver: " + ex));
                }
                finally {
                    this.ic.close();
                }
            }
        }
    }

    private void kill() throws Exception {
        if (this.connJVT != null) {
            this.connJVT.stop();
            this.jmsSessionJVT.close();
            this.connJVT.close();
            this.jmsSessionJVT = null;
            this.eventTopicJVT = null;
            this.connJVT = null;
        }
        if (this.connXVT != null) {
            this.connXVT.stop();
            this.jmsSessionXVT.close();
            this.connXVT.close();
            this.jmsSessionXVT = null;
            this.eventTopicXVT = null;
            this.connXVT = null;
        }
        if (this.queueConnection != null) {
            this.queueConnection.stop();
            this.jmsSessionQueue.close();
            this.queueConnection.close();
            this.queueConnection = null;
            this.xmlMessageQueue = null;
            this.jmsSessionQueue = null;
        }
        this.connected = false;
    }

    public boolean isConnected() {
        return this.connected;
    }

    public int getsentJvtEventTopic_count() {
        return this.sentJvtEventTopic_count;
    }

    public int getsentXvtEventTopic_count() {
        return this.sentXvtEventTopic_count;
    }

    public int getsentMessageQue_count() {
        return this.sentMessageQue_count;
    }

    public int getSentReplyMessageQue_count() {
        return this.sentReplyMessageQue_count;
    }

    public String getRuntimeStatistics() {
        String statistics = "messages sent:\tMessageQue:" + this.sentMessageQue_count + "\tJvtEventTopic:" + this.sentJvtEventTopic_count + "\tXvtEventTopic:" + this.sentXvtEventTopic_count + "\tXvtReplyMessage:" + this.sentReplyMessageQue_count;
        return statistics;
    }

    public String getStaticConfiguration() {
        String connectioninfo = "TX:" + this.ossBeanName + ":" + this.getClass().getSimpleName() + " - connection properties:\n" + "\t   jndi_fact_class_name =" + this.jndi_fact_class_name + "\n" + "\t   jndi_url =" + this.jndi_url + "\n" + "\t   bean_naming_package =" + this.bean_naming_package + "\n" + "\t   jvt_home =" + this.jvt_home + "\n" + "\t   topic_connection_factory_name =" + this.topic_connector_factory_name + "\n" + "\t   jvt_event_topic_name =" + this.jvt_event_topic_name + "\n" + "\t   xvt_event_topic_name =" + this.xvt_event_topic_name + "\n" + "\t   queue_connection_factory_name =" + this.queue_connection_factory_name + "\n" + "\t   message_queue =" + this.message_queue;
        return connectioninfo;
    }

    public synchronized void sendJvtEventTopicMsg(Message msg) throws IllegalStateException {
        if (!this.connected) {
            throw new IllegalStateException("TX:" + this.ossBeanName + ":" + this.getClass().getSimpleName() + "sendJvtEventTopic: Transmitter not connected: ");
        }
        if (this.jvtEventPublisher == null) {
            throw new IllegalStateException("TX:" + this.ossBeanName + ":" + this.getClass().getSimpleName() + "sendJvtEventTopic: jvtEventPublisher not created (jvtEventPublisher=NULL)");
        }
        try {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("TX:" + this.ossBeanName + ":" + this.getClass().getSimpleName() + "sendJvtEventTopicMsg(): transmitting message to jvtEventPublisher Message:" + msg.toString()));
            }
            this.jvtEventPublisher.publish(msg);
            ++this.sentJvtEventTopic_count;
        }
        catch (JMSException jex) {
            this.connected = false;
            this.notify();
            throw new IllegalStateException("TX:" + this.ossBeanName + ":" + this.getClass().getSimpleName() + "sendJvtEventTopicMsg: cannot send message: Error:", jex);
        }
    }

    public synchronized void sendXvtEventTopicMsg(Message msg) throws IllegalStateException {
        if (!this.connected) {
            throw new IllegalStateException("TX:" + this.ossBeanName + ":" + this.getClass().getSimpleName() + "sendXvtEventTopic: Transmitter not connected: ");
        }
        if (this.xvtEventPublisher == null) {
            throw new IllegalStateException("TX:" + this.ossBeanName + ":" + this.getClass().getSimpleName() + "sendXvtEventTopic: xvtEventPublisher not created (xvtEventPublisher=NULL)");
        }
        try {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("TX:" + this.ossBeanName + ":" + this.getClass().getSimpleName() + "sendXvtEventTopicMsg(): transmitting message to xvtEventPublisher Message:" + msg.toString()));
            }
            this.xvtEventPublisher.publish(msg);
            ++this.sentXvtEventTopic_count;
        }
        catch (JMSException jex) {
            this.connected = false;
            this.notify();
            throw new IllegalStateException("TX:" + this.ossBeanName + ":" + this.getClass().getSimpleName() + "sendJvtEventTopicMsg: cannot send message: Error:", jex);
        }
    }

    public synchronized void sendMessageQueueMsg(Message msg) throws IllegalStateException {
        if (!this.connected) {
            throw new IllegalStateException("TX:" + this.ossBeanName + ":" + this.getClass().getSimpleName() + "sendMessageQueue: Transmitter not connected: ");
        }
        if (this.queueSender == null) {
            throw new IllegalStateException("TX:" + this.ossBeanName + ":" + this.getClass().getSimpleName() + "sendMessageQueue: queueSender not created (queueSender=NULL)");
        }
        try {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("TX:" + this.ossBeanName + ":" + this.getClass().getSimpleName() + "transmit_messages(): transmitting message to queueSender Message:" + msg.toString()));
            }
            this.queueSender.send(msg);
            ++this.sentMessageQue_count;
        }
        catch (JMSException jex) {
            this.connected = false;
            this.notify();
            throw new IllegalStateException("TX:" + this.ossBeanName + ":" + this.getClass().getSimpleName() + "sendMessageQueue: cannot send message: Error:", jex);
        }
    }

    public synchronized void sendMessageQueueMsgToQueue(Message msg, Queue message_queue) throws IllegalStateException {
        if (!this.connected) {
            throw new IllegalStateException("TX:" + this.ossBeanName + ":" + this.getClass().getSimpleName() + "sendMessageQueue: Transmitter not connected: ");
        }
        if (message_queue == null) {
            throw new IllegalArgumentException("TX:" + this.ossBeanName + ":" + this.getClass().getSimpleName() + "sendMessageQueue: invalid queue to send message (message_queue=NULL)");
        }
        if (msg == null) {
            throw new IllegalArgumentException("TX:" + this.ossBeanName + ":" + this.getClass().getSimpleName() + "sendMessageQueue: arguemen - message to send (msg=NULL)");
        }
        try {
            QueueSender localQueueSender = this.jmsSessionQueue.createSender(message_queue);
            localQueueSender.send(msg);
            ++this.sentReplyMessageQue_count;
        }
        catch (InvalidDestinationException idex) {
            throw new IllegalStateException("TX:" + this.ossBeanName + ":" + this.getClass().getSimpleName() + "sendMessageQueue: Invalid Destination Exception: Error:", idex);
        }
        catch (JMSException jex) {
            this.connected = false;
            this.notify();
            throw new IllegalStateException("TX:" + this.ossBeanName + ":" + this.getClass().getSimpleName() + "sendMessageQueue: cannot send message: Error:", jex);
        }
    }

    public synchronized void sendMessageQueueMsgToQueue(Message msg, String message_queue_name) throws IllegalStateException {
        if (!this.connected) {
            throw new IllegalStateException("TX:" + this.ossBeanName + ":" + this.getClass().getSimpleName() + "sendMessageQueue: Transmitter not connected: ");
        }
        if (message_queue_name == null) {
            throw new IllegalArgumentException("TX:" + this.ossBeanName + ":" + this.getClass().getSimpleName() + "sendMessageQueue: invalid name of queue to send message (message_queue_Name=NULL)");
        }
        if (msg == null) {
            throw new IllegalArgumentException("TX:" + this.ossBeanName + ":" + this.getClass().getSimpleName() + "sendMessageQueue: arguemen - message to send (msg=NULL)");
        }
        try {
            Queue sendXmlMessageQueue = (Queue)this.ic.lookup(message_queue_name);
            QueueSender localQueueSender = this.jmsSessionQueue.createSender(sendXmlMessageQueue);
            localQueueSender.send(msg);
            ++this.sentReplyMessageQue_count;
        }
        catch (NameNotFoundException notfoundex) {
            throw new IllegalStateException("TX:" + this.ossBeanName + ":" + this.getClass().getSimpleName() + "sendMessageQueue: cannot resolve message_que_name: " + message_queue_name + " Error:", notfoundex);
        }
        catch (InvalidDestinationException idex) {
            throw new IllegalStateException("TX:" + this.ossBeanName + ":" + this.getClass().getSimpleName() + "sendMessageQueue: Invalid Destination Exception: Error:", idex);
        }
        catch (NamingException nex) {
            this.connected = false;
            this.notify();
            throw new IllegalStateException("TX:" + this.ossBeanName + ":" + this.getClass().getSimpleName() + "sendMessageQueue: problem resolving message_que_name: Error:", nex);
        }
        catch (JMSException jex) {
            this.connected = false;
            this.notify();
            throw new IllegalStateException("TX:" + this.ossBeanName + ":" + this.getClass().getSimpleName() + "sendMessageQueue: cannot send message: Error:", jex);
        }
    }

    public ObjectMessage makeJvtTopicMessage(Serializable obj) throws IllegalStateException, IllegalArgumentException {
        if (obj == null) {
            throw new IllegalArgumentException("TX:" + this.ossBeanName + ":" + this.getClass().getSimpleName() + "makeJvtTopicMessage(): cannot create JMS message for NULL object ");
        }
        if (!this.connected) {
            throw new IllegalStateException("TX:" + this.ossBeanName + ":" + this.getClass().getSimpleName() + "makeJvtTopicMessage(): cannot create JMS message Transmitter not connected: ");
        }
        if (this.jmsSessionJVT == null) {
            throw new IllegalStateException("TX:" + this.ossBeanName + ":" + this.getClass().getSimpleName() + "makeSessionQueueMessage(): cannot create JMS message jmsSessionJVT==NULL");
        }
        ObjectMessage objEvtMsg = null;
        try {
            objEvtMsg = this.jmsSessionJVT.createObjectMessage(obj);
        }
        catch (JMSException jmsex) {
            throw new IllegalStateException("TX:" + this.ossBeanName + ":" + this.getClass().getSimpleName() + "makeJvtTopicMessage(): cannot create JMS message. Error:", jmsex);
        }
        return objEvtMsg;
    }

    public TextMessage makeXvtTopicMessage(String xvtMessage) throws IllegalStateException, IllegalArgumentException {
        if (xvtMessage == null) {
            throw new IllegalArgumentException("TX:" + this.ossBeanName + ":" + this.getClass().getSimpleName() + "makeXvtTopicMessage(): cannot create JMS message for NULL object ");
        }
        if (!this.connected) {
            throw new IllegalStateException("TX:" + this.ossBeanName + ":" + this.getClass().getSimpleName() + "makeXvtTopicMessage(): cannot create JMS message Transmitter not connected");
        }
        if (this.jmsSessionXVT == null) {
            throw new IllegalStateException("TX:" + this.ossBeanName + ":" + this.getClass().getSimpleName() + "makeSessionQueueMessage(): cannot create JMS message jmsSessionXVT==NULL");
        }
        TextMessage txtEvtMsg = null;
        try {
            txtEvtMsg = this.jmsSessionXVT.createTextMessage(xvtMessage);
        }
        catch (JMSException jmsex) {
            throw new IllegalStateException("TX:" + this.ossBeanName + ":" + this.getClass().getSimpleName() + "makeXvtTopicMessage: cannot create JMS message. Error:", jmsex);
        }
        return txtEvtMsg;
    }

    public TextMessage makeSessionQueueMessage(String xvtMessage) throws IllegalStateException, IllegalArgumentException {
        if (xvtMessage == null) {
            throw new IllegalArgumentException("TX:" + this.ossBeanName + ":" + this.getClass().getSimpleName() + "makeSessionQueueMessage(): cannot create JMS message for NULL object ");
        }
        if (!this.connected) {
            throw new IllegalStateException("TX:" + this.ossBeanName + ":" + this.getClass().getSimpleName() + "makeSessionQueueMessage(): cannot create JMS message Transmitter not connected");
        }
        if (this.jmsSessionQueue == null) {
            throw new IllegalStateException("TX:" + this.ossBeanName + ":" + this.getClass().getSimpleName() + "makeSessionQueueMessage(): cannot create JMS message jmsSessionQueue==NULL");
        }
        TextMessage txtMsg = null;
        try {
            txtMsg = this.jmsSessionQueue.createTextMessage(xvtMessage);
        }
        catch (JMSException jmsex) {
            throw new IllegalStateException("TX:" + this.ossBeanName + ":" + this.getClass().getSimpleName() + "makeSessionQueueMessage(): cannot create JMS message. Error:", jmsex);
        }
        return txtMsg;
    }

    public Topic getEventTopicJVT() {
        return this.eventTopicJVT;
    }

    public Topic getEventTopicXVT() {
        return this.eventTopicXVT;
    }

    public Queue getXmlMessageQueue() {
        return this.xmlMessageQueue;
    }
}

