/*
 * Decompiled with CFR 0.152.
 */
package org.openoss.ossj.fm.monitor.spring;

import java.util.Enumeration;
import java.util.Hashtable;
import javax.oss.UnsupportedOperationException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.openoss.ossj.fm.monitor.spring.OssBean;
import org.openoss.ossj.fm.monitor.spring.OssBeanRunner;
import org.openoss.ossj.fm.monitor.spring.OssBeanRunnerList;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.support.ClassPathXmlApplicationContext;

public class OssBeanRunnerImpl
implements OssBeanRunner {
    private static ClassPathXmlApplicationContext ossBeanRunnerContext;
    private String[] ossBeanList = null;
    private Hashtable ossBeans = null;
    private boolean initialised = false;
    private String beanName = "";
    private int status = 0;
    private static Log logger;
    private static String logname;
    private static String[] localOssBeanRunnerSpringContextXml;
    private static ApplicationContext parentApplicationContext;

    public void setLogName(String _logname) {
        logname = _logname;
        logger = LogFactory.getLog((String)logname);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("OssBeanRunnerImpl().setLogger() alarm logger set; Logname: " + _logname));
        }
    }

    public String getLogName() {
        return logname;
    }

    public String getName() {
        return this.beanName;
    }

    public void setName(String _beanName) {
        this.beanName = _beanName;
    }

    public void setOssBeanRunnerSpringContextXml(String[] _localOssBeanRunnerSpringContextXml) {
        localOssBeanRunnerSpringContextXml = _localOssBeanRunnerSpringContextXml;
    }

    public void setParentApplicationContext(ApplicationContext parentApplicationContext) {
        OssBeanRunnerImpl.parentApplicationContext = parentApplicationContext;
    }

    public void init() throws IllegalStateException {
        Thread rxThread;
        OssBean ossbean;
        this.ossBeans = new Hashtable();
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"OssBeanRunnerImpl.init(): application context files for ossBean processes:");
            for (int i = 0; i < localOssBeanRunnerSpringContextXml.length; ++i) {
                logger.debug((Object)("    " + localOssBeanRunnerSpringContextXml[i]));
            }
        }
        if (parentApplicationContext != null) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("OssBeanRunnerImpl.init(): parentApplicationContext for processes:" + parentApplicationContext.getDisplayName()));
            }
            try {
                ossBeanRunnerContext = new ClassPathXmlApplicationContext(localOssBeanRunnerSpringContextXml, parentApplicationContext);
            }
            catch (Exception ex) {
                logger.error((Object)("OssBeanRunnerImpl.init(): Error loading ClassPathXmlApplicationContext + parentApplicationContext: " + ex));
            }
        } else {
            try {
                ossBeanRunnerContext = new ClassPathXmlApplicationContext(localOssBeanRunnerSpringContextXml);
            }
            catch (Exception ex) {
                logger.error((Object)("OssBeanRunnerImpl.init(): Error loading ClassPathXmlApplicationContext: " + ex));
            }
        }
        this.ossBeanList = this.getOssBeanRunnerList().getossbeanrunnerlist();
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"OssBeanRunnerImpl.init(): ossBeanList:");
            for (int i = 0; i < this.ossBeanList.length; ++i) {
                logger.debug((Object)("    " + this.ossBeanList[i]));
            }
        }
        for (int i = 0; i < this.ossBeanList.length; ++i) {
            try {
                ossbean = null;
                try {
                    ossbean = this.getOssBean(this.ossBeanList[i]);
                }
                catch (BeansException bex) {
                    logger.error((Object)("OssBeanRunnerImpl.init(): problem finding OssBean'" + this.ossBeanList[i] + "' entry in OssBean spring context " + (Object)((Object)bex)));
                }
                if (ossbean == null) continue;
                ossbean.setLogName(logname);
                rxThread = new Thread(ossbean);
                this.ossBeans.put(ossbean, rxThread);
                continue;
            }
            catch (Exception ex) {
                logger.error((Object)("OssBeanRunnerImpl.init(): problem creating  thread for OssBean'" + this.ossBeanList[i] + "' entry in OssBean spring context " + ex));
            }
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"OssBeanRunnerImpl.init(): Hashtable of OssBeans: ossBeans:");
            Enumeration ossbeanenum = this.ossBeans.keys();
            while (ossbeanenum.hasMoreElements()) {
                ossbean = (OssBean)ossbeanenum.nextElement();
                rxThread = (Thread)this.ossBeans.get(ossbean);
                logger.debug((Object)("   OssBean:" + ossbean.getName() + "\n" + ossbean.getStaticConfiguration() + "\n" + "          Thread:" + rxThread.toString()));
            }
        }
        this.initialised = true;
        this.status = 1;
    }

    public void run() {
        logger = LogFactory.getLog((String)logname);
        if (!this.initialised) {
            logger.error((Object)"OssBeanRunnerImpl.run(). Not initialised. You must call init() before calling run()");
            throw new IllegalStateException("OssBeanRunnerImpl.run(). Not initialised. You must call init() before calling run()");
        }
        this.status = 2;
        Enumeration ossbeanenum = this.ossBeans.keys();
        while (ossbeanenum.hasMoreElements()) {
            String ossbeanName = null;
            try {
                OssBean ossbean = (OssBean)ossbeanenum.nextElement();
                ossbeanName = ossbean.getName();
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("OssBeanRunnerImpl.run():Starting OssBean:" + ossbean.getName()));
                }
                Thread rxThread = (Thread)this.ossBeans.get(ossbean);
                rxThread.start();
            }
            catch (Exception ex) {
                logger.error((Object)("OssBeanRunnerImpl.run(): error when starting thread for OssBean: " + ossbeanName + " " + ex));
            }
        }
        this.status = 3;
    }

    public void stop() {
        logger = LogFactory.getLog((String)logname);
        this.status = 4;
        int i = 1;
        while (this.ossBeans != null && !this.ossBeans.isEmpty()) {
            OssBean ossbean;
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("OssBeanRunnerImpl.stop():Stopping OssBeans (Attempt " + i + " ) :"));
            }
            Enumeration ossbeanenum = this.ossBeans.keys();
            while (ossbeanenum.hasMoreElements()) {
                ossbean = (OssBean)ossbeanenum.nextElement();
                try {
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("OssBeanRunnerImpl.stop():Stopping OssBean:" + ossbean.getName()));
                    }
                    ossbean.stop();
                }
                catch (Exception ex) {
                    logger.error((Object)("OssBeanRunnerImpl.stop() error when stopping OssBean:" + ossbean.getName() + ": " + ex));
                }
            }
            ossbeanenum = this.ossBeans.keys();
            while (ossbeanenum.hasMoreElements()) {
                try {
                    ossbean = (OssBean)ossbeanenum.nextElement();
                    int st = ossbean.getStatus();
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("OssBeanRunnerImpl.stop(): OssBean:" + ossbean.getName() + " Status:" + ossbean.getStatusStr()));
                    }
                    if (st != 5) continue;
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("OssBeanRunnerImpl.stop():Removing Thread from ossBeans list OssBean:" + ossbean.getName()));
                    }
                    this.ossBeans.remove(ossbean);
                }
                catch (Exception ex) {
                    logger.error((Object)("OssBeanRunnerImpl.stop() error when stopping threads" + ex));
                }
            }
            if (this.ossBeans.isEmpty()) continue;
            Thread thisThread = Thread.currentThread();
            try {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)"OssBeanRunnerImpl.stop(): wait 10 seconds and try again:");
                }
                Thread.sleep(10000L);
            }
            catch (InterruptedException ex) {
                // empty catch block
            }
            if (++i <= 5) continue;
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"OssBeanRunnerImpl.stop():ossBeans=null - kill all processes");
            }
            this.ossBeans = null;
            break;
        }
        this.status = 5;
        logger.info((Object)"OssBeanRunnerImpl.stop(): STOPPED");
    }

    public void pause() throws UnsupportedOperationException {
        logger.error((Object)"OssBeanRunnerImpl.pause() PAUSE NOT IMPLIMENTED");
        throw new UnsupportedOperationException("OssBeanRunnerImpl.pause() PAUSE NOT IMPLIMENTED");
    }

    public String getOssBeanInstancesStatus() {
        String s = "OssBeanRunnerImpl.getOssBeanInstancesStatus(): OssBeanRunnerImpl name:" + this.beanName;
        s = s + "   OssBeanInstancesStatus:\n";
        Enumeration ossbeanenum = this.ossBeans.keys();
        int i = 1;
        while (ossbeanenum.hasMoreElements()) {
            try {
                OssBean ossbean = (OssBean)ossbeanenum.nextElement();
                if (ossbean != null) {
                    s = s + "    ossBean [" + i + "] Name:" + ossbean.getName() + " :" + ossbean.getStatusStr() + "\n";
                    s = s + ossbean.getStaticConfiguration() + "\n";
                    s = s + ossbean.getRuntimeStatistics() + "\n";
                }
            }
            catch (Exception ex) {
                logger.error((Object)("OssBeanRunnerImpl.OssBeanInstancesStatus error getting status" + ex));
            }
            ++i;
        }
        return s;
    }

    private OssBeanRunnerList getOssBeanRunnerList() {
        OssBeanRunnerList ossBeanRunnerList = (OssBeanRunnerList)ossBeanRunnerContext.getBean("OssBeanRunnerList");
        return ossBeanRunnerList;
    }

    private OssBean getOssBean(String ossbeanname) {
        OssBean ossBean = (OssBean)ossBeanRunnerContext.getBean(ossbeanname);
        return ossBean;
    }

    public int getStatus() {
        return this.status;
    }

    public String getStatusStr() {
        String s = "UNKNOWN-STATE";
        try {
            s = STATUS_NAMES[this.status];
        }
        catch (ArrayIndexOutOfBoundsException ex) {
            s = "UNKNOWN-STATE";
        }
        return s;
    }

    public String getStaticConfiguration() {
        int i;
        String s = "OssBeanRunnerImpl.getStaticConfiguration(): beanName:" + this.beanName + "\n";
        s = s + "    localOssBeanRunnerSpringContextXml[] files:\n";
        for (i = 0; i < localOssBeanRunnerSpringContextXml.length; ++i) {
            s = s + "        " + localOssBeanRunnerSpringContextXml[i] + "\n";
        }
        s = s + "    ossBeanList[] :\n";
        for (i = 0; i < this.ossBeanList.length; ++i) {
            s = s + "        " + this.ossBeanList[i] + "\n";
        }
        return s;
    }

    public String getRuntimeStatistics() {
        String s = "OssBeanRunnerImpl.getRuntimeStatistics(): OssBeanRunnerImpl name:" + this.beanName;
        s = s + "    Thread Status:\n";
        Enumeration ossbeanenum = this.ossBeans.keys();
        int i = 1;
        while (ossbeanenum.hasMoreElements()) {
            try {
                OssBean ossbean = (OssBean)ossbeanenum.nextElement();
                if (ossbean != null) {
                    s = s + "    ossBean [" + i + "] Name:" + ossbean.getName() + " :" + ossbean.getRuntimeStatistics() + "\n";
                }
                ++i;
            }
            catch (Exception ex) {
                logger.error((Object)("OssBeanRunnerImpl.getRuntimeStatistics() error getting statistics" + ex));
            }
        }
        return s;
    }

    static {
        logger = LogFactory.getLog(OssBeanRunnerImpl.class);
        logname = OssBeanRunnerImpl.class.getName();
        localOssBeanRunnerSpringContextXml = null;
    }
}

