/*
 * Decompiled with CFR 0.152.
 */
package org.openoss.ossj.fm.monitor.spring;

import java.rmi.RMISecurityManager;
import java.util.Properties;
import javax.jms.Queue;
import javax.jms.QueueConnection;
import javax.jms.QueueConnectionFactory;
import javax.jms.QueueReceiver;
import javax.jms.QueueSession;
import javax.jms.Topic;
import javax.jms.TopicConnection;
import javax.jms.TopicConnectionFactory;
import javax.jms.TopicSession;
import javax.jms.TopicSubscriber;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.oss.UnsupportedOperationException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.openoss.ossj.fm.monitor.spring.AlarmMonitorDaoImpl;
import org.openoss.ossj.fm.monitor.spring.OssBean;
import org.openoss.ossj.fm.monitor.spring.OssBeanImpl;
import org.openoss.ossj.fm.monitor.spring.OssBeanReceiver;

public class OssBeanReceiverImpl
extends OssBeanImpl
implements OssBean,
OssBeanReceiver {
    protected Properties env;
    protected Topic eventTopicJVT = null;
    protected TopicSession jmsSessionJVT = null;
    protected TopicConnection connJVT = null;
    protected TopicSubscriber jvtEventSubscriber = null;
    protected TopicSubscriber xvtEventSubscriber = null;
    protected boolean connected = false;
    protected String logname = "not set";
    protected TopicSession jmsSessionXVT = null;
    protected TopicConnection connXVT = null;
    protected Topic eventTopicXVT = null;
    protected QueueSession jmsSessionQueue = null;
    protected QueueConnection queueConnection = null;
    protected Queue xmlMessageQueue = null;
    protected QueueReceiver queueReceiver = null;
    int nonObjectMessage_count = 0;
    int objectMessage_count;
    int txtMessage_count = 0;
    protected static Log logger = LogFactory.getLog(AlarmMonitorDaoImpl.class);
    protected String ossBeanName = "name_not_set";
    private int connection_retry_period = 10000;
    private String jndi_fact_class_name = null;
    private String jndi_url = null;
    private String bean_naming_package = null;
    private String jvt_home = null;
    private String topic_connector_factory_name = null;
    private String jvt_event_topic_name = null;
    private String xvt_event_topic_name = null;
    private String queue_connection_factory_name = null;
    private String message_queue_name = null;
    private String jmsuser = "guest";
    private String jmspassword = "guest";

    public void setLogName(String _logName) {
        this.logname = _logName;
        logger = LogFactory.getLog((String)_logName);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("RX:" + this.ossBeanName + ":" + this.getClass().getSimpleName() + ".setLogger() alarm logger set; Logname: " + _logName));
        }
    }

    public String getLogName() {
        return this.logname;
    }

    public String getName() {
        return this.ossBeanName;
    }

    public void setName(String _name) {
        if (_name == null) {
            throw new IllegalStateException("AlarmEventReceiverImpl.setName(). Name cannot be set null");
        }
        this.ossBeanName = _name;
    }

    public void setConnection_retry_period(int _connection_retry_period) {
        this.connection_retry_period = _connection_retry_period;
    }

    public void setJmsuser(String jmsuser) {
        this.jmsuser = jmsuser;
    }

    public String getJmsuser() {
        return this.jmsuser;
    }

    public void setJmspassword(String jmspassword) {
        this.jmspassword = jmspassword;
    }

    public String getJmspassword() {
        return this.jmspassword;
    }

    public void setbean_naming_package(String _bean_naming_package) {
        this.bean_naming_package = _bean_naming_package;
    }

    public void setjndi_fact_class_name(String _jndi_fact_class_name) {
        this.jndi_fact_class_name = _jndi_fact_class_name;
    }

    public void setjndi_url(String _jndi_url) {
        this.jndi_url = _jndi_url;
    }

    public void setjvt_home(String _jvt_home) {
        this.jvt_home = _jvt_home;
    }

    public void setjvt_event_topic_name(String _jvt_event_topic_name) {
        this.jvt_event_topic_name = _jvt_event_topic_name;
    }

    public void settopic_connector_factory_name(String _topic_connector_factory_name) {
        this.topic_connector_factory_name = _topic_connector_factory_name;
    }

    public void setxvt_event_topic_name(String _xvt_event_topic_name) {
        this.xvt_event_topic_name = _xvt_event_topic_name;
    }

    public void setmessage_queue(String _message_queue) {
        this.message_queue_name = _message_queue;
    }

    public void setqueue_connection_factory_name(String _queue_connection_factory_name) {
        this.queue_connection_factory_name = _queue_connection_factory_name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        this.runBean.setRun(true);
        Thread thisThread = Thread.currentThread();
        while (this.runBean.isRun()) {
            if (!this.runBean.isRun() || this.connected) continue;
            this.runBean.setStatus(1);
            this.initialise_JMS_receivers();
            if (this.connected) {
                this.runBean.setStatus(3);
                logger.info((Object)("RX:" + this.ossBeanName + ":" + this.getClass().getSimpleName() + ": CONNECTED : receiving messages"));
                this.receive_messages();
            }
            if (!this.runBean.isRun()) continue;
            this.runBean.setStatus(1);
            try {
                logger.info((Object)("RX:" + this.ossBeanName + ":" + this.getClass().getSimpleName() + ": NOT CONNECTED Waiting " + this.connection_retry_period + "ms before trying to reconnect"));
                Thread.sleep(this.connection_retry_period);
            }
            catch (InterruptedException ex) {}
        }
        this.runBean.setStatus(4);
        try {
            this.kill();
            this.runBean.setStatus(5);
        }
        catch (Exception ex) {
            logger.error((Object)("RX:" + this.ossBeanName + ":" + this.getClass().getSimpleName() + ".run(): Exception in kill(): " + ex));
        }
        finally {
            logger.info((Object)("RX:" + this.ossBeanName + ":" + this.getClass().getSimpleName() + ": STOPPED"));
            this.runBean.setStatus(5);
        }
    }

    public synchronized void stop() {
        if (this.runBean.isRun()) {
            this.runBean.setStatus(4);
            this.runBean.setRun(false);
            this.connected = false;
        }
        this.notify();
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("RX:" + this.ossBeanName + ":" + this.getClass().getSimpleName() + ".stop(): stopping process"));
        }
    }

    private void initialise_JMS_receivers() {
        if (this.connected) {
            throw new IllegalStateException("RX:" + this.ossBeanName + ":" + this.getClass().getSimpleName() + "initialise_JMS_receivers(): Receiver Already Initialised. Use Stop() before re-initialising");
        }
        try {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("RX:" + this.ossBeanName + ":" + this.getClass().getSimpleName() + "initialise_JMS_receivers(): NOT connected - Trying to Initialise Session"));
            }
            this.setupConnections();
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("RX:" + this.ossBeanName + ":" + this.getClass().getSimpleName() + "initialise_JMS_receivers(): Session Initialised "));
            }
            if (this.jmsSessionXVT != null) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("RX:" + this.ossBeanName + ":" + this.getClass().getSimpleName() + "initialise_JMS_receivers(): Subscribing to OSS/J XVT jms session: "));
                }
                this.xvtEventSubscriber = this.jmsSessionXVT.createSubscriber(this.eventTopicXVT);
            }
            if (this.jmsSessionJVT != null) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("RX:" + this.ossBeanName + ":" + this.getClass().getSimpleName() + "initialise_JMS_receivers(): Subscribing to OSS/J JVT jms session: "));
                }
                this.jvtEventSubscriber = this.jmsSessionJVT.createSubscriber(this.eventTopicJVT);
            }
            if (this.jmsSessionQueue != null) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("RX:" + this.ossBeanName + ":" + this.getClass().getSimpleName() + "initialise_JMS_receivers(): Subscribing to OSS/J XVT message queue: "));
                }
                this.queueReceiver = this.jmsSessionQueue.createReceiver(this.xmlMessageQueue);
            }
            this.connected = true;
        }
        catch (Exception ex) {
            logger.error((Object)("RX:" + this.ossBeanName + ":" + this.getClass().getSimpleName() + "initialise_JMS_receivers(): while connecting: Exception: " + ex));
            try {
                this.connected = false;
                this.kill();
            }
            catch (Exception ex2) {
                logger.error((Object)("RX:" + this.ossBeanName + ":" + this.getClass().getSimpleName() + "initialise_JMS_receivers(): while connecting: Exception in kill(): " + ex2));
            }
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("RX:" + this.ossBeanName + ":" + this.getClass().getSimpleName() + "initialise_JMS_receivers(): jms connected - use run() to wait for events ;"));
        }
    }

    public void init() {
        logger.error((Object)"AlarmEventReceiverImpl().init(): init() not needed by this bean as instantiated in START_PENDING state");
    }

    public void pause() throws UnsupportedOperationException {
        logger.error((Object)"AlarmEventReceiverImpl().pause() PAUSE NOT IMPLIMENTED");
        throw new UnsupportedOperationException("AlarmEventReceiverImpl().pause() PAUSE NOT IMPLIMENTED");
    }

    private void setupConnections() throws IllegalStateException {
        block43: {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)this.getStaticConfiguration());
            }
            InitialContext ic = null;
            try {
                this.env = new Properties();
                this.env.setProperty("java.naming.provider.url", this.jndi_url);
                this.env.setProperty("java.naming.factory.initial", this.jndi_fact_class_name);
                this.env.setProperty("java.naming.factory.url.pkgs", this.bean_naming_package);
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("RX:" + this.ossBeanName + ":" + this.getClass().getSimpleName() + ": InitialContext env property java.naming.provider.url= " + this.env.getProperty("java.naming.provider.url")));
                    logger.debug((Object)("RX:" + this.ossBeanName + ":" + this.getClass().getSimpleName() + ": InitialContext env property java.naming.factory.initial= " + this.env.getProperty("java.naming.factory.initial")));
                    logger.debug((Object)("RX:" + this.ossBeanName + ":" + this.getClass().getSimpleName() + ": InitialContext env property java.naming.factory.url.pkgs= " + this.env.getProperty("java.naming.factory.url.pkgs")));
                }
                if (System.getSecurityManager() == null) {
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("RX:" + this.ossBeanName + ":" + this.getClass().getSimpleName() + ": setting java.security.policy= " + System.getProperty("java.security.policy")));
                    }
                    System.setSecurityManager(new RMISecurityManager());
                }
                ic = new InitialContext(this.env);
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("RX:" + this.ossBeanName + ":" + this.getClass().getSimpleName() + ": Initial context created"));
                }
            }
            catch (NamingException ne) {
                logger.error((Object)("RX:" + this.ossBeanName + ":" + this.getClass().getSimpleName() + ": Problem creating InitialContext:" + ne));
                ic = null;
                throw new IllegalStateException("RX:" + this.ossBeanName + ":" + this.getClass().getSimpleName() + "setupConnections():Cannot create initial context", ne);
            }
            if (ic != null) {
                try {
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("RX:" + this.ossBeanName + ":" + this.getClass().getSimpleName() + ": Trying to connect to message topics and queues"));
                    }
                    TopicConnectionFactory tcf = null;
                    if (this.topic_connector_factory_name != null) {
                        try {
                            if (logger.isDebugEnabled()) {
                                logger.debug((Object)("RX:" + this.ossBeanName + ":" + this.getClass().getSimpleName() + ": trying to connect to TopicConnectionFactory"));
                            }
                            tcf = (TopicConnectionFactory)ic.lookup(this.topic_connector_factory_name);
                            if (logger.isDebugEnabled()) {
                                logger.debug((Object)("RX:" + this.ossBeanName + ":" + this.getClass().getSimpleName() + ": success - connected to TopicConnectionFactory"));
                            }
                        }
                        catch (NamingException ne) {
                            logger.error((Object)("RX:" + this.ossBeanName + ":" + this.getClass().getSimpleName() + ": Problem connecting to TopicConnectionFactory: " + ne));
                            tcf = null;
                            throw new IllegalStateException("RX:" + this.ossBeanName + ":" + this.getClass().getSimpleName() + "setupConnections():Cannot create TopicConnectionFactory topic_connector_factory_name:" + this.topic_connector_factory_name + " Error:", ne);
                        }
                    }
                    if (tcf != null) {
                        if (this.jvt_event_topic_name != null) {
                            try {
                                if (logger.isDebugEnabled()) {
                                    logger.debug((Object)("RX:" + this.ossBeanName + ":" + this.getClass().getSimpleName() + ": trying to connect to JVT event topic"));
                                }
                                this.connJVT = tcf.createTopicConnection(this.jmsuser, this.jmspassword);
                                this.jmsSessionJVT = this.connJVT.createTopicSession(false, 1);
                                this.eventTopicJVT = (Topic)ic.lookup(this.jvt_event_topic_name);
                                this.connJVT.start();
                                if (logger.isDebugEnabled()) {
                                    logger.debug((Object)("RX:" + this.ossBeanName + ":" + this.getClass().getSimpleName() + ": success - connected to JVT event topic"));
                                }
                            }
                            catch (NamingException ne) {
                                logger.error((Object)("RX:" + this.ossBeanName + ":" + this.getClass().getSimpleName() + ": Problem connecting to JVT event topic: " + ne));
                                this.jmsSessionJVT = null;
                                this.eventTopicJVT = null;
                                this.connJVT = null;
                                throw new IllegalStateException("RX:" + this.ossBeanName + ":" + this.getClass().getSimpleName() + "setupConnections():Cannot create eventTopicJVT jvt_event_topic_name:" + this.jvt_event_topic_name + " Error:", ne);
                            }
                        }
                        if (this.xvt_event_topic_name != null) {
                            try {
                                if (logger.isDebugEnabled()) {
                                    logger.debug((Object)("RX:" + this.ossBeanName + ":" + this.getClass().getSimpleName() + ": trying to connect to XVT event topic"));
                                }
                                this.connXVT = tcf.createTopicConnection(this.jmsuser, this.jmspassword);
                                this.jmsSessionXVT = this.connXVT.createTopicSession(false, 1);
                                this.eventTopicXVT = (Topic)ic.lookup(this.xvt_event_topic_name);
                                this.connXVT.start();
                                if (logger.isDebugEnabled()) {
                                    logger.debug((Object)("RX:" + this.ossBeanName + ":" + this.getClass().getSimpleName() + ": success - connected to XVT event topic"));
                                }
                            }
                            catch (NamingException ne) {
                                logger.error((Object)("RX:" + this.ossBeanName + ":" + this.getClass().getSimpleName() + ": Problem connecting to XVT event topic: " + ne));
                                this.jmsSessionXVT = null;
                                this.eventTopicXVT = null;
                                this.connXVT = null;
                                throw new IllegalStateException("RX:" + this.ossBeanName + ":" + this.getClass().getSimpleName() + "setupConnections():Cannot create eventTopicXVT xvt_event_topic_name:" + this.xvt_event_topic_name + " Error:", ne);
                            }
                        }
                    }
                    QueueConnectionFactory qcf = null;
                    if (this.queue_connection_factory_name != null) {
                        try {
                            if (logger.isDebugEnabled()) {
                                logger.debug((Object)("RX:" + this.ossBeanName + ":" + this.getClass().getSimpleName() + ": trying to connect to QueueConnectionFactory"));
                            }
                            qcf = (QueueConnectionFactory)ic.lookup(this.queue_connection_factory_name);
                            if (logger.isDebugEnabled()) {
                                logger.debug((Object)("RX:" + this.ossBeanName + ":" + this.getClass().getSimpleName() + ": success - connected to QueueConnectionFactory"));
                            }
                        }
                        catch (NamingException ne) {
                            logger.error((Object)("RX:" + this.ossBeanName + ":" + this.getClass().getSimpleName() + ": Problem connecting to QueueConnectionFactory: " + ne));
                            qcf = null;
                            throw new IllegalStateException("RX:" + this.ossBeanName + ":" + this.getClass().getSimpleName() + "setupConnections():Cannot create QueueConnectionFactory queue_connection_factory_name:" + this.queue_connection_factory_name + " Error:", ne);
                        }
                    }
                    if (qcf == null || this.message_queue_name == null) break block43;
                    try {
                        if (logger.isDebugEnabled()) {
                            logger.debug((Object)("RX:" + this.ossBeanName + ":" + this.getClass().getSimpleName() + ": trying to create queueConnection"));
                        }
                        this.queueConnection = qcf.createQueueConnection(this.jmsuser, this.jmspassword);
                        this.jmsSessionQueue = this.queueConnection.createQueueSession(false, 1);
                        this.xmlMessageQueue = (Queue)ic.lookup(this.message_queue_name);
                        this.queueConnection.start();
                        if (logger.isDebugEnabled()) {
                            logger.debug((Object)("RX:" + this.ossBeanName + ":" + this.getClass().getSimpleName() + ": success - queueConnection started"));
                        }
                    }
                    catch (NamingException ne) {
                        logger.error((Object)("RX:" + this.ossBeanName + ":" + this.getClass().getSimpleName() + ": Problem connecting to XML MESSAGE QUEUES :" + ne));
                        this.queueConnection = null;
                        this.xmlMessageQueue = null;
                        this.jmsSessionQueue = null;
                        throw new IllegalStateException("RX:" + this.ossBeanName + ":" + this.getClass().getSimpleName() + "setupConnections():Cannot create xmlMessageQueue message_queue_name:" + this.message_queue_name + " Error:", ne);
                    }
                }
                catch (Exception ex) {
                    logger.error((Object)("RX:" + this.ossBeanName + ":" + this.getClass().getSimpleName() + "setupConnections(): Problem connecting to JMS sessions :" + ex));
                    throw new IllegalStateException("RX:" + this.ossBeanName + ":" + this.getClass().getSimpleName() + "setupConnections():Problem connecting to JMS sessions Error:", ex);
                }
                finally {
                    try {
                        ic.close();
                        ic = null;
                    }
                    catch (Exception ex) {}
                    ic = null;
                }
            }
        }
    }

    private void kill() throws Exception {
        if (this.connJVT != null) {
            this.connJVT.stop();
            this.jmsSessionJVT.close();
            this.connJVT.close();
            this.jmsSessionJVT = null;
            this.eventTopicJVT = null;
            this.connJVT = null;
        }
        if (this.connXVT != null) {
            this.connXVT.stop();
            this.jmsSessionXVT.close();
            this.connXVT.close();
            this.jmsSessionXVT = null;
            this.eventTopicXVT = null;
            this.connXVT = null;
        }
        if (this.queueConnection != null) {
            this.queueConnection.stop();
            this.jmsSessionQueue.close();
            this.queueConnection.close();
            this.queueConnection = null;
            this.xmlMessageQueue = null;
            this.jmsSessionQueue = null;
        }
        this.connected = false;
    }

    public boolean isConnected() {
        return this.connected;
    }

    public int getNonObjectMessage_count() {
        return this.nonObjectMessage_count;
    }

    public int getObjectMessage_count() {
        return this.objectMessage_count;
    }

    public int getTxtMessage_count() {
        return this.txtMessage_count;
    }

    public String getRuntimeStatistics() {
        String statistics = "Event Counts:- \tNonObjMsg:" + this.nonObjectMessage_count + "\tObjMsg:" + this.objectMessage_count + "\tTxtMsg:" + this.txtMessage_count;
        return statistics;
    }

    public String getStaticConfiguration() {
        String connectioninfo = "RX:" + this.ossBeanName + ":" + this.getClass().getSimpleName() + " - connection properties:\n" + "\t   jndi_fact_class_name =" + this.jndi_fact_class_name + "\n" + "\t   jndi_url =" + this.jndi_url + "\n" + "\t   bean_naming_package =" + this.bean_naming_package + "\n" + "\t   jvt_home =" + this.jvt_home + "\n" + "\t   topic_connection_factory_name =" + this.topic_connector_factory_name + "\n" + "\t   jvt_event_topic_name =" + this.jvt_event_topic_name + "\n" + "\t   xvt_event_topic_name =" + this.xvt_event_topic_name + "\n" + "\t   queue_connection_factory_name =" + this.queue_connection_factory_name + "\n" + "\t   message_queue_name =" + this.message_queue_name;
        return connectioninfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void receive_messages() {
        if (!this.connected) {
            throw new IllegalStateException("RX:" + this.ossBeanName + ":" + this.getClass().getSimpleName() + ".run(): Receiver must be initialised using Init() before run()");
        }
        if (!this.connected) {
            throw new IllegalStateException("RX:" + this.ossBeanName + ":" + this.getClass().getSimpleName() + ".run(): Receiver must be initialised using Init() before run()");
        }
        while (this.connected && this.runBean.isRun()) {
            try {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("RX:" + this.ossBeanName + ":" + this.getClass().getSimpleName() + "receive_messages(): WARNING THIS CLASS IS A SIMPLE RECEIVER PROTOTYPE AND SHOULD BE EXTENDED TO DO USEFUL WORK"));
                }
                OssBeanReceiverImpl ossBeanReceiverImpl = this;
                synchronized (ossBeanReceiverImpl) {
                    this.wait(1000L);
                }
            }
            catch (InterruptedException ex) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("RX:" + this.ossBeanName + ":" + this.getClass().getSimpleName() + ": Exception: "), (Throwable)ex);
                }
                this.connected = false;
            }
        }
        try {
            this.connected = false;
        }
        catch (Exception ex) {
            logger.error((Object)("RX:" + this.ossBeanName + ":" + this.getClass().getSimpleName() + ".run(): Exception in closing receiver: " + ex));
        }
    }

    public Topic getEventTopicJVT() {
        return this.eventTopicJVT;
    }

    public Topic getEventTopicXVT() {
        return this.eventTopicXVT;
    }

    public Queue getXmlMessageQueue() {
        return this.xmlMessageQueue;
    }
}

