/*
 * Decompiled with CFR 0.152.
 */
package org.openoss.ossj.fm.monitor.spring;

import javax.jms.Message;
import javax.jms.ObjectMessage;
import javax.jms.TextMessage;
import org.openoss.ossj.fm.monitor.spring.OssBeanJMSMessageHolder;
import org.openoss.ossj.fm.monitor.spring.OssBeanMessageReceiver;
import org.openoss.ossj.fm.monitor.spring.OssBeanReceiverImpl;

public class OssBeanMessageReceiverImpl
extends OssBeanReceiverImpl
implements OssBeanMessageReceiver {
    int unknownMessageType_count = 0;

    public int getUnknownMessageType_count() {
        return this.unknownMessageType_count;
    }

    public String getRuntimeStatistics() {
        String statistics = "Event Counts:- \tUnknownMsgType:" + this.unknownMessageType_count + "\tObjMsg:" + this.objectMessage_count + "\tTxtMsg:" + this.txtMessage_count;
        return statistics;
    }

    protected void receive_messages() {
        if (!this.connected) {
            throw new IllegalStateException("RX:" + this.ossBeanName + ":" + this.getClass().getSimpleName() + ".run(): Receiver must be initialised using Init() before run()");
        }
        while (this.connected) {
            try {
                Object objectMessage = null;
                Message msg = null;
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("RX:" + this.ossBeanName + ":" + this.getClass().getSimpleName() + ": ***Waiting for OSS/J JMS message ***"));
                }
                while (this.connected && msg == null) {
                    msg = this.queueReceiver.receive(1000L);
                }
                if (msg == null) {
                    this.connected = false;
                    break;
                }
                OssBeanJMSMessageHolder jmsMessageTemplate = null;
                if (msg instanceof ObjectMessage) {
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("RX:" + this.ossBeanName + ":" + this.getClass().getSimpleName() + ": Recieved object message on JVT Topic:objectMessage.toString()=" + objectMessage.toString()));
                    }
                    ++this.objectMessage_count;
                    jmsMessageTemplate = new OssBeanJMSMessageHolder((ObjectMessage)msg);
                } else if (msg instanceof TextMessage) {
                    TextMessage tm = (TextMessage)msg;
                    String received = tm.getText();
                    ++this.txtMessage_count;
                    jmsMessageTemplate = new OssBeanJMSMessageHolder((TextMessage)msg);
                } else {
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("RX:" + this.ossBeanName + ":" + this.getClass().getSimpleName() + ": Received unknown message type: " + msg.toString()));
                    }
                    ++this.unknownMessageType_count;
                    jmsMessageTemplate = new OssBeanJMSMessageHolder(msg);
                }
                String handshakeInstance = jmsMessageTemplate.getHandshakeInstance();
                if (!logger.isDebugEnabled()) continue;
                logger.debug((Object)("RX:" + this.ossBeanName + ":" + this.getClass().getSimpleName() + ": Received JMS message:" + "\n HandshakeInstance:" + handshakeInstance + "\n jmsMessageTemplate.toString():" + jmsMessageTemplate.toString()));
            }
            catch (Exception ex) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("RX:" + this.ossBeanName + ":" + this.getClass().getSimpleName() + ": Exception: "), (Throwable)ex);
                }
                this.connected = false;
            }
        }
        try {
            this.connected = false;
            if (this.queueReceiver != null) {
                this.queueReceiver.close();
            }
            this.queueReceiver = null;
        }
        catch (Exception ex) {
            logger.error((Object)("RX:" + this.ossBeanName + ":" + this.getClass().getSimpleName() + ".run(): Exception in closing queueReceiver(): " + ex));
        }
    }
}

