/*
 * Decompiled with CFR 0.152.
 */
package org.openoss.ossj.fm.monitor.spring;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.ObjectMessage;
import javax.jms.TextMessage;
import javax.jms.Topic;
import javax.jms.TopicConnection;
import javax.jms.TopicConnectionFactory;
import javax.jms.TopicPublisher;
import javax.jms.TopicSession;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.oss.Event;
import javax.oss.IllegalArgumentException;
import javax.oss.ManagedEntityKey;
import javax.oss.QueryValue;
import javax.oss.UnsupportedOperationException;
import javax.oss.fm.monitor.AlarmEvent;
import javax.oss.fm.monitor.AlarmKey;
import javax.oss.fm.monitor.AlarmKeyResult;
import javax.oss.fm.monitor.AlarmValue;
import javax.oss.fm.monitor.AlarmValueIterator;
import javax.oss.fm.monitor.NotifyAckStateChangedEvent;
import javax.oss.fm.monitor.NotifyAckStateChangedEventPropertyDescriptor;
import javax.oss.fm.monitor.NotifyAlarmCommentsEvent;
import javax.oss.fm.monitor.NotifyAlarmCommentsEventPropertyDescriptor;
import javax.oss.fm.monitor.NotifyAlarmListRebuiltEvent;
import javax.oss.fm.monitor.NotifyAlarmListRebuiltEventPropertyDescriptor;
import javax.oss.fm.monitor.NotifyChangedAlarmEvent;
import javax.oss.fm.monitor.NotifyChangedAlarmEventPropertyDescriptor;
import javax.oss.fm.monitor.NotifyClearedAlarmEvent;
import javax.oss.fm.monitor.NotifyClearedAlarmEventPropertyDescriptor;
import javax.oss.fm.monitor.NotifyNewAlarmEvent;
import javax.oss.fm.monitor.NotifyNewAlarmEventPropertyDescriptor;
import javax.oss.util.IRPEvent;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.openoss.ossj.fm.monitor.spring.AlarmMonitorDao;
import org.openoss.ossj.jvt.fm.monitor.OOSSAlarmKeyResult;
import org.openoss.ossj.jvt.fm.monitor.OOSSAlarmValueIterator;
import org.openoss.ossj.jvt.fm.monitor.OOSSNotifyAckStateChangedEvent;
import org.openoss.ossj.jvt.fm.monitor.OOSSNotifyAlarmListRebuiltEvent;
import org.openoss.ossj.jvt.fm.monitor.OOSSNotifyChangedAlarmEvent;
import org.openoss.ossj.jvt.fm.monitor.OOSSNotifyClearedAlarmEvent;
import org.openoss.ossj.jvt.fm.monitor.OOSSNotifyNewAlarmEvent;
import org.openoss.ossj.xml.fm.monitor.OOSSQosEventXmlJvtDocumentMarshaler;

public class AlarmMonitorDaoImpl
implements AlarmMonitorDao {
    private int alarmsHandled;
    private String ApplicationDN = "NOT_SET";
    private static Hashtable current_AlarmList = new Hashtable();
    String id;
    int notification_count = 0;
    private static Log logger;
    String jndi_fact_class_name = "org.jnp.interfaces.NamingContextFactory";
    String jndi_url = "jnp://jbossjmsserver1:1099";
    String bean_naming_package = "org.jboss.naming";
    String topic_connector_factory_name = "System/OpenOSS/ApplicationType/AlarmMonitor/Application/1-0;0-0;OpenNMS_OpenOSS_AM/Comp/TopicConnectionFactory";
    String jvt_event_topic_name = "System/OpenOSS/ApplicationType/AlarmMonitor/Application/1-0;0-0;OpenNMS_OpenOSS_AM/Comp/JVTEventTopic";
    String xvt_event_topic_name = "System/OpenOSS/ApplicationType/AlarmMonitor/Application/1-0;0-0;OpenNMS_OpenOSS_AM/Comp/XVTEventTopic";

    public void setLogName(String _logName) {
        logger = LogFactory.getLog((String)_logName);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("AlarmMonitorDaoImpl:AlarmMonitorDaoImpl.setLogger() alarm logger set; Logname: " + _logName));
        }
    }

    public void setbean_naming_package(String _bean_naming_package) {
        this.bean_naming_package = _bean_naming_package;
    }

    public void setjndi_fact_class_name(String _jndi_fact_class_name) {
        this.jndi_fact_class_name = _jndi_fact_class_name;
    }

    public void setjndi_url(String _jndi_url) {
        this.jndi_url = _jndi_url;
    }

    public void setjvt_event_topic_name(String _jvt_event_topic_name) {
        this.jvt_event_topic_name = _jvt_event_topic_name;
    }

    public void settopic_connector_factory_name(String _topic_connector_factory_name) {
        this.topic_connector_factory_name = _topic_connector_factory_name;
    }

    public void setxvt_event_topic_name(String _xvt_event_topic_name) {
        this.xvt_event_topic_name = _xvt_event_topic_name;
    }

    public AlarmMonitorDaoImpl() {
        logger = LogFactory.getLog(AlarmMonitorDaoImpl.class);
    }

    public void init() {
        logger.info((Object)"AlarmMonitorDao - properties:");
        logger.info((Object)("\tjndi_fact_class_name =" + this.jndi_fact_class_name));
        logger.info((Object)("\tjndi_url =" + this.jndi_url));
        logger.info((Object)("\tbean_naming_package =" + this.bean_naming_package));
        logger.info((Object)("\ttopic_connection_factory_name =" + this.topic_connector_factory_name));
        logger.info((Object)("\tjvt_event_topic_name =" + this.jvt_event_topic_name));
        logger.info((Object)("\txvt_event_topic_name =" + this.xvt_event_topic_name));
    }

    public void kill() {
    }

    public String getId() {
        return this.id;
    }

    public void setId(String _id) {
        this.id = _id;
    }

    private Message populateMessagePropertiesfromEvent(Event _event, Message msg) {
        Properties ossjMessageProperties = new Properties();
        ossjMessageProperties.put("OSS_APPLICATION_DN", _event.getApplicationDN());
        if (_event instanceof IRPEvent) {
            IRPEvent irpe = (IRPEvent)_event;
            ossjMessageProperties.put("OSS_APPLICATION_DN", irpe.getApplicationDN() == null ? "NULL" : irpe.getApplicationDN());
            ossjMessageProperties.put("OSS_EVENT_TIME", irpe.getEventTime() == null ? "NULL" : irpe.getEventTime().toString());
            ossjMessageProperties.put("OSS_MANAGED_ENTITY_PRIMARY_KEY", irpe.getManagedObjectInstance() == null ? "NULL" : irpe.getManagedObjectInstance());
            ossjMessageProperties.put("OSS_MANAGED_ENTITY_TYPE", irpe.getManagedObjectClass() == null ? "NULL" : irpe.getManagedObjectClass());
            try {
                msg.setJMSCorrelationID(irpe.getNotificationId() == null ? "NULL" : irpe.getNotificationId());
                msg.setJMSMessageID(irpe.getNotificationId() == null ? "NULL" : irpe.getNotificationId());
            }
            catch (JMSException jmsex) {
                logger.error((Object)"AlarmMonitorDaoImpl:sendJMSEvent() Error populating Message Properties");
            }
            if (_event instanceof NotifyAlarmListRebuiltEvent) {
                ossjMessageProperties.put("OSS_EVENT_TYPE", NotifyAlarmListRebuiltEventPropertyDescriptor.EVENT_TYPE_VALUE);
            } else {
                AlarmEvent ae = (AlarmEvent)_event;
                String ps = new Integer(ae.getPerceivedSeverity()).toString();
                ossjMessageProperties.put("PERCEIVED_SEVERITY", ps);
                String pc = new Integer(ae.getProbableCause()).toString();
                ossjMessageProperties.put("PROBABLE_CAUSE", pc);
                if (ae instanceof NotifyNewAlarmEvent) {
                    ossjMessageProperties.put("OSS_EVENT_TYPE", NotifyNewAlarmEventPropertyDescriptor.EVENT_TYPE_VALUE);
                } else if (ae instanceof NotifyChangedAlarmEvent) {
                    ossjMessageProperties.put("OSS_EVENT_TYPE", NotifyChangedAlarmEventPropertyDescriptor.EVENT_TYPE_VALUE);
                } else if (ae instanceof NotifyClearedAlarmEvent) {
                    ossjMessageProperties.put("OSS_EVENT_TYPE", NotifyClearedAlarmEventPropertyDescriptor.EVENT_TYPE_VALUE);
                } else if (ae instanceof NotifyAckStateChangedEvent) {
                    ossjMessageProperties.put("OSS_EVENT_TYPE", NotifyAckStateChangedEventPropertyDescriptor.EVENT_TYPE_VALUE);
                } else if (ae instanceof NotifyAlarmCommentsEvent) {
                    ossjMessageProperties.put("OSS_EVENT_TYPE", NotifyAlarmCommentsEventPropertyDescriptor.EVENT_TYPE_VALUE);
                } else {
                    logger.error((Object)"Unknown IRPEvent Type");
                }
            }
            try {
                Enumeration<Object> props = ossjMessageProperties.keys();
                while (props.hasMoreElements()) {
                    String key = (String)props.nextElement();
                    msg.setStringProperty(key, ossjMessageProperties.getProperty(key));
                }
            }
            catch (JMSException jmsex) {
                logger.error((Object)"AlarmMonitorDaoImpl:sendJMSEvent() Error populating ossjMessageProperties");
            }
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"AlarmMonitorDaoImpl:populateMessagePropertiesfromEvent() Message Properties:");
            try {
                logger.debug((Object)("\tmsg.getJMSCorrelationID(): " + msg.getJMSCorrelationID()));
                logger.debug((Object)("\tmsg.getJMSMessageID(): " + msg.getJMSMessageID()));
                Enumeration props = msg.getPropertyNames();
                while (props.hasMoreElements()) {
                    String key = (String)props.nextElement();
                    try {
                        String value = msg.getStringProperty(key);
                        System.out.println("\tProperty: " + key + "\tValue: " + value);
                    }
                    catch (JMSException jmsex) {
                        logger.debug((Object)("Error reading message property value.  Key:" + key + " Error:" + (Object)((Object)jmsex)));
                    }
                }
            }
            catch (JMSException jmsex) {
                logger.error((Object)"AlarmMonitorDaoImpl:sendJMSEvent() Error reading populated values", (Throwable)jmsex);
            }
        }
        return msg;
    }

    public void sendJMSEvent(IRPEvent _event) {
        InitialContext ic = null;
        TopicConnectionFactory tcf = null;
        Topic jvteventTopic = null;
        TopicSession jvtsession = null;
        TopicConnection jvtconn = null;
        TopicPublisher jvteventPublisher = null;
        Topic xvteventTopic = null;
        TopicSession xvtsession = null;
        TopicConnection xvtconn = null;
        TopicPublisher xvteventPublisher = null;
        ++this.notification_count;
        _event.setNotificationId("AlmMonitorId:" + this.id + ":EventCount:" + this.notification_count);
        _event.setApplicationDN(this.jvt_event_topic_name);
        try {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"AlarmMonitorDaoImpl:sendJMSEvent() Looking Up InitialContext for JMS queue lookup");
            }
            ic = this.getInitialContext(this.jndi_url);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"AlarmMonitorDaoImpl:sendJMSEvent() got the context");
            }
            tcf = (TopicConnectionFactory)ic.lookup(this.topic_connector_factory_name);
        }
        catch (NamingException ne) {
            logger.error((Object)"sendJMSEvent() NamingException looking up initial context and topic connection factory", (Throwable)ne);
        }
        try {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"AlarmMonitorDaoImpl:sendJMSEvent() completed the look-up, creating JVT topic connection");
            }
            jvtconn = tcf.createTopicConnection();
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"AlarmMonitorDaoImpl:sendJMSEvent() connection created, creating JVT session");
            }
            jvtsession = jvtconn.createTopicSession(false, 1);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"AlarmMonitorDaoImpl:sendJMSEvent() created topic session, looking up JVT topic");
            }
            jvteventTopic = (Topic)ic.lookup(this.jvt_event_topic_name);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"AlarmMonitorDaoImpl:sendJMSEvent() topic retrieved, starting JVT connection");
            }
            jvtconn.start();
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"AlarmMonitorDaoImpl:sendJMSEvent() connection started, creating JVT publisher");
            }
            jvteventPublisher = jvtsession.createPublisher(jvteventTopic);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"AlarmMonitorDaoImpl:sendJMSEvent() JVT publisher created");
            }
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"AlarmMonitorDaoImpl:sendJMSEvent() Sending JVT JMS message");
            }
            ObjectMessage msg = jvtsession.createObjectMessage((Serializable)_event);
            this.populateMessagePropertiesfromEvent((Event)_event, (Message)msg);
            jvteventPublisher.publish((Message)msg);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"AlarmMonitorDaoImpl:sendJMSEvent() JVT  JMS event sent");
            }
            jvtsession.close();
            jvtconn.close();
            jvteventPublisher.close();
        }
        catch (JMSException je) {
            logger.error((Object)"sendJMSEvent() - JVT JMS Exception Caught", (Throwable)je);
        }
        catch (NamingException ne) {
            logger.error((Object)"sendJMSEvent() - JVT JMS NamingException Caught", (Throwable)ne);
        }
        catch (NullPointerException npe) {
            logger.error((Object)"sendJMSEvent() NullPointer in JVT sendtestmessage");
            npe.printStackTrace();
        }
        catch (Exception e) {
            logger.error((Object)"sendJMSEvent() Exception in JVT JMS method", (Throwable)e);
            e.printStackTrace();
        }
        _event.setApplicationDN(this.xvt_event_topic_name);
        try {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"AlarmMonitorDaoImpl:sendJMSEvent() completed the look-up, creating XVT topic connection");
            }
            xvtconn = tcf.createTopicConnection();
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"AlarmMonitorDaoImpl:sendJMSEvent() connection created, creating XVT session");
            }
            xvtsession = xvtconn.createTopicSession(false, 1);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"AlarmMonitorDaoImpl:sendJMSEvent() created topic session, looking up XVT topic");
            }
            xvteventTopic = (Topic)ic.lookup(this.xvt_event_topic_name);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"AlarmMonitorDaoImpl:sendJMSEvent() topic retrieved, starting XVT connection");
            }
            xvtconn.start();
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"AlarmMonitorDaoImpl:sendJMSEvent() connection started, creating XVT publisher");
            }
            xvteventPublisher = xvtsession.createPublisher(xvteventTopic);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"AlarmMonitorDaoImpl:sendJMSEvent() XVT publisher created");
            }
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"AlarmMonitorDaoImpl:sendJMSEvent() Sending XVT JMS message");
            }
            try {
                String xmltosend = OOSSQosEventXmlJvtDocumentMarshaler.QosEventToDocument((IRPEvent)_event);
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("AlarmMonitorDaoImpl:sendJMSEvent() XML message to send:\n" + xmltosend + "\n"));
                }
                TextMessage msg = xvtsession.createTextMessage(xmltosend);
                this.populateMessagePropertiesfromEvent((Event)_event, (Message)msg);
                xvteventPublisher.publish((Message)msg);
            }
            catch (IllegalArgumentException iae) {
                logger.error((Object)("sendJMSEvent() IllegalArgumentException converting event to document" + (Object)((Object)iae)));
            }
            xvtsession.close();
            xvtconn.close();
            xvteventPublisher.close();
        }
        catch (JMSException je) {
            logger.error((Object)"sendJMSEvent() - XVT JMS Exception Caught", (Throwable)je);
        }
        catch (NamingException ne) {
            logger.error((Object)"sendJMSEvent() - XVT JMS NamingException Caught", (Throwable)ne);
        }
        catch (NullPointerException npe) {
            logger.error((Object)"sendJMSEvent() NullPointer in XVT sendtestmessage");
            npe.printStackTrace();
        }
        catch (Exception e) {
            logger.error((Object)"sendJMSEvent() Exception in XVT JMS method", (Throwable)e);
            e.printStackTrace();
        }
        try {
            ic.close();
        }
        catch (NamingException ne) {
            logger.error((Object)"sendJMSEvent() NamingException closing initial context", (Throwable)ne);
        }
    }

    public int getAlarmsHandledCount() {
        return this.alarmsHandled;
    }

    private InitialContext getInitialContext(String s) throws NamingException {
        try {
            Properties properties = new Properties();
            properties.put("java.naming.factory.initial", this.jndi_fact_class_name);
            properties.put("java.naming.provider.url", s);
            properties.put("java.naming.factory.url.pkgs", this.bean_naming_package);
            return new InitialContext(properties);
        }
        catch (NamingException namingexception) {
            System.err.println("Unable to get a connection to the application server at " + s);
            throw namingexception;
        }
    }

    public AlarmValueIterator queryAlarmList(QueryValue[] query, String[] attributes) throws IllegalArgumentException {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"AlarmMonitorDaoImpl:queryAlarmList(QueryValue[], String[]) - start");
        }
        OOSSAlarmValueIterator avi = new OOSSAlarmValueIterator();
        avi.setAlarms(current_AlarmList.values().toArray(new AlarmValue[0]));
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"AlarmMonitorDaoImpl:queryAlarmList(QueryValue[], String[]) - end");
        }
        return avi;
    }

    public void addAlarm(AlarmValue _in) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("AlarmMonitorDaoImpl:addAlarm - Alarm Received AlarmPrimaryKey: " + _in.getAlarmKey().getAlarmPrimaryKey() + "  ApplicationDN: " + _in.getAlarmKey().getApplicationDN()));
        }
        if (current_AlarmList.get(_in.getAlarmKey()) == null) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("AlarmMonitorDaoImpl:addAlarm - Adding Alarm to list AlarmPrimaryKey: " + _in.getAlarmKey().getAlarmPrimaryKey() + "  ApplicationDN: " + _in.getAlarmKey().getApplicationDN()));
            }
            current_AlarmList.put(_in.getAlarmKey(), _in);
            OOSSNotifyNewAlarmEvent nnae = new OOSSNotifyNewAlarmEvent(_in);
            nnae.setApplicationDN(this.ApplicationDN);
            nnae.setEventTime(new Date());
            this.sendJMSEvent((IRPEvent)nnae);
        }
    }

    public void deleteAlarm(AlarmValue delete_alarm) {
        AlarmValue deleted_alarm = null;
        try {
            deleted_alarm = (AlarmValue)current_AlarmList.remove(delete_alarm.getAlarmKey());
            if (deleted_alarm != null) {
                AlarmKey key = deleted_alarm.getAlarmKey();
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("AlarmMonitorDaoImpl:deleteAlarm - NotifyClearedAlarmEvent - clearing  AlarmPrimaryKey: " + key.getAlarmPrimaryKey() + "  ApplicationDN: " + key.getApplicationDN()));
                }
                AlarmValue av = (AlarmValue)current_AlarmList.get(key);
                OOSSNotifyClearedAlarmEvent clre = new OOSSNotifyClearedAlarmEvent(av);
                clre.setApplicationDN(this.ApplicationDN);
                clre.setAlarmKey(key);
                clre.setManagedObjectInstance(av.getManagedObjectInstance());
                clre.setEventTime(new Date());
                this.sendJMSEvent((IRPEvent)clre);
            }
        }
        catch (Exception ex) {
            logger.error((Object)"deleteAlarm - problem clearing alarm ");
            logger.error((Object)ex);
        }
    }

    public void updateAlarm(AlarmValue update_alarm) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"AlarmMonitorDaoImpl:updateAlarm - updating alarm");
        }
        AlarmKey key = update_alarm.getAlarmKey();
        if (update_alarm.getPerceivedSeverity() == 6 && update_alarm.getAlarmAckState() == 1) {
            if ((AlarmValue)current_AlarmList.get(key) == null) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("AlarmMonitorDaoImpl:updateAlarm - Alarm CLR & ACK - already deleted -ignoring - AlarmPrimaryKey: " + key.getAlarmPrimaryKey() + "  ApplicationDN: " + key.getApplicationDN()));
                }
            } else {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("AlarmMonitorDaoImpl:updateAlarm - Alarm CLR & ACK deleting and NotifyClearedAlarmEvent - AlarmPrimaryKey: " + key.getAlarmPrimaryKey() + "  ApplicationDN: " + key.getApplicationDN()));
                }
                current_AlarmList.remove(key);
                OOSSNotifyClearedAlarmEvent clre = new OOSSNotifyClearedAlarmEvent(update_alarm);
                clre.setApplicationDN(this.ApplicationDN);
                clre.setAlarmKey(key);
                clre.setEventTime(new Date());
                this.sendJMSEvent((IRPEvent)clre);
            }
            return;
        }
        if ((AlarmValue)current_AlarmList.get(key) == null) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("AlarmMonitorDaoImpl:updateAlarm - Alarm is new - AlarmPrimaryKey: " + key.getAlarmPrimaryKey() + "  ApplicationDN: " + key.getApplicationDN()));
            }
            current_AlarmList.put(key, update_alarm);
            OOSSNotifyNewAlarmEvent nnae = new OOSSNotifyNewAlarmEvent(update_alarm);
            nnae.setApplicationDN(this.ApplicationDN);
            nnae.setEventTime(new Date());
            this.sendJMSEvent((IRPEvent)nnae);
        } else {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("AlarmMonitorDaoImpl:updateAlarm - Alarm is NOT new - AlarmPrimaryKey: " + key.getAlarmPrimaryKey() + "  ApplicationDN: " + key.getApplicationDN()));
            }
            AlarmValue av_new = update_alarm;
            AlarmValue av_old = (AlarmValue)current_AlarmList.get(key);
            current_AlarmList.put(key, update_alarm);
            short ps_new = av_new.getPerceivedSeverity();
            short ps_old = av_old.getPerceivedSeverity();
            Date t1 = av_new.getAlarmChangedTime();
            Date t2 = av_old.getAlarmChangedTime();
            if (ps_new != ps_old) {
                if (ps_new == 6) {
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("AlarmMonitorDaoImpl:updateAlarm - NotifyClearedAlarmEvent - AlarmPrimaryKey: " + key.getAlarmPrimaryKey() + "  ApplicationDN: " + key.getApplicationDN() + " Old severity: " + ps_old + " New severity: " + ps_new));
                    }
                    OOSSNotifyClearedAlarmEvent clre = new OOSSNotifyClearedAlarmEvent(update_alarm);
                    clre.setApplicationDN(this.ApplicationDN);
                    clre.setAlarmKey(key);
                    clre.setEventTime(new Date());
                    this.sendJMSEvent((IRPEvent)clre);
                } else {
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("AlarmMonitorDaoImpl:updateAlarm - NotifyChangedAlarmEvent - AlarmPrimaryKey: " + key.getAlarmPrimaryKey() + "  ApplicationDN: " + key.getApplicationDN() + " Old severity: " + ps_old + " New severity: " + ps_new));
                    }
                    OOSSNotifyChangedAlarmEvent ncae = new OOSSNotifyChangedAlarmEvent(update_alarm);
                    ncae.setApplicationDN(this.ApplicationDN);
                    ncae.setAlarmKey(key);
                    ncae.setEventTime(new Date());
                    this.sendJMSEvent((IRPEvent)ncae);
                }
            } else if (t1.compareTo(t2) != 0) {
                OOSSNotifyChangedAlarmEvent ncae = new OOSSNotifyChangedAlarmEvent(update_alarm);
                ncae.setApplicationDN(this.ApplicationDN);
                ncae.setAlarmKey(key);
                ncae.setEventTime(new Date());
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("AlarmMonitorDaoImpl:updateAlarm - Updating Alarm -  AlarmPrimaryKey: " + key.getAlarmPrimaryKey() + "  ApplicationDN: " + key.getApplicationDN()));
                }
                this.sendJMSEvent((IRPEvent)ncae);
            }
            int ack_new = av_new.getAlarmAckState();
            int ack_old = av_old.getAlarmAckState();
            if (ack_new != ack_old) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("AlarmMonitorDaoImpl:updateAlarm - NotifyAckStateChangedEvent - AlarmPrimaryKey: " + key.getAlarmPrimaryKey() + "  ApplicationDN: " + key.getApplicationDN() + " Old Ack State: " + ack_old + " New Ack State: " + ack_new));
                }
                OOSSNotifyAckStateChangedEvent asce = new OOSSNotifyAckStateChangedEvent(update_alarm);
                asce.setApplicationDN(this.ApplicationDN);
                asce.setAlarmKey(key);
                asce.setEventTime(new Date());
                this.sendJMSEvent((IRPEvent)asce);
            }
        }
    }

    public void updateAlarmList(Hashtable updateList) {
        AlarmKey key;
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"AlarmMonitorDaoImpl:*******updateAlarmList - updating list");
        }
        Enumeration test = updateList.keys();
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"AlarmMonitorDaoImpl:Recieved primary keys");
        }
        while (test.hasMoreElements()) {
            key = (AlarmKey)test.nextElement();
            if (!logger.isDebugEnabled()) continue;
            logger.debug((Object)("AlarmMonitorDaoImpl:key : " + key.getPrimaryKey()));
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"AlarmMonitorDaoImpl:*******updateAlarmList - END OF LIST");
        }
        Enumeration oldkeyEnum = current_AlarmList.keys();
        while (oldkeyEnum.hasMoreElements()) {
            key = (AlarmKey)oldkeyEnum.nextElement();
            if ((AlarmValue)updateList.get(key) != null) continue;
            AlarmValue av = (AlarmValue)current_AlarmList.get(key);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("AlarmMonitorDaoImpl:updateAlarmList - Alarm not in received alarm list - deleting - AlarmPrimaryKey: " + key.getAlarmPrimaryKey() + "  ApplicationDN: " + key.getApplicationDN()));
            }
            current_AlarmList.remove(key);
            if (av.getPerceivedSeverity() == 6 || av.getAlarmAckState() == 1) continue;
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("AlarmMonitorDaoImpl:updateAlarmList - sending NotifyClearedAlarmEvent - AlarmPrimaryKey: " + key.getAlarmPrimaryKey() + "  ApplicationDN: " + key.getApplicationDN()));
            }
            av.setPerceivedSeverity((short)6);
            av.setAlarmAckState(1);
            OOSSNotifyClearedAlarmEvent clre = new OOSSNotifyClearedAlarmEvent(av);
            clre.setApplicationDN(this.ApplicationDN);
            clre.setAlarmKey(key);
            clre.setEventTime(new Date());
            this.sendJMSEvent((IRPEvent)clre);
        }
        Enumeration keyEnum = updateList.keys();
        while (keyEnum.hasMoreElements()) {
            key = (AlarmKey)keyEnum.nextElement();
            this.updateAlarm((AlarmValue)updateList.get(key));
        }
    }

    public void rebuildAlarmList(String _rebuild_reason) {
        current_AlarmList = new Hashtable();
        OOSSNotifyAlarmListRebuiltEvent nalre = new OOSSNotifyAlarmListRebuiltEvent();
        nalre.setApplicationDN(this.ApplicationDN);
        nalre.setReason(_rebuild_reason);
        nalre.setEventTime(new Date());
        nalre.setManagedObjectClass("NOT_SET_ManagedObjectClass");
        nalre.setManagedObjectInstance("NOT_SET_ManagedObjectInstance");
        nalre.setNotificationId("AlmMonitorId:" + this.id + ":EventCount:" + this.notification_count);
        this.sendJMSEvent((IRPEvent)nalre);
    }

    public void setAlarmList(Hashtable _in) {
        current_AlarmList = _in;
        OOSSNotifyAlarmListRebuiltEvent nalre = new OOSSNotifyAlarmListRebuiltEvent();
        nalre.setApplicationDN(this.ApplicationDN);
        this.sendJMSEvent((IRPEvent)nalre);
    }

    public AlarmKeyResult[] tryAcknowledgeAlarms(AlarmKey[] alarmReferenceList, String ackUserId, String ackSystemId) throws IllegalArgumentException {
        return this.setAck(alarmReferenceList, ackUserId, ackSystemId, 1);
    }

    public AlarmKeyResult[] tryUnacknowledgeAlarms(AlarmKey[] alarmReferenceList, String ackUserId, String ackSystemId) throws IllegalArgumentException, UnsupportedOperationException {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"AlarmMonitorDaoImpl:tryUnacknowledgeAlarms(AlarmKey[], String, String) - start");
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"AlarmMonitorDaoImpl:tryUnacknowledgeAlarms(AlarmKey[], String, String) - end");
        }
        return this.setAck(alarmReferenceList, ackUserId, ackSystemId, 2);
    }

    private AlarmKeyResult[] setAck(AlarmKey[] alarmReferenceList, String ackUserId, String ackSystemId, int ackState) throws IllegalArgumentException {
        ArrayList<OOSSAlarmKeyResult> toReturn_ = new ArrayList<OOSSAlarmKeyResult>();
        for (int i = 0; i < alarmReferenceList.length; ++i) {
            AlarmValue av1 = (AlarmValue)current_AlarmList.get(alarmReferenceList[i]);
            if (av1 == null) {
                OOSSAlarmKeyResult akr = new OOSSAlarmKeyResult();
                akr.setSuccess(false);
                akr.setManagedEntityKey((ManagedEntityKey)alarmReferenceList[i]);
                akr.setException((Exception)((Object)new IllegalArgumentException()));
                toReturn_.add(akr);
                continue;
            }
            try {
                OOSSNotifyAckStateChangedEvent new_ack = new OOSSNotifyAckStateChangedEvent();
                new_ack.setAckSystemId(ackSystemId);
                new_ack.setAckUserId(ackUserId);
                new_ack.setAckTime(new Date());
                new_ack.setAlarmAckState(ackState);
                new_ack.setApplicationDN(this.ApplicationDN);
                this.sendJMSEvent((IRPEvent)new_ack);
                current_AlarmList.remove(alarmReferenceList[i]);
                continue;
            }
            catch (Exception re) {
                OOSSAlarmKeyResult akr = new OOSSAlarmKeyResult();
                akr.setSuccess(false);
                akr.setManagedEntityKey((ManagedEntityKey)alarmReferenceList[i]);
                akr.setException(re);
                toReturn_.add(akr);
            }
        }
        return toReturn_.toArray(new AlarmKeyResult[0]);
    }

    public AlarmValue getAlarmbyAppDNPrimaryKey(String applicationDN, String primarykey) {
        AlarmValue av = null;
        Enumeration keyEnum = current_AlarmList.keys();
        try {
            while (keyEnum.hasMoreElements()) {
                AlarmKey akey = (AlarmKey)keyEnum.nextElement();
                if (!akey.getAlarmPrimaryKey().equals(primarykey) || !akey.getApplicationDN().equals(applicationDN)) continue;
                av = (AlarmValue)current_AlarmList.get(akey);
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("AlarmMonitorDaoImpl:getAlarmbyAppDNPrimaryKey Found alarm - applicationDN: " + applicationDN + " primarykey: " + primarykey + "Raised time: " + av.getAlarmRaisedTime()));
                }
                return av;
            }
        }
        catch (Exception e) {
            logger.error((Object)("getAlarmbyAppDNPrimaryKey Exception " + e));
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("AlarmMonitorDaoImpl:getAlarmbyAppDNPrimaryKey Alarm Not Found - applicationDN: " + applicationDN + " primarykey: " + primarykey));
        }
        return null;
    }
}

