/*
 * Decompiled with CFR 0.152.
 */
package org.openoss.ossj.fm.monitor.j2ee;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.Serializable;
import java.lang.reflect.UndeclaredThrowableException;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import javax.ejb.CreateException;
import javax.ejb.EJBException;
import javax.ejb.SessionBean;
import javax.ejb.SessionContext;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.Topic;
import javax.jms.TopicConnection;
import javax.jms.TopicConnectionFactory;
import javax.jms.TopicPublisher;
import javax.jms.TopicSession;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.oss.EventPropertyDescriptor;
import javax.oss.IllegalArgumentException;
import javax.oss.ManagedEntityKey;
import javax.oss.ManagedEntityValue;
import javax.oss.ManagedEntityValueIterator;
import javax.oss.QueryValue;
import javax.oss.UnsupportedOperationException;
import javax.oss.fm.monitor.AlarmCountsValue;
import javax.oss.fm.monitor.AlarmKey;
import javax.oss.fm.monitor.AlarmKeyResult;
import javax.oss.fm.monitor.AlarmValue;
import javax.oss.fm.monitor.AlarmValueIterator;
import javax.oss.util.IRPEvent;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.openoss.ossj.fm.monitor.j2ee.AlarmMonitorUtil;
import org.openoss.ossj.fm.monitor.j2ee.BeanPropertiesLoader;
import org.openoss.ossj.jvt.fm.monitor.OOSSAlarmKeyResult;
import org.openoss.ossj.jvt.fm.monitor.OOSSAlarmValueIterator;
import org.openoss.ossj.jvt.fm.monitor.OOSSNotifyAckStateChangedEvent;
import org.openoss.ossj.jvt.fm.monitor.OOSSNotifyAlarmListRebuiltEvent;
import org.openoss.ossj.jvt.fm.monitor.OOSSNotifyChangedAlarmEvent;
import org.openoss.ossj.jvt.fm.monitor.OOSSNotifyClearedAlarmEvent;
import org.openoss.ossj.jvt.fm.monitor.OOSSNotifyNewAlarmEvent;
import org.openoss.ossj.xml.fm.monitor.OOSSQosEventXmlJvtDocumentMarshaler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AlarmMonitorBean
implements SessionBean {
    private static final Log logger = LogFactory.getLog(AlarmMonitorBean.class);
    private SessionContext sctx;
    private int alarmsHandled;
    private String ApplicationDN = "NOT_SET";
    private static Hashtable<AlarmKey, AlarmValue> current_AlarmList = new Hashtable();
    String id;
    int notification_count = 0;
    private static BeanPropertiesLoader props;
    String JNDI_FACT_CLASS_NAME = "org.jnp.interfaces.NamingContextFactory";
    String JNDI_URL = "jnp://jbossjmsserver1:1099";
    String BEAN_NAMING_PACKAGE = "org.jboss.naming";
    String TOPIC_CONNECTION_FACTORY_NAME = "System/OpenOSS/ApplicationType/AlarmMonitor/Application/1-0;0-0;OpenNMS_OpenOSS_AM/Comp/TopicConnectionFactory";
    String JVT_EVENT_TOPIC_NAME = "System/OpenOSS/ApplicationType/AlarmMonitor/Application/1-0;0-0;OpenNMS_OpenOSS_AM/Comp/JVTEventTopic";
    String XVT_EVENT_TOPIC_NAME = "System/OpenOSS/ApplicationType/AlarmMonitor/Application/1-0;0-0;OpenNMS_OpenOSS_AM/Comp/XVTEventTopic";

    private static void initJMS() {
    }

    public void ejbCreate(String dummy) {
    }

    public String getId() {
        return this.id;
    }

    public void setId(String _id) {
        this.id = _id;
    }

    public void sendJMSEvent(IRPEvent _event) {
        InitialContext ic = null;
        TopicConnectionFactory tcf = null;
        Topic jvteventTopic = null;
        TopicSession jvtsession = null;
        TopicConnection jvtconn = null;
        TopicPublisher jvteventPublisher = null;
        Topic xvteventTopic = null;
        TopicSession xvtsession = null;
        TopicConnection xvtconn = null;
        TopicPublisher xvteventPublisher = null;
        ++this.notification_count;
        _event.setNotificationId("AlmMonitorId:" + this.id + ":EventCount:" + this.notification_count);
        _event.setApplicationDN(this.JVT_EVENT_TOPIC_NAME);
        try {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"sendJMSEvent() Looking Up InitialContext for JMS queue lookup");
            }
            ic = this.getInitialContext(this.JNDI_URL);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"sendJMSEvent() got the context");
            }
            tcf = (TopicConnectionFactory)ic.lookup(this.TOPIC_CONNECTION_FACTORY_NAME);
        }
        catch (NamingException ne) {
            logger.error((Object)"sendJMSEvent() NamingException looking up initial context and topic connection factory", (Throwable)ne);
        }
        try {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"sendJMSEvent() completed the look-up, creating JVT topic connection");
            }
            jvtconn = tcf.createTopicConnection();
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"sendJMSEvent() connection created, creating JVT session");
            }
            jvtsession = jvtconn.createTopicSession(false, 1);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"sendJMSEvent() created topic session, looking up JVT topic");
            }
            jvteventTopic = (Topic)ic.lookup(this.JVT_EVENT_TOPIC_NAME);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"sendJMSEvent() topic retrieved, starting JVT connection");
            }
            jvtconn.start();
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"sendJMSEvent() connection started, creating JVT publisher");
            }
            jvteventPublisher = jvtsession.createPublisher(jvteventTopic);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"sendJMSEvent() JVT publisher created");
            }
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"sendJMSEvent() Sending JVT JMS message");
            }
            jvteventPublisher.publish((Message)jvtsession.createObjectMessage((Serializable)_event));
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"sendJMSEvent() JVT  JMS event sent");
            }
            jvtsession.close();
            jvtconn.close();
            jvteventPublisher.close();
        }
        catch (JMSException je) {
            logger.error((Object)"sendJMSEvent() - JVT JMS Exception Caught", (Throwable)je);
        }
        catch (NamingException ne) {
            logger.error((Object)"sendJMSEvent() - JVT JMS NamingException Caught", (Throwable)ne);
        }
        catch (NullPointerException npe) {
            logger.error((Object)"sendJMSEvent() NullPointer in JVT sendtestmessage");
            npe.printStackTrace();
        }
        catch (Exception e) {
            logger.error((Object)"sendJMSEvent() Exception in JVT JMS method", (Throwable)e);
            e.printStackTrace();
        }
        _event.setApplicationDN(this.XVT_EVENT_TOPIC_NAME);
        try {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"sendJMSEvent() completed the look-up, creating XVT topic connection");
            }
            xvtconn = tcf.createTopicConnection();
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"sendJMSEvent() connection created, creating XVT session");
            }
            xvtsession = xvtconn.createTopicSession(false, 1);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"sendJMSEvent() created topic session, looking up XVT topic");
            }
            xvteventTopic = (Topic)ic.lookup(this.XVT_EVENT_TOPIC_NAME);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"sendJMSEvent() topic retrieved, starting XVT connection");
            }
            xvtconn.start();
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"sendJMSEvent() connection started, creating XVT publisher");
            }
            xvteventPublisher = xvtsession.createPublisher(xvteventTopic);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"sendJMSEvent() XVT publisher created");
            }
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"sendJMSEvent() Sending XVT JMS message");
            }
            try {
                String xmltosend = OOSSQosEventXmlJvtDocumentMarshaler.QosEventToDocument((IRPEvent)_event);
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("sendJMSEvent() received string:\n" + xmltosend + "\n"));
                }
                xvteventPublisher.publish((Message)xvtsession.createTextMessage(xmltosend));
            }
            catch (IllegalArgumentException iae) {
                logger.error((Object)("sendJMSEvent() IllegalArgumentException converting event to document" + (Object)((Object)iae)));
            }
            xvtsession.close();
            xvtconn.close();
            xvteventPublisher.close();
        }
        catch (JMSException je) {
            logger.error((Object)"sendJMSEvent() - XVT JMS Exception Caught", (Throwable)je);
        }
        catch (NamingException ne) {
            logger.error((Object)"sendJMSEvent() - XVT JMS NamingException Caught", (Throwable)ne);
        }
        catch (NullPointerException npe) {
            logger.error((Object)"sendJMSEvent() NullPointer in XVT sendtestmessage");
            npe.printStackTrace();
        }
        catch (Exception e) {
            logger.error((Object)"sendJMSEvent() Exception in XVT JMS method", (Throwable)e);
            e.printStackTrace();
        }
        try {
            ic.close();
        }
        catch (NamingException ne) {
            logger.error((Object)"sendJMSEvent() NamingException closing initial context", (Throwable)ne);
        }
    }

    public int getAlarmsHandledCount() {
        return this.alarmsHandled;
    }

    private void loadBeanProperties() {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"AlarmMonitorBean loading initial properties");
        }
        try {
            props = BeanPropertiesLoader.getInstance();
        }
        catch (FileNotFoundException fnf_ex) {
            String propertiesFilename = System.getProperty("qosbeanpropertiesFile");
            logger.error((Object)("AlarmMonitorBean.loadBeanProperties: Could not find properties file: " + propertiesFilename + fnf_ex));
            throw new UndeclaredThrowableException(fnf_ex);
        }
        catch (IOException io_ex) {
            String propertiesFilename = System.getProperty("qosbeanpropertiesFile");
            logger.error((Object)("AlarmMonitorBean.loadBeanProperties: Could not read from properties file: " + propertiesFilename + "\n\t\t\t\tPlease check the file permissions" + io_ex));
            throw new UndeclaredThrowableException(io_ex);
        }
        logger.info((Object)("AlarmMonitorBean: Client Properties File Loaded: " + System.getProperty("qosbeanpropertiesFile")));
        if (props.getProperty("org.openoss.qosbean.naming.provider") != null) {
            this.JNDI_URL = props.getProperty("org.openoss.qosbean.naming.provider");
            logger.info((Object)("AlarmMonitorBean Using JNP: " + this.JNDI_URL));
        } else {
            this.JNDI_URL = "jnp://jbossjmsserver1:1099";
            logger.warn((Object)("AlarmMonitorBean property not set: org.openoss.qosbean.naming.provider , Using default: " + this.JNDI_URL));
        }
        if (props.getProperty("org.openoss.qosbean.naming.pkg") != null) {
            this.BEAN_NAMING_PACKAGE = props.getProperty("org.openoss.qosbean.naming.pkg");
            logger.info((Object)("AlarmMonitorBean Using org.openoss.qosbean.naming.pkg " + this.BEAN_NAMING_PACKAGE));
        } else {
            this.BEAN_NAMING_PACKAGE = "org.jboss.naming";
            logger.warn((Object)("AlarmMonitorBean property not set: org.openoss.qosbean.naming.pkg , Using default: " + this.BEAN_NAMING_PACKAGE));
        }
        if (props.getProperty("org.openoss.qosbean.naming.contextfactory") != null) {
            this.JNDI_FACT_CLASS_NAME = props.getProperty("org.openoss.qosbean.naming.contextfactory");
            logger.info((Object)("AlarmMonitorBean Using org.openoss.qosbean.naming.contextfactory: " + this.JNDI_FACT_CLASS_NAME));
        } else {
            this.JNDI_FACT_CLASS_NAME = "org.jnp.interfaces.NamingContextFactory";
            logger.warn((Object)("AlarmMonitorBean property not set: org.openoss.qosbean.naming.contextfactory , Using default: " + this.JNDI_FACT_CLASS_NAME));
        }
        if (props.getProperty("org.openoss.qosbean.jms.topicconnectionfactory") != null) {
            this.TOPIC_CONNECTION_FACTORY_NAME = props.getProperty("org.openoss.qosbean.jms.topicconnectionfactory");
            logger.info((Object)("AlarmMonitorBean Using org.openoss.qosbean.jms.topicconnectionfactory: " + this.TOPIC_CONNECTION_FACTORY_NAME));
        } else {
            this.TOPIC_CONNECTION_FACTORY_NAME = "System/OpenOSS/ApplicationType/AlarmMonitor/Application/1-0;0-0;OpenNMS_OpenOSS_AM/Comp/TopicConnectionFactory";
            logger.warn((Object)("AlarmMonitorBean property not set: org.openoss.qosbean.jms.topicconnectionfactory , Using default: " + this.TOPIC_CONNECTION_FACTORY_NAME));
        }
        if (props.getProperty("org.openoss.qosbean.jms.topic") != null) {
            this.JVT_EVENT_TOPIC_NAME = props.getProperty("org.openoss.qosbean.jms.topic");
            logger.info((Object)("AlarmMonitorBean Using org.openoss.qosbean.jms.topic: " + this.JVT_EVENT_TOPIC_NAME));
        } else {
            this.JVT_EVENT_TOPIC_NAME = "System/OpenOSS/ApplicationType/AlarmMonitor/Application/1-0;0-0;OpenNMS_OpenOSS_AM/Comp/JVTEventTopic";
            logger.warn((Object)("AlarmMonitorBean property not set: org.openoss.qosbean.jms.topic , Using default: " + this.JVT_EVENT_TOPIC_NAME));
        }
        if (props.getProperty("org.openoss.qosbean.jms.xvttopic") != null) {
            this.XVT_EVENT_TOPIC_NAME = props.getProperty("org.openoss.qosbean.jms.xvttopic");
            logger.info((Object)("AlarmMonitorBean Using org.openoss.qosbean.jms.xvttopic: " + this.XVT_EVENT_TOPIC_NAME));
        } else {
            this.XVT_EVENT_TOPIC_NAME = "System/OpenOSS/ApplicationType/AlarmMonitor/Application/1-0;0-0;OpenNMS_OpenOSS_AM/Comp/XVTEventTopic";
            logger.warn((Object)("AlarmMonitorBean property not set: org.openoss.qosbean.jms.xvttopic , Using default: " + this.XVT_EVENT_TOPIC_NAME));
        }
    }

    private InitialContext getInitialContext(String s) throws NamingException {
        try {
            Properties properties = new Properties();
            properties.put("java.naming.factory.initial", this.JNDI_FACT_CLASS_NAME);
            properties.put("java.naming.provider.url", s);
            properties.put("java.naming.factory.url.pkgs", this.BEAN_NAMING_PACKAGE);
            return new InitialContext(properties);
        }
        catch (NamingException namingexception) {
            System.err.println("Unable to get a connection to the application server at " + s);
            throw namingexception;
        }
    }

    public void ejbCreate() throws CreateException {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"ejbCreate() - start");
        }
        this.loadBeanProperties();
        this.alarmsHandled = 0;
        this.setId(AlarmMonitorUtil.generateGUID(this));
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"ejbCreate() - end");
        }
    }

    public void setSessionContext(SessionContext ctx) throws EJBException {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"setSessionContext(SessionContext) - start");
        }
        this.sctx = ctx;
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"setSessionContext(SessionContext) - end");
        }
    }

    public void ejbRemove() throws EJBException {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"ejbRemove() - start");
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"ejbRemove() - end");
        }
    }

    public void ejbActivate() throws EJBException {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"ejbActivate() - start");
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"ejbActivate() - end");
        }
    }

    public void ejbPassivate() throws EJBException {
        logger.info((Object)"AlarmMonitorBean: ejbPassivate() - start");
    }

    public AlarmValueIterator queryAlarmList(QueryValue[] query, String[] attributes) throws IllegalArgumentException {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"queryAlarmList(QueryValue[], String[]) - start");
        }
        OOSSAlarmValueIterator avi = new OOSSAlarmValueIterator();
        avi.setAlarms(current_AlarmList.values().toArray(new AlarmValue[0]));
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"queryAlarmList(QueryValue[], String[]) - end");
        }
        return avi;
    }

    public void addAlarm(AlarmValue _in) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("addAlarm - Alarm Received AlarmPrimaryKey: " + _in.getAlarmKey().getAlarmPrimaryKey() + "  ApplicationDN: " + _in.getAlarmKey().getApplicationDN()));
        }
        if (current_AlarmList.get(_in.getAlarmKey()) == null) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("addAlarm - Adding Alarm to list AlarmPrimaryKey: " + _in.getAlarmKey().getAlarmPrimaryKey() + "  ApplicationDN: " + _in.getAlarmKey().getApplicationDN()));
            }
            current_AlarmList.put(_in.getAlarmKey(), _in);
            OOSSNotifyNewAlarmEvent nnae = new OOSSNotifyNewAlarmEvent(_in);
            nnae.setApplicationDN(this.ApplicationDN);
            nnae.setEventTime(new Date());
            this.sendJMSEvent((IRPEvent)nnae);
        }
    }

    public void deleteAlarm(AlarmValue delete_alarm) {
        AlarmValue deleted_alarm = null;
        try {
            deleted_alarm = current_AlarmList.remove(delete_alarm.getAlarmKey());
            if (deleted_alarm != null) {
                AlarmKey key = deleted_alarm.getAlarmKey();
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("deleteAlarm - NotifyClearedAlarmEvent - clearing  AlarmPrimaryKey: " + key.getAlarmPrimaryKey() + "  ApplicationDN: " + key.getApplicationDN()));
                }
                AlarmValue av = current_AlarmList.get(key);
                OOSSNotifyClearedAlarmEvent clre = new OOSSNotifyClearedAlarmEvent(av);
                clre.setApplicationDN(this.ApplicationDN);
                clre.setAlarmKey(key);
                clre.setManagedObjectInstance(av.getManagedObjectInstance());
                clre.setEventTime(new Date());
                this.sendJMSEvent((IRPEvent)clre);
            }
        }
        catch (Exception ex) {
            logger.error((Object)"deleteAlarm - problem clearing alarm ");
            logger.error((Object)ex);
        }
    }

    public void updateAlarm(AlarmValue update_alarm) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"updateAlarm - updating alarm");
        }
        AlarmKey key = update_alarm.getAlarmKey();
        if (update_alarm.getPerceivedSeverity() == 6 && update_alarm.getAlarmAckState() == 1) {
            if (current_AlarmList.get(key) == null) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("updateAlarm - Alarm CLR & ACK - already deleted -ignoring - AlarmPrimaryKey: " + key.getAlarmPrimaryKey() + "  ApplicationDN: " + key.getApplicationDN()));
                }
            } else {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("updateAlarm - Alarm CLR & ACK deleting and NotifyClearedAlarmEvent - AlarmPrimaryKey: " + key.getAlarmPrimaryKey() + "  ApplicationDN: " + key.getApplicationDN()));
                }
                current_AlarmList.remove(key);
                OOSSNotifyClearedAlarmEvent clre = new OOSSNotifyClearedAlarmEvent(update_alarm);
                clre.setApplicationDN(this.ApplicationDN);
                clre.setAlarmKey(key);
                clre.setEventTime(new Date());
                this.sendJMSEvent((IRPEvent)clre);
            }
            return;
        }
        if (current_AlarmList.get(key) == null) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("updateAlarm - Alarm is new - AlarmPrimaryKey: " + key.getAlarmPrimaryKey() + "  ApplicationDN: " + key.getApplicationDN()));
            }
            current_AlarmList.put(key, update_alarm);
            OOSSNotifyNewAlarmEvent nnae = new OOSSNotifyNewAlarmEvent(update_alarm);
            nnae.setApplicationDN(this.ApplicationDN);
            nnae.setEventTime(new Date());
            this.sendJMSEvent((IRPEvent)nnae);
        } else {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("updateAlarm - Alarm is NOT new - AlarmPrimaryKey: " + key.getAlarmPrimaryKey() + "  ApplicationDN: " + key.getApplicationDN()));
            }
            AlarmValue av_new = update_alarm;
            AlarmValue av_old = current_AlarmList.get(key);
            current_AlarmList.put(key, update_alarm);
            short ps_new = av_new.getPerceivedSeverity();
            short ps_old = av_old.getPerceivedSeverity();
            Date t1 = av_new.getAlarmChangedTime();
            Date t2 = av_old.getAlarmChangedTime();
            if (ps_new != ps_old) {
                if (ps_new == 6) {
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("updateAlarm - NotifyClearedAlarmEvent - AlarmPrimaryKey: " + key.getAlarmPrimaryKey() + "  ApplicationDN: " + key.getApplicationDN() + " Old severity: " + ps_old + " New severity: " + ps_new));
                    }
                    OOSSNotifyClearedAlarmEvent clre = new OOSSNotifyClearedAlarmEvent(update_alarm);
                    clre.setApplicationDN(this.ApplicationDN);
                    clre.setAlarmKey(key);
                    clre.setEventTime(new Date());
                    this.sendJMSEvent((IRPEvent)clre);
                } else {
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("updateAlarm - NotifyChangedAlarmEvent - AlarmPrimaryKey: " + key.getAlarmPrimaryKey() + "  ApplicationDN: " + key.getApplicationDN() + " Old severity: " + ps_old + " New severity: " + ps_new));
                    }
                    OOSSNotifyChangedAlarmEvent ncae = new OOSSNotifyChangedAlarmEvent(update_alarm);
                    ncae.setApplicationDN(this.ApplicationDN);
                    ncae.setAlarmKey(key);
                    ncae.setEventTime(new Date());
                    this.sendJMSEvent((IRPEvent)ncae);
                }
            } else if (t1.compareTo(t2) != 0) {
                OOSSNotifyChangedAlarmEvent ncae = new OOSSNotifyChangedAlarmEvent(update_alarm);
                ncae.setApplicationDN(this.ApplicationDN);
                ncae.setAlarmKey(key);
                ncae.setEventTime(new Date());
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("updateAlarm - Updating Alarm -  AlarmPrimaryKey: " + key.getAlarmPrimaryKey() + "  ApplicationDN: " + key.getApplicationDN()));
                }
                this.sendJMSEvent((IRPEvent)ncae);
            }
            int ack_new = av_new.getAlarmAckState();
            int ack_old = av_old.getAlarmAckState();
            if (ack_new != ack_old) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("updateAlarm - NotifyAckStateChangedEvent - AlarmPrimaryKey: " + key.getAlarmPrimaryKey() + "  ApplicationDN: " + key.getApplicationDN() + " Old Ack State: " + ack_old + " New Ack State: " + ack_new));
                }
                OOSSNotifyAckStateChangedEvent asce = new OOSSNotifyAckStateChangedEvent(update_alarm);
                asce.setApplicationDN(this.ApplicationDN);
                asce.setAlarmKey(key);
                asce.setEventTime(new Date());
                this.sendJMSEvent((IRPEvent)asce);
            }
        }
    }

    public void updateAlarmList_original(Hashtable<AlarmKey, AlarmValue> updateList) {
        OOSSNotifyClearedAlarmEvent clre;
        AlarmKey key;
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"updateAlarmList - updating list");
        }
        Hashtable<AlarmKey, AlarmValue> current_AlarmListOld = current_AlarmList;
        current_AlarmList = updateList;
        Enumeration<AlarmKey> keyEnum = current_AlarmList.keys();
        while (keyEnum.hasMoreElements()) {
            int ack_old;
            int ack_new;
            OOSSNotifyChangedAlarmEvent ncae;
            key = keyEnum.nextElement();
            if (current_AlarmListOld.get(key) == null) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("updateAlarmList - Alarm is new - AlarmPrimaryKey: " + key.getAlarmPrimaryKey()));
                }
                OOSSNotifyNewAlarmEvent nnae = new OOSSNotifyNewAlarmEvent();
                nnae.setApplicationDN(this.ApplicationDN);
                nnae.setAlarmKey(key);
                nnae.setEventTime(new Date());
                this.sendJMSEvent((IRPEvent)nnae);
                continue;
            }
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("updateAlarmList - Alarm is NOT new - AlarmPrimaryKey: " + key.getAlarmPrimaryKey()));
            }
            AlarmValue av_new = current_AlarmList.get(key);
            AlarmValue av_old = current_AlarmListOld.get(key);
            short ps_new = av_new.getPerceivedSeverity();
            short ps_old = av_old.getPerceivedSeverity();
            Date t1 = av_new.getAlarmChangedTime();
            Date t2 = av_old.getAlarmChangedTime();
            if (ps_new != ps_old) {
                if (ps_new == 6) {
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("updateAlarmList - NotifyClearedAlarmEvent - AlarmPrimaryKey: " + key.getAlarmPrimaryKey() + " Old severity: " + ps_old + " New severity: " + ps_new));
                    }
                    clre = new OOSSNotifyClearedAlarmEvent();
                    clre.setApplicationDN(this.ApplicationDN);
                    clre.setAlarmKey(key);
                    clre.setEventTime(new Date());
                    this.sendJMSEvent((IRPEvent)clre);
                } else {
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("updateAlarmList - NotifyChangedAlarmEvent - AlarmPrimaryKey: " + key.getAlarmPrimaryKey() + " Old severity: " + ps_old + " New severity: " + ps_new));
                    }
                    ncae = new OOSSNotifyChangedAlarmEvent();
                    ncae.setApplicationDN(this.ApplicationDN);
                    ncae.setAlarmKey(key);
                    ncae.setEventTime(new Date());
                    this.sendJMSEvent((IRPEvent)ncae);
                }
            } else if (t1.compareTo(t2) != 0) {
                ncae = new OOSSNotifyChangedAlarmEvent();
                ncae.setApplicationDN(this.ApplicationDN);
                ncae.setAlarmKey(key);
                ncae.setEventTime(new Date());
                logger.info((Object)("updateAlarmList - Updating Alarm -  AlarmPrimaryKey: " + key.getAlarmPrimaryKey()));
                this.sendJMSEvent((IRPEvent)ncae);
            }
            if ((ack_new = av_new.getAlarmAckState()) == (ack_old = av_old.getAlarmAckState())) continue;
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("updateAlarmList - NotifyAckStateChangedEvent - AlarmPrimaryKey: " + key.getAlarmPrimaryKey() + " Old Ack State: " + ack_old + " New Ack State: " + ack_new));
            }
            OOSSNotifyAckStateChangedEvent asce = new OOSSNotifyAckStateChangedEvent();
            asce.setApplicationDN(this.ApplicationDN);
            asce.setAlarmKey(key);
            asce.setEventTime(new Date());
            this.sendJMSEvent((IRPEvent)asce);
        }
        keyEnum = current_AlarmListOld.keys();
        while (keyEnum.hasMoreElements()) {
            key = keyEnum.nextElement();
            if (current_AlarmList.get(key) != null) continue;
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("updateAlarmList - NotifyClearedAlarmEvent - clearing  AlarmPrimaryKey: " + key.getAlarmPrimaryKey()));
            }
            clre = new OOSSNotifyClearedAlarmEvent();
            clre.setApplicationDN(this.ApplicationDN);
            this.sendJMSEvent((IRPEvent)clre);
        }
    }

    public void updateAlarmList(Hashtable updateList) {
        AlarmKey key;
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"*******updateAlarmList - updating list");
        }
        Enumeration test = updateList.keys();
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"Recieved primary keys");
        }
        while (test.hasMoreElements()) {
            key = (AlarmKey)test.nextElement();
            if (!logger.isDebugEnabled()) continue;
            logger.debug((Object)("key : " + key.getPrimaryKey()));
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"*******updateAlarmList - END OF LIST");
        }
        Enumeration<AlarmKey> oldkeyEnum = current_AlarmList.keys();
        while (oldkeyEnum.hasMoreElements()) {
            key = oldkeyEnum.nextElement();
            if ((AlarmValue)updateList.get(key) != null) continue;
            AlarmValue av = current_AlarmList.get(key);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("updateAlarmList - Alarm not in received alarm list - deleting - AlarmPrimaryKey: " + key.getAlarmPrimaryKey() + "  ApplicationDN: " + key.getApplicationDN()));
            }
            current_AlarmList.remove(key);
            if (av.getPerceivedSeverity() == 6 || av.getAlarmAckState() == 1) continue;
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("updateAlarmList - sending NotifyClearedAlarmEvent - AlarmPrimaryKey: " + key.getAlarmPrimaryKey() + "  ApplicationDN: " + key.getApplicationDN()));
            }
            av.setPerceivedSeverity((short)6);
            av.setAlarmAckState(1);
            OOSSNotifyClearedAlarmEvent clre = new OOSSNotifyClearedAlarmEvent(av);
            clre.setApplicationDN(this.ApplicationDN);
            clre.setAlarmKey(key);
            clre.setEventTime(new Date());
            this.sendJMSEvent((IRPEvent)clre);
        }
        Enumeration keyEnum = updateList.keys();
        while (keyEnum.hasMoreElements()) {
            key = (AlarmKey)keyEnum.nextElement();
            this.updateAlarm((AlarmValue)updateList.get(key));
        }
    }

    public void rebuildAlarmList(String _rebuild_reason) {
        current_AlarmList = new Hashtable();
        OOSSNotifyAlarmListRebuiltEvent nalre = new OOSSNotifyAlarmListRebuiltEvent();
        nalre.setApplicationDN(this.ApplicationDN);
        nalre.setReason(_rebuild_reason);
        nalre.setEventTime(new Date());
        nalre.setManagedObjectClass("NOT_SET_ManagedObjectClass");
        nalre.setManagedObjectInstance("NOT_SET_ManagedObjectInstance");
        nalre.setNotificationId("AlmMonitorId:" + this.id + ":EventCount:" + this.notification_count);
        this.sendJMSEvent((IRPEvent)nalre);
    }

    public void setAlarmList(Hashtable<AlarmKey, AlarmValue> _in) {
        current_AlarmList = _in;
        OOSSNotifyAlarmListRebuiltEvent nalre = new OOSSNotifyAlarmListRebuiltEvent();
        nalre.setApplicationDN(this.ApplicationDN);
        this.sendJMSEvent((IRPEvent)nalre);
    }

    public AlarmKeyResult[] tryAcknowledgeAlarms(AlarmKey[] alarmReferenceList, String ackUserId, String ackSystemId) throws IllegalArgumentException {
        return this.setAck(alarmReferenceList, ackUserId, ackSystemId, 1);
    }

    public AlarmKeyResult[] tryUnacknowledgeAlarms(AlarmKey[] alarmReferenceList, String ackUserId, String ackSystemId) throws IllegalArgumentException, UnsupportedOperationException {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"tryUnacknowledgeAlarms(AlarmKey[], String, String) - start");
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"tryUnacknowledgeAlarms(AlarmKey[], String, String) - end");
        }
        return this.setAck(alarmReferenceList, ackUserId, ackSystemId, 2);
    }

    private AlarmKeyResult[] setAck(AlarmKey[] alarmReferenceList, String ackUserId, String ackSystemId, int ackState) throws IllegalArgumentException {
        ArrayList<OOSSAlarmKeyResult> toReturn_ = new ArrayList<OOSSAlarmKeyResult>();
        for (int i = 0; i < alarmReferenceList.length; ++i) {
            AlarmValue av1 = current_AlarmList.get(alarmReferenceList[i]);
            if (av1 == null) {
                OOSSAlarmKeyResult akr = new OOSSAlarmKeyResult();
                akr.setSuccess(false);
                akr.setManagedEntityKey((ManagedEntityKey)alarmReferenceList[i]);
                akr.setException((Exception)((Object)new IllegalArgumentException()));
                toReturn_.add(akr);
                continue;
            }
            try {
                OOSSNotifyAckStateChangedEvent new_ack = new OOSSNotifyAckStateChangedEvent();
                new_ack.setAckSystemId(ackSystemId);
                new_ack.setAckUserId(ackUserId);
                new_ack.setAckTime(new Date());
                new_ack.setAlarmAckState(ackState);
                new_ack.setApplicationDN(this.ApplicationDN);
                this.sendJMSEvent((IRPEvent)new_ack);
                current_AlarmList.remove(alarmReferenceList[i]);
                continue;
            }
            catch (Exception re) {
                OOSSAlarmKeyResult akr = new OOSSAlarmKeyResult();
                akr.setSuccess(false);
                akr.setManagedEntityKey((ManagedEntityKey)alarmReferenceList[i]);
                akr.setException(re);
                toReturn_.add(akr);
            }
        }
        return toReturn_.toArray(new AlarmKeyResult[0]);
    }

    public String[] getVersion() {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"getVersion() - start");
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"getVersion() - end");
        }
        return null;
    }

    public AlarmValue makeAlarmValue() {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"makeAlarmValue() - start");
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"makeAlarmValue() - end");
        }
        return null;
    }

    public AlarmCountsValue queryAlarmCounts(QueryValue[] query) throws IllegalArgumentException, UnsupportedOperationException {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"queryAlarmCounts(QueryValue[]) - start");
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"queryAlarmCounts(QueryValue[]) - end");
        }
        return null;
    }

    public AlarmKeyResult[] tryCommentAlarms(AlarmKey[] alarmReferenceList, String commentUserId, String commentText, String commentSystemId) throws IllegalArgumentException, UnsupportedOperationException {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"tryCommentAlarms(AlarmKey[], String, String, String) - start");
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"tryCommentAlarms(AlarmKey[], String, String, String) - end");
        }
        return null;
    }

    public EventPropertyDescriptor getEventDescriptor(String eventType) throws IllegalArgumentException {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"getEventDescriptor(String) - start");
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"getEventDescriptor(String) - end");
        }
        return null;
    }

    public String[] getEventTypes() {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"getEventTypes() - start");
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"getEventTypes() - end");
        }
        return null;
    }

    public String[] getManagedEntityTypes() {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"getManagedEntityTypes() - start");
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"getManagedEntityTypes() - end");
        }
        return null;
    }

    public String[] getQueryTypes() {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"getQueryTypes() - start");
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"getQueryTypes() - end");
        }
        return null;
    }

    public String[] getSupportedOptionalOperations() {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"getSupportedOptionalOperations() - start");
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"getSupportedOptionalOperations() - end");
        }
        return null;
    }

    public ManagedEntityValue makeManagedEntityValue(String valueType) throws IllegalArgumentException {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"makeManagedEntityValue(String) - start");
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"makeManagedEntityValue(String) - end");
        }
        return null;
    }

    public QueryValue makeQueryValue(String type) throws IllegalArgumentException {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"makeQueryValue(String) - start");
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"makeQueryValue(String) - end");
        }
        return null;
    }

    public ManagedEntityValueIterator queryManagedEntities(QueryValue query, String[] attributeNames) throws IllegalArgumentException {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"queryManagedEntities(QueryValue, String[]) - start");
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"queryManagedEntities(QueryValue, String[]) - end");
        }
        return null;
    }

    public AlarmValue getAlarmbyAppDNPrimaryKey(String applicationDN, String primarykey) {
        AlarmValue av = null;
        Enumeration<AlarmKey> keyEnum = current_AlarmList.keys();
        try {
            while (keyEnum.hasMoreElements()) {
                AlarmKey akey = keyEnum.nextElement();
                if (!akey.getAlarmPrimaryKey().equals(primarykey) || !akey.getApplicationDN().equals(applicationDN)) continue;
                av = current_AlarmList.get(akey);
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("getAlarmbyAppDNPrimaryKey Found alarm - applicationDN: " + applicationDN + " primarykey: " + primarykey + "Raised time: " + av.getAlarmRaisedTime()));
                }
                return av;
            }
        }
        catch (Exception e) {
            logger.error((Object)("getAlarmbyAppDNPrimaryKey Exception " + e));
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("getAlarmbyAppDNPrimaryKey Alarm Not Found - applicationDN: " + applicationDN + " primarykey: " + primarykey));
        }
        return null;
    }
}

