/*
 * Decompiled with CFR 0.152.
 */
package net.jradius.freeradius;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import net.jradius.exception.RadiusException;
import net.jradius.freeradius.FreeRadiusFormat;
import net.jradius.freeradius.FreeRadiusRequest;
import net.jradius.handler.chain.JRCommand;
import net.jradius.log.RadiusLog;
import net.jradius.packet.RadiusFormat;
import net.jradius.packet.RadiusPacket;
import net.jradius.server.JRadiusRequest;
import net.jradius.server.JRadiusServer;
import net.jradius.server.ListenerRequest;
import net.jradius.server.RadiusProcessor;
import net.jradius.server.config.Configuration;

public class FreeRadiusProcessor
extends RadiusProcessor {
    private static final FreeRadiusFormat format = new FreeRadiusFormat();

    protected void processRequest(ListenerRequest listenerRequest) throws IOException, RadiusException {
        FreeRadiusRequest request = (FreeRadiusRequest)listenerRequest.getRequestEvent();
        try {
            request.setApplicationContext(this.getApplicationContext());
            request.setReturnValue(this.runPacketHandlers(request));
        }
        catch (Throwable th) {
            request.setReturnValue(1);
            th.printStackTrace();
        }
        this.writeResponse(request, listenerRequest.getOutputStream());
    }

    public void writeResponse(JRadiusRequest request, OutputStream outputStream) throws IOException, RadiusException {
        ByteArrayOutputStream outBytes = new ByteArrayOutputStream();
        DataOutputStream out = new DataOutputStream(outBytes);
        if (Configuration.isDebug()) {
            request.printDebugInfo(System.out);
        }
        RadiusPacket[] rp = request.getPackets();
        int packetCount = rp.length;
        RadiusFormat.writeUnsignedByte(out, request.getReturnValue());
        RadiusFormat.writeUnsignedByte(out, packetCount);
        for (int i = 0; i < rp.length; ++i) {
            out.write(format.packPacket(rp[i], null));
        }
        byte[] bConfigItems = format.packAttributeList(request.getConfigItems());
        RadiusFormat.writeUnsignedInt(out, bConfigItems.length);
        out.write(bConfigItems);
        out.close();
        outputStream.write(outBytes.toByteArray());
        outputStream.flush();
    }

    protected void logReturnCode(int result, JRCommand handler) {
        switch (result) {
            case 1: 
            case 4: 
            case 6: {
                RadiusLog.error("Error: Packet handler returned " + JRadiusServer.resultCodeToString(result) + ". Stopped handling this packet.");
                break;
            }
            case 0: 
            case 3: {
                RadiusLog.info("Packet handler returned " + JRadiusServer.resultCodeToString(result) + ". Stopped handling this packet.");
                break;
            }
            default: {
                RadiusLog.debug("Packet handler " + handler.getName() + " returned " + JRadiusServer.resultCodeToString(result) + ". Continue handling this packet.");
            }
        }
    }
}

