/*
 * Decompiled with CFR 0.152.
 */
package net.jradius.client.auth;

import java.nio.ByteBuffer;
import net.jradius.client.auth.RadiusAuthenticator;
import net.jradius.exception.RadiusException;
import net.jradius.log.RadiusLog;
import net.jradius.packet.RadiusPacket;
import net.jradius.packet.attribute.AttributeFactory;
import net.jradius.packet.attribute.RadiusAttribute;

public abstract class EAPAuthenticator
extends RadiusAuthenticator {
    protected boolean peap = false;
    private boolean startWithIdentity = true;
    private byte eapType;
    public static final int EAP_HEADERLEN = 4;
    public static final int EAP_REQUEST = 1;
    public static final int EAP_RESPONSE = 2;
    public static final int EAP_SUCCESS = 3;
    public static final int EAP_FAILURE = 4;
    public static final int EAP_IDENTITY = 1;
    public static final int EAP_NOTIFICATION = 2;
    public static final int EAP_NAK = 3;
    public static final int EAP_MD5 = 4;
    public static final int EAP_OTP = 5;
    public static final int EAP_GTC = 6;
    public static final int EAP_TLS = 13;
    public static final int EAP_LEAP = 17;
    public static final int EAP_SIM = 18;
    public static final int EAP_TTLS = 21;
    public static final int EAP_AKA = 23;
    public static final int EAP_PEAP = 25;
    public static final int EAP_MSCHAPV2 = 26;
    public static final int EAP_CISCO_MSCHAPV2 = 29;
    public static final int EAP_TLV = 33;

    public void processRequest(RadiusPacket p) throws RadiusException {
        p.removeAttribute(2L);
        RadiusAttribute a = AttributeFactory.newAttribute(79L, this.isStartWithIdentity() ? this.eapResponse(1, (byte)0, this.getUsername()) : null);
        p.overwriteAttribute(a);
    }

    public void processChallenge(RadiusPacket p, RadiusPacket r) throws RadiusException {
        RadiusAttribute a;
        p.setIdentifier(-1);
        Object[] aList = r.findAttributes(79L);
        if (aList == null) {
            throw new RadiusException("No EAP-Message in AccessChallenge");
        }
        int eapLength = 0;
        for (int i = 0; i < aList.length; ++i) {
            a = (RadiusAttribute)aList[i];
            byte[] b = a.getValue().getBytes();
            if (b == null) continue;
            eapLength += b.length;
        }
        byte[] eapReply = new byte[eapLength];
        int eapOffset = 0;
        for (int i = 0; i < aList.length; ++i) {
            a = (RadiusAttribute)aList[i];
            byte[] b = a.getValue().getBytes();
            System.arraycopy(b, 0, eapReply, eapOffset, b.length);
            eapOffset += b.length;
        }
        byte[] eapMessage = this.doEAP(eapReply);
        a = r.findAttribute(24L);
        if (a != null) {
            p.overwriteAttribute(a);
        }
        if ((a = p.findAttribute(79L)) != null) {
            p.removeAttribute(a);
        }
        AttributeFactory.addToAttributeList(p.getAttributes(), 79L, eapMessage);
        RadiusLog.debug("Sending Challenge:\n" + p.toString());
    }

    public byte getEAPType() {
        return this.eapType;
    }

    public void setEAPType(int eapType) {
        this.eapType = (byte)eapType;
    }

    public abstract byte[] doEAPType(byte var1, byte[] var2) throws RadiusException;

    public byte[] doEAPType(byte id, byte[] data, byte[] fullEAPPacket) throws RadiusException {
        return this.doEAPType(id, data);
    }

    public byte[] doEAP(byte[] eapReply) throws RadiusException {
        if (eapReply != null) {
            ByteBuffer bb = ByteBuffer.wrap(eapReply);
            byte rtype = 1;
            byte id = 0;
            int dlen = 0;
            byte codeOrType = bb.get();
            if (!this.peap || codeOrType == 1) {
                rtype = codeOrType;
                id = bb.get();
                dlen = bb.getShort() - 4 - 1;
                codeOrType = bb.get();
            } else {
                dlen = bb.remaining();
            }
            if (rtype != 1) {
                RadiusLog.error("Expecting an EAP-Request.. got code: " + rtype);
                return null;
            }
            byte eapcode = 0;
            byte[] data = null;
            if (dlen > 0) {
                eapcode = codeOrType;
                data = new byte[dlen];
                bb.get(data);
            }
            if (this.peap && eapcode == 33) {
                return this.tlvSuccess(id);
            }
            if (eapcode == 1) {
                return this.eapResponse(1, id, this.getUsername());
            }
            if (eapcode != this.eapType) {
                return this.negotiateEAPType(id, this.eapType);
            }
            return this.eapResponse(this.eapType, id, this.doEAPType(id, data, eapReply));
        }
        return null;
    }

    protected byte[] negotiateEAPType(byte id, byte eapType) {
        return this.eapResponse(3, id, new byte[]{eapType});
    }

    protected byte[] eapResponse(int type, byte id, byte[] data) {
        int offset;
        byte[] response;
        if (!this.peap || type == 33) {
            int length = 5 + data.length;
            response = new byte[length];
            response[0] = 2;
            response[1] = id;
            response[2] = (byte)(length >> 8 & 0xFF);
            response[3] = (byte)(length & 0xFF);
            offset = 4;
        } else {
            int length = 1 + data.length;
            response = new byte[length];
            offset = 0;
        }
        response[offset] = (byte)(type & 0xFF);
        if (data != null) {
            System.arraycopy(data, 0, response, offset + 1, data.length);
        }
        return response;
    }

    public byte[] tlvSuccess(byte id) {
        byte[] b = new byte[]{-128, 3, 0, 2, 0, 1};
        return this.eapResponse(33, id, b);
    }

    public boolean isStartWithIdentity() {
        return this.startWithIdentity;
    }

    public void setStartWithIdentity(boolean startWithIdentity) {
        this.startWithIdentity = startWithIdentity;
    }
}

