/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.provision.detector.datagram.client;

import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import org.opennms.core.utils.ThreadCategory;
import org.opennms.netmgt.provision.support.Client;
import org.opennms.netmgt.provision.support.ntp.NtpMessage;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Component
@Scope(value="prototype")
public class NtpClient
implements Client<NtpMessage, DatagramPacket> {
    private DatagramSocket m_socket;
    private int m_port;
    private InetAddress m_address;

    public void close() {
        this.m_socket.close();
    }

    public void connect(InetAddress address, int port, int timeout) throws IOException, Exception {
        if (this.log().isDebugEnabled()) {
            this.log().debug("Address: " + address + ", port: " + port + ", timeout: " + timeout);
        }
        this.m_socket = new DatagramSocket();
        this.m_socket.setSoTimeout(timeout);
        this.setAddress(address);
        this.setPort(port);
    }

    public DatagramPacket receiveBanner() throws IOException, Exception {
        throw new UnsupportedOperationException("Client<NtpMessage,DatagramPacket>.receiveBanner is not yet implemented");
    }

    public DatagramPacket sendRequest(NtpMessage request) throws IOException, Exception {
        byte[] buf = new NtpMessage().toByteArray();
        DatagramPacket outpkt = new DatagramPacket(buf, buf.length, this.getAddress(), this.getPort());
        this.m_socket.send(outpkt);
        byte[] data = new byte[512];
        DatagramPacket response = new DatagramPacket(data, data.length);
        this.m_socket.receive(response);
        return response;
    }

    protected void setAddress(InetAddress address) {
        this.m_address = address;
    }

    protected InetAddress getAddress() {
        return this.m_address;
    }

    protected void setPort(int port) {
        this.m_port = port;
    }

    protected int getPort() {
        return this.m_port;
    }

    private ThreadCategory log() {
        return ThreadCategory.getInstance(NtpClient.class);
    }
}

