/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.provision.detector.datagram.client;

import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import org.opennms.core.utils.ThreadCategory;
import org.opennms.netmgt.provision.support.Client;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DatagramClient
implements Client<DatagramPacket, DatagramPacket> {
    private DatagramSocket m_socket;

    public void close() {
        this.m_socket.close();
    }

    public void connect(InetAddress address, int port, int timeout) throws IOException {
        if (this.log().isDebugEnabled()) {
            this.log().debug("Addres: " + address + " port: " + port + " timeout: " + timeout);
        }
        this.m_socket = new DatagramSocket();
        this.m_socket.setSoTimeout(timeout);
        this.m_socket.connect(address, port);
    }

    public DatagramPacket receiveBanner() throws IOException {
        throw new UnsupportedOperationException("Client<DatagramPacket,DatagramPacket>.receiveBanner is not yet implemented");
    }

    public DatagramPacket sendRequest(DatagramPacket request) throws IOException {
        this.m_socket.send(request);
        byte[] data = new byte[512];
        DatagramPacket response = new DatagramPacket(data, data.length);
        this.m_socket.receive(response);
        return response;
    }

    private ThreadCategory log() {
        return ThreadCategory.getInstance(this.getClass());
    }
}

