/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.provision.detector.datagram;

import java.net.DatagramPacket;
import java.net.InetAddress;
import java.net.UnknownHostException;
import org.opennms.netmgt.provision.detector.datagram.client.NtpClient;
import org.opennms.netmgt.provision.support.BasicDetector;
import org.opennms.netmgt.provision.support.Client;
import org.opennms.netmgt.provision.support.ClientConversation;
import org.opennms.netmgt.provision.support.ntp.NtpMessage;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Component
@Scope(value="prototype")
public class NtpDetector
extends BasicDetector<NtpMessage, DatagramPacket> {
    private String m_ipToValidate;

    public NtpDetector() {
        super("NTP", 123);
    }

    protected Client<NtpMessage, DatagramPacket> getClient() {
        return new NtpClient();
    }

    protected void onInit() {
        this.send(this.createNtpMessage(), this.validateResponse(this.getAddress()));
    }

    private ClientConversation.ResponseValidator<DatagramPacket> validateResponse(final InetAddress nserver) {
        return new ClientConversation.ResponseValidator<DatagramPacket>(){

            public boolean validate(DatagramPacket response) throws Exception {
                if (response.getAddress().equals(nserver)) {
                    new NtpMessage(response.getData());
                    return true;
                }
                return false;
            }
        };
    }

    private ClientConversation.RequestBuilder<NtpMessage> createNtpMessage() {
        return new ClientConversation.RequestBuilder<NtpMessage>(){

            public NtpMessage getRequest() throws Exception {
                return new NtpMessage();
            }
        };
    }

    private InetAddress getAddress() {
        try {
            return InetAddress.getByName(this.getIpToValidate());
        }
        catch (UnknownHostException e) {
            e.printStackTrace();
            return null;
        }
    }

    public void setIpToValidate(String ipToValidate) {
        this.m_ipToValidate = ipToValidate;
    }

    public String getIpToValidate() {
        return this.m_ipToValidate;
    }
}

