/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.provision.detector.datagram;

import java.io.IOException;
import java.net.DatagramPacket;
import org.opennms.core.utils.ThreadCategory;
import org.opennms.netmgt.provision.detector.datagram.client.DatagramClient;
import org.opennms.netmgt.provision.support.BasicDetector;
import org.opennms.netmgt.provision.support.Client;
import org.opennms.netmgt.provision.support.ClientConversation;
import org.opennms.netmgt.provision.support.dns.DNSAddressRequest;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Component
@Scope(value="prototype")
public class DnsDetector
extends BasicDetector<DatagramPacket, DatagramPacket> {
    private static final String DEFAULT_SERVICE_NAME = "DNS";
    private static final int DEFAULT_PORT = 53;
    private static final String DEFAULT_LOOKUP = "localhost";
    private String m_lookup = "localhost";

    public DnsDetector() {
        super(DEFAULT_SERVICE_NAME, 53);
    }

    public DnsDetector(String serviceName, int port) {
        super(serviceName, port);
    }

    public void onInit() {
        DNSAddressRequest req = this.addrRequest(this.getLookup());
        this.send(this.encode(req), this.verifyResponse(req));
    }

    private ClientConversation.ResponseValidator<DatagramPacket> verifyResponse(final DNSAddressRequest request) {
        return new ClientConversation.ResponseValidator<DatagramPacket>(){

            public boolean validate(DatagramPacket response) {
                try {
                    request.verifyResponse(response.getData(), response.getLength());
                }
                catch (IOException e) {
                    DnsDetector.this.info("DNSDetector failed to connect", new Object[0]);
                    return false;
                }
                return true;
            }
        };
    }

    private DNSAddressRequest addrRequest(String host) {
        return new DNSAddressRequest(host);
    }

    private DatagramPacket encode(DNSAddressRequest dnsPacket) {
        byte[] data = this.buildRequest(dnsPacket);
        return new DatagramPacket(data, data.length);
    }

    private byte[] buildRequest(DNSAddressRequest request) {
        try {
            return request.buildRequest();
        }
        catch (IOException e) {
            throw new IllegalStateException("Unable to build dnsRequest!!! This can't happen!!");
        }
    }

    protected Client<DatagramPacket, DatagramPacket> getClient() {
        return new DatagramClient();
    }

    public void setLookup(String lookup) {
        this.m_lookup = lookup;
    }

    public String getLookup() {
        return this.m_lookup;
    }

    private void info(String format, Object ... args) {
        ThreadCategory log = ThreadCategory.getInstance(((Object)((Object)this)).getClass());
        if (log.isInfoEnabled()) {
            log.info(String.format(format, args));
        }
    }
}

