/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.core.tasks;

import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import org.opennms.core.tasks.ContainerTask;
import org.opennms.core.tasks.DefaultTaskCoordinator;
import org.opennms.core.tasks.DefaultTaskMonitor;
import org.opennms.core.tasks.TaskMonitor;
import org.opennms.core.utils.ThreadCategory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Task {
    private final DefaultTaskCoordinator m_coordinator;
    private final AtomicReference<State> m_state = new AtomicReference<State>(State.NEW);
    private final AtomicBoolean m_scheduleCalled = new AtomicBoolean(false);
    private final CountDownLatch m_latch = new CountDownLatch(1);
    private final AtomicInteger m_pendingPrereqs = new AtomicInteger(0);
    private final Set<Task> m_dependents = new HashSet<Task>();
    private final Set<Task> m_prerequisites = new HashSet<Task>();
    private final TaskMonitor m_monitor;

    public Task(DefaultTaskCoordinator coordinator, ContainerTask<?> parent) {
        this.m_coordinator = coordinator;
        this.m_monitor = parent != null ? parent.getMonitor().getChildTaskMonitor(parent, this) : new DefaultTaskMonitor(this);
    }

    public DefaultTaskCoordinator getCoordinator() {
        return this.m_coordinator;
    }

    public TaskMonitor getMonitor() {
        return this.m_monitor;
    }

    final Set<Task> getDependents() {
        return this.m_dependents;
    }

    final void doAddDependent(Task dependent) {
        if (!this.isFinished()) {
            this.m_dependents.add(dependent);
        }
    }

    final Set<Task> getPrerequisites() {
        return this.m_prerequisites;
    }

    final void doAddPrerequisite(Task prereq) {
        if (!prereq.isFinished()) {
            this.m_prerequisites.add(prereq);
            this.notifyPrerequisteAdded(prereq);
        }
    }

    private void notifyPrerequisteAdded(Task prereq) {
        try {
            this.m_monitor.prerequisiteAdded(this, prereq);
        }
        catch (Throwable t) {
            this.m_monitor.monitorException(t);
        }
    }

    private void notifyPrerequisteCompleted(Task prereq) {
        try {
            this.m_monitor.prerequisiteCompleted(this, prereq);
        }
        catch (Throwable t) {
            this.m_monitor.monitorException(t);
        }
    }

    private void notifyScheduled() {
        try {
            this.m_monitor.scheduled(this);
        }
        catch (Throwable t) {
            this.m_monitor.monitorException(t);
        }
    }

    private void notifySubmitted() {
        try {
            this.m_monitor.submitted(this);
        }
        catch (Throwable t) {
            this.m_monitor.monitorException(t);
        }
    }

    private void notifyCompleted() {
        try {
            this.m_monitor.completed(this);
        }
        catch (Throwable t) {
            this.m_monitor.monitorException(t);
        }
    }

    final void doCompletePrerequisite(Task prereq) {
        this.m_prerequisites.remove(prereq);
        this.notifyPrerequisteCompleted(prereq);
    }

    final void clearDependents() {
        this.m_dependents.clear();
    }

    final void scheduled() {
        this.setState(State.NEW, State.SCHEDULED);
        this.notifyScheduled();
    }

    private final void setState(State oldState, State newState) {
        if (!this.m_state.compareAndSet(oldState, newState)) {
            String msg = String.format("Attempted to move to state %s with state not %s (actual value %s) for task %s", new Object[]{newState, oldState, this.m_state.get(), this});
            new IllegalStateException(msg).printStackTrace();
        }
    }

    void submitIfReady() {
        if (this.isReady()) {
            this.doSubmit();
            this.submitted();
            this.completeSubmit();
        }
    }

    protected void doSubmit() {
    }

    final void submitted() {
        this.setState(State.SCHEDULED, State.SUBMITTED);
        this.notifySubmitted();
    }

    protected void completeSubmit() {
    }

    final void completed() {
        this.m_state.compareAndSet(State.SUBMITTED, State.COMPLETED);
        this.notifyCompleted();
    }

    final boolean isReady() {
        return this.isInReadyState() && this.m_prerequisites.isEmpty() && this.getPendingPrereqCount() == 0;
    }

    private int getPendingPrereqCount() {
        return this.m_pendingPrereqs.get();
    }

    private boolean isInReadyState() {
        return this.m_state.get() == State.SCHEDULED;
    }

    final void incrPendingPrereqCount() {
        this.m_pendingPrereqs.incrementAndGet();
    }

    final void decrPendingPrereqCount() {
        this.m_pendingPrereqs.decrementAndGet();
    }

    void onComplete() {
        this.completed();
        this.m_latch.countDown();
    }

    public void schedule() {
        this.m_scheduleCalled.set(true);
        this.preSchedule();
        this.getCoordinator().schedule(this);
        this.postSchedule();
    }

    protected void preSchedule() {
    }

    protected void postSchedule() {
    }

    public boolean isFinished() {
        return this.m_state.get() == State.COMPLETED;
    }

    public boolean isScheduled() {
        return this.m_state.get() != State.NEW || this.m_scheduleCalled.get();
    }

    public void addPrerequisite(Task prereq) {
        this.getCoordinator().addDependency(prereq, this);
    }

    public void addDependent(Task dependent) {
        this.getCoordinator().addDependency(this, dependent);
    }

    public void waitFor() throws InterruptedException, ExecutionException {
        this.m_latch.await();
    }

    public void waitFor(long timeout, TimeUnit unit) throws InterruptedException {
        this.m_latch.await(timeout, unit);
    }

    protected void markTaskAsCompleted() {
        this.getCoordinator().markTaskAsCompleted(this);
    }

    protected void submitRunnable(Runnable runnable, String preferredExecutor) {
        this.getCoordinator().submitToExecutor(preferredExecutor, runnable, this);
    }

    public String toString() {
        return String.format("Task[%s]", super.toString());
    }

    protected void info(String format, Object ... args) {
        this.log().info(String.format(format, args));
    }

    protected void debug(String format, Object ... args) {
        if (this.log().isDebugEnabled()) {
            this.log().debug(String.format(format, args));
        }
    }

    protected ThreadCategory log() {
        return ThreadCategory.getInstance(this.getClass());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum State {
        NEW,
        SCHEDULED,
        SUBMITTED,
        COMPLETED;

    }
}

