/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.core.tasks;

import org.opennms.core.tasks.ContainerTask;
import org.opennms.core.tasks.DefaultTaskCoordinator;
import org.opennms.core.tasks.Task;
import org.opennms.core.utils.LogUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SyncTask
extends Task {
    public static final String DEFAULT_EXECUTOR = "default";
    public static final String ADMIN_EXECUTOR = "admin";
    private final Runnable m_action;
    private String m_preferredExecutor = "default";

    public SyncTask(DefaultTaskCoordinator coordinator, ContainerTask<?> parent, Runnable action) {
        this(coordinator, parent, action, DEFAULT_EXECUTOR);
    }

    public SyncTask(DefaultTaskCoordinator coordinator, ContainerTask<?> parent, Runnable action, String preferredExecutor) {
        super(coordinator, parent);
        this.m_action = action;
        this.m_preferredExecutor = preferredExecutor;
    }

    @Override
    protected void doSubmit() {
        this.submitRunnable(this.getRunnable(), this.getPreferredExecutor());
    }

    public void run() {
        if (this.m_action != null) {
            this.m_action.run();
        }
    }

    final Runnable getRunnable() {
        return new Runnable(){

            public void run() {
                try {
                    SyncTask.this.run();
                }
                catch (Throwable t) {
                    LogUtils.debugf((Object)this, (Throwable)t, (String)"Exception occurred executing task %s", (Object[])new Object[]{SyncTask.this});
                }
            }

            public String toString() {
                return "Runner for " + SyncTask.this;
            }
        };
    }

    public String getPreferredExecutor() {
        return this.m_preferredExecutor;
    }

    public void setPreferredExecutor(String preferredExecutor) {
        this.m_preferredExecutor = preferredExecutor;
    }

    @Override
    public String toString() {
        return this.m_action == null ? super.toString() : this.m_action.toString();
    }
}

