/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.core.tasks;

import java.util.Map;
import java.util.Set;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.CompletionService;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorCompletionService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import org.opennms.core.tasks.Async;
import org.opennms.core.tasks.AsyncTask;
import org.opennms.core.tasks.BatchTask;
import org.opennms.core.tasks.Callback;
import org.opennms.core.tasks.ContainerTask;
import org.opennms.core.tasks.SequenceTask;
import org.opennms.core.tasks.SyncTask;
import org.opennms.core.tasks.Task;
import org.opennms.core.tasks.TaskBuilder;
import org.opennms.core.utils.ThreadCategory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.util.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultTaskCoordinator
implements InitializingBean {
    private final BlockingQueue<Future<Runnable>> m_queue;
    private final ConcurrentHashMap<String, CompletionService<Runnable>> m_taskCompletionServices = new ConcurrentHashMap();
    private final RunnableActor m_actor;
    private String m_defaultExecutor;
    private CompletionService<Runnable> m_defaultCompletionService;
    private Long m_loopDelay;

    public DefaultTaskCoordinator(String name) {
        this.m_queue = new LinkedBlockingQueue<Future<Runnable>>();
        this.m_actor = new RunnableActor(name + "-TaskScheduler", this.m_queue);
        this.addExecutor("admin", Executors.newSingleThreadExecutor());
    }

    public DefaultTaskCoordinator(String name, Executor defaultExecutor) {
        this(name);
        this.m_defaultExecutor = "default";
        this.addExecutor("default", defaultExecutor);
        this.afterPropertiesSet();
    }

    public void setDefaultExecutor(String executorName) {
        this.m_defaultExecutor = executorName;
    }

    public void afterPropertiesSet() {
        Assert.notNull((Object)this.m_defaultExecutor, (String)"defaultExecutor must be set");
        this.m_defaultCompletionService = this.getCompletionService(this.m_defaultExecutor);
        Assert.notNull(this.m_defaultCompletionService, (String)"defaultExecutor must be set to the name of an added executor");
    }

    public SyncTask createTask(ContainerTask<?> parent, Runnable r) {
        return new SyncTask(this, parent, r);
    }

    public SyncTask createTask(ContainerTask<?> parent, Runnable r, String schedulingHint) {
        return new SyncTask(this, parent, r, schedulingHint);
    }

    public <T> AsyncTask<T> createTask(ContainerTask<?> parent, Async<T> async, Callback<T> cb) {
        return new AsyncTask<T>(this, parent, async, cb);
    }

    public TaskBuilder<BatchTask> createBatch(ContainerTask<?> parent) {
        return new TaskBuilder<BatchTask>(new BatchTask(this, parent));
    }

    public TaskBuilder<BatchTask> createBatch() {
        return this.createBatch((ContainerTask)null);
    }

    public BatchTask createBatch(ContainerTask<?> parent, Runnable ... tasks) {
        return this.createBatch(parent).add(tasks).get(parent);
    }

    public BatchTask createBatch(Runnable ... tasks) {
        return this.createBatch().add(tasks).get();
    }

    public TaskBuilder<SequenceTask> createSequence(ContainerTask<?> parent) {
        return new TaskBuilder<SequenceTask>(new SequenceTask(this, parent));
    }

    public TaskBuilder<SequenceTask> createSequence() {
        return this.createSequence(null);
    }

    public SequenceTask createSequence(ContainerTask<?> parent, Runnable ... tasks) {
        return this.createSequence(parent).add(tasks).get(parent);
    }

    public SequenceTask createSquence(Runnable ... tasks) {
        return this.createSequence().add(tasks).get();
    }

    public void setLoopDelay(long millis) {
        this.m_loopDelay = millis;
    }

    public void schedule(Task task) {
        this.onProcessorThread(this.scheduler(task));
    }

    public void addDependency(Task prereq, Task dependent) {
        dependent.incrPendingPrereqCount();
        this.onProcessorThread(this.dependencyAdder(prereq, dependent));
    }

    private void onProcessorThread(final Runnable r) {
        Future<Runnable> now = new Future<Runnable>(){

            @Override
            public boolean cancel(boolean mayInterruptIfRunning) {
                return false;
            }

            @Override
            public Runnable get() {
                return r;
            }

            @Override
            public Runnable get(long timeout, TimeUnit unit) {
                return this.get();
            }

            @Override
            public boolean isCancelled() {
                return false;
            }

            @Override
            public boolean isDone() {
                return true;
            }

            public String toString() {
                return "Future<" + r + ">";
            }
        };
        this.m_queue.add(now);
    }

    private Runnable scheduler(final Task task) {
        return new Runnable(){

            public void run() {
                task.scheduled();
                task.submitIfReady();
            }

            public String toString() {
                return String.format("schedule(%s)", task);
            }
        };
    }

    Runnable taskCompleter(final Task task) {
        return new Runnable(){

            public void run() {
                DefaultTaskCoordinator.this.notifyDependents(task);
            }

            public String toString() {
                return String.format("notifyDependents(%s)", task);
            }
        };
    }

    private void notifyDependents(Task completed) {
        completed.onComplete();
        Set<Task> dependents = completed.getDependents();
        for (Task dependent : dependents) {
            dependent.doCompletePrerequisite(completed);
            if (dependent.isReady()) {
                // empty if block
            }
            dependent.submitIfReady();
        }
        completed.clearDependents();
    }

    private Runnable dependencyAdder(final Task prereq, final Task dependent) {
        Assert.notNull((Object)prereq, (String)"prereq must not be null");
        Assert.notNull((Object)dependent, (String)"dependent must not be null");
        return new Runnable(){

            public void run() {
                prereq.doAddDependent(dependent);
                dependent.doAddPrerequisite(prereq);
                dependent.decrPendingPrereqCount();
                dependent.submitIfReady();
            }

            public String toString() {
                return String.format("%s.addPrerequisite(%s)", dependent, prereq);
            }
        };
    }

    private CompletionService<Runnable> getCompletionService(String name) {
        CompletionService<Runnable> completionService = this.m_taskCompletionServices.get(name);
        CompletionService<Runnable> selected = completionService != null ? completionService : this.m_defaultCompletionService;
        return selected;
    }

    void markTaskAsCompleted(Task task) {
        this.onProcessorThread(this.taskCompleter(task));
    }

    void submitToExecutor(String executorPreference, Runnable workToBeDone, Task owningTask) {
        this.submitToExecutor(executorPreference, workToBeDone, this.taskCompleter(owningTask));
    }

    void submitToExecutor(String executorPreference, Runnable workToBeDone, Runnable completionProcessor) {
        this.getCompletionService(executorPreference).submit(workToBeDone, completionProcessor);
    }

    public void addExecutor(String executorName, Executor executor) {
        this.m_taskCompletionServices.put(executorName, new ExecutorCompletionService(executor, this.m_queue));
    }

    public void setExecutors(Map<String, Executor> executors) {
        this.m_taskCompletionServices.clear();
        for (Map.Entry<String, Executor> e : executors.entrySet()) {
            this.addExecutor(e.getKey(), e.getValue());
        }
    }

    private ThreadCategory log() {
        return ThreadCategory.getInstance(this.getClass());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class RunnableActor
    extends Thread {
        private final BlockingQueue<Future<Runnable>> m_queue;

        public RunnableActor(String name, BlockingQueue<Future<Runnable>> queue) {
            super(name);
            this.m_queue = queue;
            this.start();
        }

        @Override
        public void run() {
            while (true) {
                try {
                    while (true) {
                        Runnable r;
                        if ((r = this.m_queue.take().get()) != null) {
                            r.run();
                        }
                        if (DefaultTaskCoordinator.this.m_loopDelay == null) continue;
                        RunnableActor.sleep(DefaultTaskCoordinator.this.m_loopDelay);
                    }
                }
                catch (InterruptedException e) {
                    DefaultTaskCoordinator.this.log().warn("runnable actor interrupted", (Throwable)e);
                    continue;
                }
                catch (ExecutionException e) {
                    DefaultTaskCoordinator.this.log().warn("runnable actor execution failed", (Throwable)e);
                    continue;
                }
                catch (Throwable e) {
                    DefaultTaskCoordinator.this.log().error("an unknown error occurred in the runnable actor", e);
                    continue;
                }
                break;
            }
        }
    }
}

