/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.core.tasks;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.opennms.core.tasks.Async;
import org.opennms.core.tasks.AsyncTask;
import org.opennms.core.tasks.Callback;
import org.opennms.core.tasks.DefaultTaskCoordinator;
import org.opennms.core.tasks.NeedsContainer;
import org.opennms.core.tasks.RunInBatch;
import org.opennms.core.tasks.SequenceTask;
import org.opennms.core.tasks.SyncTask;
import org.opennms.core.tasks.Task;
import org.opennms.core.tasks.TaskBuilder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ContainerTask<T extends ContainerTask<?>>
extends Task {
    protected final Task m_triggerTask;
    private final List<Task> m_children = Collections.synchronizedList(new ArrayList());
    private final TaskBuilder<T> m_builder;
    AtomicInteger m_child = new AtomicInteger(0);

    public ContainerTask(DefaultTaskCoordinator coordinator, ContainerTask<?> parent) {
        super(coordinator, parent);
        this.m_builder = this.createBuilder();
        this.m_triggerTask = new TaskTrigger(coordinator, this);
    }

    private TaskBuilder<T> createBuilder() {
        return new TaskBuilder<ContainerTask>(this);
    }

    public TaskBuilder<T> getBuilder() {
        return this.m_builder;
    }

    @Override
    public void addPrerequisite(Task task) {
        super.addPrerequisite(task);
        this.m_triggerTask.addPrerequisite(task);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void preSchedule() {
        ArrayList<Task> children;
        this.m_triggerTask.schedule();
        List<Task> list = this.m_children;
        synchronized (list) {
            children = new ArrayList<Task>(this.m_children);
            this.m_children.clear();
        }
        for (Task task : children) {
            task.schedule();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(Task task) {
        boolean scheduleChild;
        super.addPrerequisite(task);
        this.addChildDependencies(task);
        List<Task> list = this.m_children;
        synchronized (list) {
            scheduleChild = this.isScheduled();
            if (!scheduleChild) {
                this.m_children.add(task);
            }
        }
        if (scheduleChild) {
            task.schedule();
        }
    }

    public void add(RunInBatch runInBatch) {
        this.getBuilder().add(runInBatch);
    }

    public void add(NeedsContainer needsContainer) {
        this.getBuilder().add(needsContainer);
    }

    protected Task getTriggerTask() {
        return this.m_triggerTask;
    }

    @Override
    protected void completeSubmit() {
        this.getCoordinator().markTaskAsCompleted(this);
    }

    public SyncTask add(Runnable runnable) {
        SyncTask task = this.createTask(runnable);
        this.add(task);
        return task;
    }

    public SyncTask add(Runnable runnable, String schedulingHint) {
        SyncTask task = this.createTask(runnable, schedulingHint);
        this.add(task);
        return task;
    }

    public <S> AsyncTask<S> add(Async<S> async, Callback<S> cb) {
        AsyncTask<S> task = this.createTask(async, cb);
        this.add(task);
        return task;
    }

    @Deprecated
    public SequenceTask addSequence(Runnable ... tasks) {
        return this.getCoordinator().createSequence(this, tasks);
    }

    private SyncTask createTask(Runnable runnable) {
        return this.getCoordinator().createTask(this, runnable);
    }

    private SyncTask createTask(Runnable runnable, String schedulingHint) {
        return this.getCoordinator().createTask(this, runnable, schedulingHint);
    }

    private <S> AsyncTask<S> createTask(Async<S> async, Callback<S> cb) {
        return this.getCoordinator().createTask(this, async, cb);
    }

    protected void addChildDependencies(Task child) {
        child.addPrerequisite(this.m_triggerTask);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class TaskTrigger
    extends Task {
        public TaskTrigger(DefaultTaskCoordinator coordinator, ContainerTask<?> parent) {
            super(coordinator, parent);
        }

        @Override
        protected void completeSubmit() {
            this.getCoordinator().markTaskAsCompleted(this);
        }

        @Override
        public String toString() {
            return "Trigger For " + ContainerTask.this;
        }
    }
}

