/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.core.tasks;

import org.opennms.core.tasks.Async;
import org.opennms.core.tasks.Callback;
import org.opennms.core.tasks.ContainerTask;
import org.opennms.core.tasks.DefaultTaskCoordinator;
import org.opennms.core.tasks.Task;
import org.springframework.util.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AsyncTask<T>
extends Task {
    private final Async<T> m_async;
    private final Callback<T> m_callback;

    public AsyncTask(DefaultTaskCoordinator coordinator, ContainerTask<?> parent, Async<T> async) {
        this(coordinator, parent, async, null);
    }

    public AsyncTask(DefaultTaskCoordinator coordinator, ContainerTask<?> parent, Async<T> async, Callback<T> callback) {
        super(coordinator, parent);
        Assert.notNull(async, (String)"async parameter must not be null");
        this.m_async = async;
        this.m_callback = callback;
    }

    @Override
    public String toString() {
        return String.valueOf(this.m_async);
    }

    @Override
    protected void doSubmit() {
        Callback<T> callback = this.callback();
        try {
            this.m_async.submit(callback);
        }
        catch (Throwable t) {
            callback.handleException(t);
        }
    }

    private Callback<T> callback() {
        return new Callback<T>(){

            @Override
            public void complete(T t) {
                if (AsyncTask.this.m_callback != null) {
                    AsyncTask.this.m_callback.complete(t);
                }
                AsyncTask.this.markTaskAsCompleted();
            }

            @Override
            public void handleException(Throwable t) {
                if (AsyncTask.this.m_callback != null) {
                    AsyncTask.this.m_callback.handleException(t);
                }
                AsyncTask.this.markTaskAsCompleted();
            }
        };
    }
}

