/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs.condition;

import java.io.File;
import java.io.IOException;
import java.util.Enumeration;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.taskdefs.condition.Condition;
import org.apache.tools.ant.types.DataType;
import org.apache.tools.zip.ZipEntry;
import org.apache.tools.zip.ZipFile;

public class IsSigned
extends DataType
implements Condition {
    private static final String SIG_START = "META-INF/";
    private static final String SIG_END = ".SF";
    private static final int SHORT_SIG_LIMIT = 8;
    private String name;
    private File file;

    public void setFile(File file) {
        this.file = file;
    }

    public void setName(String name) {
        this.name = name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean isSigned(File zipFile, String name) throws IOException {
        boolean bl;
        ZipFile jarFile;
        block7: {
            boolean eName2;
            block6: {
                boolean bl2;
                block5: {
                    jarFile = null;
                    try {
                        jarFile = new ZipFile(zipFile);
                        if (null == name) {
                            Enumeration entries = jarFile.getEntries();
                            while (entries.hasMoreElements()) {
                                String eName2 = ((ZipEntry)entries.nextElement()).getName();
                                if (!eName2.startsWith(SIG_START) || !eName2.endsWith(SIG_END)) continue;
                                bl2 = true;
                                Object var7_10 = null;
                                break block5;
                            }
                            eName2 = false;
                            break block6;
                        }
                        boolean shortSig = jarFile.getEntry(SIG_START + name.toUpperCase() + SIG_END) != null;
                        boolean longSig = false;
                        if (name.length() > 8) {
                            longSig = jarFile.getEntry(SIG_START + name.substring(0, 8).toUpperCase() + SIG_END) != null;
                        }
                        bl = shortSig || longSig;
                        break block7;
                    }
                    catch (Throwable throwable) {
                        Object var7_13 = null;
                        ZipFile.closeQuietly(jarFile);
                        throw throwable;
                    }
                }
                ZipFile.closeQuietly(jarFile);
                return bl2;
            }
            Object var7_11 = null;
            ZipFile.closeQuietly(jarFile);
            return eName2;
        }
        Object var7_12 = null;
        ZipFile.closeQuietly(jarFile);
        return bl;
    }

    public boolean eval() {
        if (this.file == null) {
            throw new BuildException("The file attribute must be set.");
        }
        if (!this.file.exists()) {
            this.log("The file \"" + this.file.getAbsolutePath() + "\" does not exist.", 3);
            return false;
        }
        boolean r = false;
        try {
            r = IsSigned.isSigned(this.file, this.name);
        }
        catch (IOException e) {
            this.log("Got IOException reading file \"" + this.file.getAbsolutePath() + "\"" + e, 1);
        }
        if (r) {
            this.log("File \"" + this.file.getAbsolutePath() + "\" is signed.", 3);
        }
        return r;
    }
}

