/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.config.views;

import java.io.IOException;
import java.io.Reader;
import java.io.Serializable;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import org.exolab.castor.xml.MarshalException;
import org.exolab.castor.xml.Marshaller;
import org.exolab.castor.xml.Unmarshaller;
import org.exolab.castor.xml.ValidationException;
import org.exolab.castor.xml.Validator;
import org.xml.sax.ContentHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Category
implements Serializable {
    private String _label;
    private String _categoryComment;
    private double _normal;
    private boolean _has_normal;
    private double _warning;
    private boolean _has_warning;
    private List<String> _serviceList = new ArrayList<String>();
    private String _rule;

    public void addService(String vService) throws IndexOutOfBoundsException {
        this._serviceList.add(vService);
    }

    public void addService(int index, String vService) throws IndexOutOfBoundsException {
        this._serviceList.add(index, vService);
    }

    public void deleteNormal() {
        this._has_normal = false;
    }

    public void deleteWarning() {
        this._has_warning = false;
    }

    public Enumeration<String> enumerateService() {
        return Collections.enumeration(this._serviceList);
    }

    public String getCategoryComment() {
        return this._categoryComment;
    }

    public String getLabel() {
        return this._label;
    }

    public double getNormal() {
        return this._normal;
    }

    public String getRule() {
        return this._rule;
    }

    public String getService(int index) throws IndexOutOfBoundsException {
        if (index < 0 || index >= this._serviceList.size()) {
            throw new IndexOutOfBoundsException("getService: Index value '" + index + "' not in range [0.." + (this._serviceList.size() - 1) + "]");
        }
        return this._serviceList.get(index);
    }

    public String[] getService() {
        String[] array = new String[]{};
        return this._serviceList.toArray(array);
    }

    public List<String> getServiceCollection() {
        return this._serviceList;
    }

    public int getServiceCount() {
        return this._serviceList.size();
    }

    public double getWarning() {
        return this._warning;
    }

    public boolean hasNormal() {
        return this._has_normal;
    }

    public boolean hasWarning() {
        return this._has_warning;
    }

    public boolean isValid() {
        try {
            this.validate();
        }
        catch (ValidationException vex) {
            return false;
        }
        return true;
    }

    public Iterator<String> iterateService() {
        return this._serviceList.iterator();
    }

    public void marshal(Writer out) throws MarshalException, ValidationException {
        Marshaller.marshal((Object)this, (Writer)out);
    }

    public void marshal(ContentHandler handler) throws IOException, MarshalException, ValidationException {
        Marshaller.marshal((Object)this, (ContentHandler)handler);
    }

    public void removeAllService() {
        this._serviceList.clear();
    }

    public boolean removeService(String vService) {
        boolean removed = this._serviceList.remove(vService);
        return removed;
    }

    public String removeServiceAt(int index) {
        String obj = this._serviceList.remove(index);
        return obj;
    }

    public void setCategoryComment(String categoryComment) {
        this._categoryComment = categoryComment;
    }

    public void setLabel(String label) {
        this._label = label;
    }

    public void setNormal(double normal) {
        this._normal = normal;
        this._has_normal = true;
    }

    public void setRule(String rule) {
        this._rule = rule;
    }

    public void setService(int index, String vService) throws IndexOutOfBoundsException {
        if (index < 0 || index >= this._serviceList.size()) {
            throw new IndexOutOfBoundsException("setService: Index value '" + index + "' not in range [0.." + (this._serviceList.size() - 1) + "]");
        }
        this._serviceList.set(index, vService);
    }

    public void setService(String[] vServiceArray) {
        this._serviceList.clear();
        for (int i = 0; i < vServiceArray.length; ++i) {
            this._serviceList.add(vServiceArray[i]);
        }
    }

    public void setService(List<String> vServiceList) {
        this._serviceList.clear();
        this._serviceList.addAll(vServiceList);
    }

    public void setServiceCollection(List<String> serviceList) {
        this._serviceList = serviceList;
    }

    public void setWarning(double warning) {
        this._warning = warning;
        this._has_warning = true;
    }

    public static Category unmarshal(Reader reader) throws MarshalException, ValidationException {
        return (Category)Unmarshaller.unmarshal(Category.class, (Reader)reader);
    }

    public void validate() throws ValidationException {
        Validator validator = new Validator();
        validator.validate((Object)this);
    }
}

