/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.config.statsd;

import java.io.IOException;
import java.io.Reader;
import java.io.Serializable;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import org.exolab.castor.xml.MarshalException;
import org.exolab.castor.xml.Marshaller;
import org.exolab.castor.xml.Unmarshaller;
import org.exolab.castor.xml.ValidationException;
import org.exolab.castor.xml.Validator;
import org.opennms.netmgt.config.statsd.Parameter;
import org.opennms.netmgt.config.statsd.types.PackageReportStatusType;
import org.xml.sax.ContentHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PackageReport
implements Serializable {
    private String _name;
    private String _description;
    private String _schedule;
    private String _retainInterval;
    private PackageReportStatusType _status;
    private List<Parameter> _parameterList = new ArrayList<Parameter>();

    public void addParameter(Parameter vParameter) throws IndexOutOfBoundsException {
        this._parameterList.add(vParameter);
    }

    public void addParameter(int index, Parameter vParameter) throws IndexOutOfBoundsException {
        this._parameterList.add(index, vParameter);
    }

    public Enumeration<Parameter> enumerateParameter() {
        return Collections.enumeration(this._parameterList);
    }

    public String getDescription() {
        return this._description;
    }

    public String getName() {
        return this._name;
    }

    public Parameter getParameter(int index) throws IndexOutOfBoundsException {
        if (index < 0 || index >= this._parameterList.size()) {
            throw new IndexOutOfBoundsException("getParameter: Index value '" + index + "' not in range [0.." + (this._parameterList.size() - 1) + "]");
        }
        return this._parameterList.get(index);
    }

    public Parameter[] getParameter() {
        Parameter[] array = new Parameter[]{};
        return this._parameterList.toArray(array);
    }

    public List<Parameter> getParameterCollection() {
        return this._parameterList;
    }

    public int getParameterCount() {
        return this._parameterList.size();
    }

    public String getRetainInterval() {
        return this._retainInterval;
    }

    public String getSchedule() {
        return this._schedule;
    }

    public PackageReportStatusType getStatus() {
        return this._status;
    }

    public boolean isValid() {
        try {
            this.validate();
        }
        catch (ValidationException vex) {
            return false;
        }
        return true;
    }

    public Iterator<Parameter> iterateParameter() {
        return this._parameterList.iterator();
    }

    public void marshal(Writer out) throws MarshalException, ValidationException {
        Marshaller.marshal((Object)this, (Writer)out);
    }

    public void marshal(ContentHandler handler) throws IOException, MarshalException, ValidationException {
        Marshaller.marshal((Object)this, (ContentHandler)handler);
    }

    public void removeAllParameter() {
        this._parameterList.clear();
    }

    public boolean removeParameter(Parameter vParameter) {
        boolean removed = this._parameterList.remove(vParameter);
        return removed;
    }

    public Parameter removeParameterAt(int index) {
        Parameter obj = this._parameterList.remove(index);
        return obj;
    }

    public void setDescription(String description) {
        this._description = description;
    }

    public void setName(String name) {
        this._name = name;
    }

    public void setParameter(int index, Parameter vParameter) throws IndexOutOfBoundsException {
        if (index < 0 || index >= this._parameterList.size()) {
            throw new IndexOutOfBoundsException("setParameter: Index value '" + index + "' not in range [0.." + (this._parameterList.size() - 1) + "]");
        }
        this._parameterList.set(index, vParameter);
    }

    public void setParameter(Parameter[] vParameterArray) {
        this._parameterList.clear();
        for (int i = 0; i < vParameterArray.length; ++i) {
            this._parameterList.add(vParameterArray[i]);
        }
    }

    public void setParameter(List<Parameter> vParameterList) {
        this._parameterList.clear();
        this._parameterList.addAll(vParameterList);
    }

    public void setParameterCollection(List<Parameter> parameterList) {
        this._parameterList = parameterList;
    }

    public void setRetainInterval(String retainInterval) {
        this._retainInterval = retainInterval;
    }

    public void setSchedule(String schedule) {
        this._schedule = schedule;
    }

    public void setStatus(PackageReportStatusType status) {
        this._status = status;
    }

    public static PackageReport unmarshal(Reader reader) throws MarshalException, ValidationException {
        return (PackageReport)Unmarshaller.unmarshal(PackageReport.class, (Reader)reader);
    }

    public void validate() throws ValidationException {
        Validator validator = new Validator();
        validator.validate((Object)this);
    }
}

