/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.provision.service.snmp;

import java.net.InetAddress;
import java.util.Set;
import org.opennms.netmgt.model.OnmsNode;
import org.opennms.netmgt.model.OnmsSnmpInterface;
import org.opennms.netmgt.provision.service.snmp.IfXTableEntry;
import org.opennms.netmgt.provision.service.snmp.SnmpTable;
import org.opennms.netmgt.snmp.SnmpInstId;
import org.opennms.netmgt.snmp.SnmpObjId;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class IfXTable
extends SnmpTable<IfXTableEntry> {
    public IfXTable(InetAddress address) {
        this(address, null);
    }

    public IfXTable(InetAddress address, Set<SnmpInstId> ifIndices) {
        super(address, "ifXTable", IfXTableEntry.ms_elemList, ifIndices);
    }

    @Override
    protected IfXTableEntry createTableEntry(SnmpObjId base, SnmpInstId inst, Object val) {
        return new IfXTableEntry(inst.toInt());
    }

    public String getIfName(int ifIndex) {
        return this.getEntry(ifIndex) == null ? null : ((IfXTableEntry)((Object)this.getEntry(ifIndex))).getIfName();
    }

    public String getIfAlias(int ifIndex) {
        return this.getEntry(ifIndex) == null ? null : ((IfXTableEntry)((Object)this.getEntry(ifIndex))).getIfAlias();
    }

    public void updateSnmpInterfaceData(OnmsNode node) {
        for (IfXTableEntry entry : this.getEntries()) {
            this.updateSnmpInterfaceData(node, entry.getIfIndex());
        }
    }

    public void updateSnmpInterfaceData(OnmsNode node, Integer ifIndex) {
        OnmsSnmpInterface snmpIf2 = node.getSnmpInterfaceWithIfIndex(ifIndex.intValue());
        if (snmpIf2 == null) {
            snmpIf2 = new OnmsSnmpInterface(null, ifIndex, node);
        }
        snmpIf2.setIfAlias(this.getIfAlias(ifIndex));
        snmpIf2.setIfName(this.getIfName(ifIndex));
    }
}

