/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.provision.service.operations;

import java.net.InetAddress;
import java.net.UnknownHostException;
import org.opennms.netmgt.model.OnmsCategory;
import org.opennms.netmgt.model.OnmsIpInterface;
import org.opennms.netmgt.model.OnmsMonitoredService;
import org.opennms.netmgt.model.OnmsNode;
import org.opennms.netmgt.model.OnmsServiceType;
import org.opennms.netmgt.provision.service.ProvisionService;
import org.opennms.netmgt.provision.service.operations.ImportOperation;
import org.opennms.netmgt.provision.service.operations.ScanManager;
import org.springframework.beans.BeanWrapperImpl;

public abstract class SaveOrUpdateOperation
extends ImportOperation {
    private final OnmsNode m_node = new OnmsNode();
    private OnmsIpInterface m_currentInterface;
    private ScanManager m_scanManager;

    public SaveOrUpdateOperation(String foreignSource, String foreignId, String nodeLabel, String building, String city, ProvisionService provisionService) {
        this(null, foreignSource, foreignId, nodeLabel, building, city, provisionService);
    }

    public SaveOrUpdateOperation(Integer nodeId, String foreignSource, String foreignId, String nodeLabel, String building, String city, ProvisionService provisionService) {
        super(provisionService);
        this.m_node.setId(nodeId);
        this.m_node.setLabel(nodeLabel);
        this.m_node.setLabelSource("U");
        this.m_node.setType("A");
        this.m_node.setForeignSource(foreignSource);
        this.m_node.setForeignId(foreignId);
        this.m_node.getAssetRecord().setBuilding(building);
        this.m_node.getAssetRecord().setCity(city);
    }

    public ScanManager getScanManager() {
        return this.m_scanManager;
    }

    public void foundInterface(String ipAddr, Object descr, String snmpPrimary, boolean managed, int status) {
        if (ipAddr == null || "".equals(ipAddr)) {
            this.log().error(String.format("Found interface on node %s with an empty ipaddr! Ignoring!", this.m_node.getLabel()));
            return;
        }
        this.m_currentInterface = new OnmsIpInterface(ipAddr, this.m_node);
        this.m_currentInterface.setIsManaged(status == 3 ? "U" : "M");
        this.m_currentInterface.setIsSnmpPrimary(OnmsIpInterface.PrimaryType.get((String)snmpPrimary));
        if ("P".equals(snmpPrimary)) {
            try {
                this.m_scanManager = new ScanManager(InetAddress.getByName(ipAddr));
            }
            catch (UnknownHostException e) {
                String msg = String.format("Unable to resolve address of snmpPrimary interface for node %s with address '%s'", this.m_node.getLabel(), ipAddr);
                this.log().error(msg, (Throwable)e);
            }
        }
        this.m_node.addIpInterface(this.m_currentInterface);
    }

    public void scan() {
        this.updateSnmpData();
    }

    protected void updateSnmpData() {
        if (this.m_scanManager != null) {
            this.m_scanManager.updateSnmpData(this.m_node);
        }
    }

    public void foundMonitoredService(String serviceName) {
        if (this.m_currentInterface != null) {
            OnmsServiceType svcType = this.getProvisionService().createServiceTypeIfNecessary(serviceName);
            OnmsMonitoredService service = new OnmsMonitoredService(this.m_currentInterface, svcType);
            service.setStatus("A");
            this.m_currentInterface.getMonitoredServices().add(service);
        }
    }

    public void foundCategory(String name) {
        OnmsCategory category = this.getProvisionService().createCategoryIfNecessary(name);
        this.m_node.getCategories().add(category);
    }

    protected OnmsNode getNode() {
        return this.m_node;
    }

    public void foundAsset(String name, String value) {
        BeanWrapperImpl w = new BeanWrapperImpl((Object)this.m_node.getAssetRecord());
        w.setPropertyValue(name, (Object)value);
    }
}

