/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.provision.service;

import java.net.InetAddress;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.opennms.core.tasks.BatchTask;
import org.opennms.core.tasks.ContainerTask;
import org.opennms.core.tasks.DefaultTaskCoordinator;
import org.opennms.core.tasks.NeedsContainer;
import org.opennms.core.tasks.RunInBatch;
import org.opennms.core.tasks.Task;
import org.opennms.core.utils.LogUtils;
import org.opennms.core.utils.ThreadCategory;
import org.opennms.netmgt.dao.SnmpAgentConfigFactory;
import org.opennms.netmgt.model.OnmsIpInterface;
import org.opennms.netmgt.model.OnmsNode;
import org.opennms.netmgt.model.OnmsSnmpInterface;
import org.opennms.netmgt.model.events.EventBuilder;
import org.opennms.netmgt.model.events.EventForwarder;
import org.opennms.netmgt.provision.IpInterfacePolicy;
import org.opennms.netmgt.provision.SnmpInterfacePolicy;
import org.opennms.netmgt.provision.service.IPInterfaceTableTracker;
import org.opennms.netmgt.provision.service.IpInterfaceScan;
import org.opennms.netmgt.provision.service.NodeInfoScan;
import org.opennms.netmgt.provision.service.NodeScanSchedule;
import org.opennms.netmgt.provision.service.PhysInterfaceTableTracker;
import org.opennms.netmgt.provision.service.ProvisionService;
import org.opennms.netmgt.provision.service.ScanProgress;
import org.opennms.netmgt.snmp.CollectionTracker;
import org.opennms.netmgt.snmp.SnmpAgentConfig;
import org.opennms.netmgt.snmp.SnmpUtils;
import org.opennms.netmgt.snmp.SnmpWalker;
import org.springframework.util.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NodeScan
implements RunInBatch {
    private Integer m_nodeId;
    private String m_foreignSource;
    private String m_foreignId;
    private Date m_scanStamp;
    private ProvisionService m_provisionService;
    private EventForwarder m_eventForwarder;
    private SnmpAgentConfigFactory m_agentConfigFactory;
    private DefaultTaskCoordinator m_taskCoordinator;
    private boolean m_aborted = false;
    private OnmsNode m_node;
    private boolean m_agentFound = false;

    public NodeScan(Integer nodeId, String foreignSource, String foreignId, ProvisionService provisionService, EventForwarder eventForwarder, SnmpAgentConfigFactory agentConfigFactory, DefaultTaskCoordinator taskCoordinator) {
        this.m_nodeId = nodeId;
        this.m_foreignSource = foreignSource;
        this.m_foreignId = foreignId;
        this.m_scanStamp = new Date();
        this.m_provisionService = provisionService;
        this.m_eventForwarder = eventForwarder;
        this.m_agentConfigFactory = agentConfigFactory;
        this.m_taskCoordinator = taskCoordinator;
    }

    public String getForeignSource() {
        return this.m_foreignSource;
    }

    public String getForeignId() {
        return this.m_foreignId;
    }

    public Integer getNodeId() {
        return this.m_nodeId;
    }

    public OnmsNode getNode() {
        return this.m_node;
    }

    private void setAgentFound(boolean agentFound) {
        this.m_agentFound = agentFound;
    }

    private boolean isAgentFound() {
        return this.m_agentFound;
    }

    public Date getScanStamp() {
        return this.m_scanStamp;
    }

    public ProvisionService getProvisionService() {
        return this.m_provisionService;
    }

    public EventForwarder getEventForwarder() {
        return this.m_eventForwarder;
    }

    public DefaultTaskCoordinator getTaskCoordinator() {
        return this.m_taskCoordinator;
    }

    public boolean isAborted() {
        return this.m_aborted;
    }

    public void abort(String reason) {
        this.m_aborted = true;
        LogUtils.infof((Object)this, (String)"Aborting Scan of node %d for the following reason: %s", (Object[])new Object[]{this.m_nodeId, reason});
        EventBuilder bldr = new EventBuilder("uei.opennms.org/internal/provisiond/nodeScanAborted", "Provisiond");
        if (this.m_nodeId != null) {
            bldr.setNodeid(this.m_nodeId.intValue());
        }
        bldr.addParam("foreignSource", this.m_foreignSource);
        bldr.addParam("foreignId", this.m_foreignId);
        bldr.addParam("reason", reason);
        this.m_eventForwarder.sendNow(bldr.getEvent());
    }

    Task createTask() {
        return this.getTaskCoordinator().createBatch().add(new RunInBatch[]{this}).get();
    }

    public void run(BatchTask parent) {
        LogUtils.infof((Object)this, (String)"Scanning node (%s/%s)", (Object[])new Object[]{this.m_foreignSource, this.m_foreignId});
        parent.getBuilder().addSequence(new RunInBatch[]{new RunInBatch(){

            public void run(BatchTask phase) {
                NodeScan.this.loadNode(phase);
            }
        }, new RunInBatch(){

            public void run(BatchTask phase) {
                NodeScan.this.detectAgents(phase);
            }
        }, new RunInBatch(){

            public void run(BatchTask phase) {
                NodeScan.this.handleAgentUndetected(phase);
            }
        }, new RunInBatch(){

            public void run(BatchTask phase) {
                NodeScan.this.scanCompleted(phase);
            }
        }});
    }

    ScheduledFuture<?> schedule(ScheduledExecutorService executor, NodeScanSchedule schedule) {
        Runnable r = new Runnable(){

            public void run() {
                try {
                    Task t = NodeScan.this.createTask();
                    t.schedule();
                    t.waitFor();
                    LogUtils.debugf((Object)NodeScan.this, (String)"Finished scanning node (%s/%s)", (Object[])new Object[]{NodeScan.this.m_foreignSource, NodeScan.this.m_foreignId});
                }
                catch (InterruptedException e) {
                    LogUtils.warnf((Object)NodeScan.this, (Throwable)e, (String)"The node scan was interrupted", (Object[])new Object[0]);
                }
                catch (ExecutionException e) {
                    LogUtils.warnf((Object)NodeScan.this, (Throwable)e, (String)"An error occurred while scanning node (%s/%s)", (Object[])new Object[]{NodeScan.this.m_foreignSource, NodeScan.this.m_foreignId});
                }
            }
        };
        ScheduledFuture<?> future = executor.scheduleWithFixedDelay(r, schedule.getInitialDelay().getMillis(), schedule.getScanInterval().getMillis(), TimeUnit.MILLISECONDS);
        return future;
    }

    public void loadNode(BatchTask loadNode) {
        if (this.getForeignSource() != null) {
            this.m_node = this.m_provisionService.getRequisitionedNode(this.getForeignSource(), this.getForeignId());
            if (this.m_node == null) {
                this.abort(String.format("Unable to get requisitioned node (%s/%s): aborted", this.m_foreignSource, this.m_foreignId));
            } else {
                for (OnmsIpInterface iface : this.m_node.getIpInterfaces()) {
                    loadNode.add((RunInBatch)new IpInterfaceScan(this.getNodeId(), iface.getInetAddress(), this.getForeignSource(), this.getProvisionService()));
                }
            }
        } else {
            this.m_node = this.m_provisionService.getNode(this.m_nodeId);
        }
    }

    public AgentScan createAgentScan(InetAddress agentAddress, String agentType) {
        return new AgentScan(this.m_nodeId, this.m_node, agentAddress, agentType);
    }

    NoAgentScan createNoAgentScan() {
        return new NoAgentScan(this.m_nodeId, this.m_node);
    }

    private ThreadCategory log() {
        return ThreadCategory.getInstance(NodeScan.class);
    }

    public String toString() {
        return new ToStringBuilder((Object)this).append("foreign source", (Object)this.m_foreignSource).append("foreign id", (Object)this.m_foreignId).append("node id", (Object)this.m_nodeId).append("aborted", this.m_aborted).append("provision service", (Object)this.m_provisionService).toString();
    }

    public void detectAgents(BatchTask currentPhase) {
        if (!this.isAborted()) {
            OnmsIpInterface primaryIface = this.m_provisionService.getPrimaryInterfaceForNode(this.getNode());
            if (primaryIface != null && primaryIface.getMonitoredServiceByServiceType("SNMP") != null) {
                System.err.println("SNMPSNMPSNMP Found primary interface and SNMP service!!");
                this.onAgentFound((ContainerTask<?>)currentPhase, primaryIface);
            } else {
                System.err.println("SNMPSNMPSNMP Failed to find primary interface and SNMP service!!");
            }
        }
    }

    public void handleAgentUndetected(BatchTask currentPhase) {
        if (!this.isAgentFound()) {
            currentPhase.add((NeedsContainer)this.createNoAgentScan());
        }
    }

    private void onAgentFound(ContainerTask<?> currentPhase, OnmsIpInterface primaryIface) {
        currentPhase.add((NeedsContainer)this.createAgentScan(primaryIface.getInetAddress(), "SNMP"));
        this.setAgentFound(true);
    }

    public void scanCompleted(BatchTask currentPhase) {
        if (!this.isAborted()) {
            EventBuilder bldr = new EventBuilder("uei.opennms.org/internal/provisiond/nodeScanCompleted", "Provisiond");
            bldr.setNodeid(this.getNodeId().intValue());
            bldr.addParam("foreignSource", this.getForeignSource());
            bldr.addParam("foreignId", this.getForeignId());
            this.getEventForwarder().sendNow(bldr.getEvent());
        }
    }

    public class BaseAgentScan {
        private OnmsNode m_node;
        private Integer m_nodeId;

        private BaseAgentScan(Integer nodeId, OnmsNode node) {
            this.m_nodeId = nodeId;
            this.m_node = node;
        }

        public Date getScanStamp() {
            return NodeScan.this.m_scanStamp;
        }

        public OnmsNode getNode() {
            return this.m_node;
        }

        public Integer getNodeId() {
            return this.m_nodeId;
        }

        public boolean isAborted() {
            return NodeScan.this.isAborted();
        }

        public void abort(String reason) {
            NodeScan.this.abort(reason);
        }

        public String getForeignSource() {
            return this.m_node.getForeignSource();
        }

        public String getForeignId() {
            return this.m_node.getForeignId();
        }

        public ProvisionService getProvisionService() {
            return NodeScan.this.m_provisionService;
        }

        public String toString() {
            return new ToStringBuilder((Object)this).append("foreign source", (Object)this.getForeignSource()).append("foreign id", (Object)this.getForeignId()).append("node id", (Object)this.m_nodeId).append("scan stamp", (Object)NodeScan.this.m_scanStamp).toString();
        }

        void updateIpInterface(BatchTask currentPhase, OnmsIpInterface iface) {
            this.getProvisionService().updateIpInterfaceAttributes(this.getNodeId(), iface);
            if (iface.isManaged()) {
                currentPhase.add((RunInBatch)new IpInterfaceScan(this.getNodeId(), iface.getInetAddress(), this.getForeignSource(), this.getProvisionService()));
            }
        }

        protected Runnable ipUpdater(final BatchTask currentPhase, final OnmsIpInterface iface) {
            Runnable r = new Runnable(){

                public void run() {
                    BaseAgentScan.this.updateIpInterface(currentPhase, iface);
                }
            };
            return r;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class NoAgentScan
    extends BaseAgentScan
    implements NeedsContainer {
        private NoAgentScan(Integer nodeId, OnmsNode node) {
            super(nodeId, node);
        }

        void stampProvisionedInterfaces(BatchTask phase) {
            if (!this.isAborted()) {
                for (OnmsIpInterface iface : this.getNode().getIpInterfaces()) {
                    iface.setIpLastCapsdPoll(this.getScanStamp());
                    phase.add(this.ipUpdater(phase, iface), "write");
                }
            }
        }

        void deleteObsoleteResources(BatchTask phase) {
            this.getProvisionService().updateNodeScanStamp(this.getNodeId(), this.getScanStamp());
            this.getProvisionService().deleteObsoleteInterfaces(this.getNodeId(), this.getScanStamp());
            LogUtils.debugf((Object)this, (String)("Finished phase " + phase), (Object[])new Object[0]);
        }

        public void run(ContainerTask<?> parent) {
            parent.getBuilder().addSequence(new RunInBatch[]{new RunInBatch(){

                public void run(BatchTask phase) {
                    NoAgentScan.this.stampProvisionedInterfaces(phase);
                }
            }, new RunInBatch(){

                public void run(BatchTask phase) {
                    NoAgentScan.this.deleteObsoleteResources(phase);
                }
            }});
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class AgentScan
    extends BaseAgentScan
    implements NeedsContainer,
    ScanProgress {
        private InetAddress m_agentAddress;
        private String m_agentType;

        public AgentScan(Integer nodeId, OnmsNode node, InetAddress agentAddress, String agentType) {
            super(nodeId, node);
            this.m_agentAddress = agentAddress;
            this.m_agentType = agentType;
        }

        public InetAddress getAgentAddress() {
            return this.m_agentAddress;
        }

        public String getAgentType() {
            return this.m_agentType;
        }

        public void setNode(OnmsNode node) {
            NodeScan.this.m_node = node;
        }

        @Override
        public String toString() {
            return new ToStringBuilder((Object)this).append("address", (Object)this.m_agentAddress).append("type", (Object)this.m_agentType).toString();
        }

        public EventForwarder getEventForwarder() {
            return NodeScan.this.m_eventForwarder;
        }

        void completed() {
            if (!this.isAborted()) {
                EventBuilder bldr = new EventBuilder("uei.opennms.org/nodes/reinitializePrimarySnmpInterface", "Provisiond");
                bldr.setNodeid(this.getNodeId().intValue());
                bldr.setInterface(this.getAgentAddress().getHostAddress());
                this.getEventForwarder().sendNow(bldr.getEvent());
            }
        }

        void deleteObsoleteResources() {
            if (!this.isAborted()) {
                this.getProvisionService().updateNodeScanStamp(this.getNodeId(), this.getScanStamp());
                this.getProvisionService().deleteObsoleteInterfaces(this.getNodeId(), this.getScanStamp());
                LogUtils.debugf((Object)this, (String)"Finished deleteObsoleteResources for %s", (Object[])new Object[]{this});
            }
        }

        public SnmpAgentConfigFactory getAgentConfigFactory() {
            return NodeScan.this.m_agentConfigFactory;
        }

        public void detectIpInterfaces(final BatchTask currentPhase) {
            if (!this.isAborted()) {
                SnmpAgentConfig agentConfig = this.getAgentConfigFactory().getAgentConfig(this.getAgentAddress());
                Assert.notNull((Object)this.getAgentConfigFactory(), (String)"agentConfigFactory was not injected");
                final HashSet<String> provisionedIps = new HashSet<String>();
                if (this.getForeignSource() != null) {
                    for (OnmsIpInterface provisioned : this.getNode().getIpInterfaces()) {
                        provisionedIps.add(provisioned.getIpAddress());
                    }
                }
                IPInterfaceTableTracker ipIfTracker = new IPInterfaceTableTracker(){

                    public void processIPInterfaceRow(IPInterfaceTableTracker.IPInterfaceRow row) {
                        System.out.println("Processing row with ipAddr " + row.getIpAddress());
                        if (!row.getIpAddress().startsWith("127.0.0")) {
                            provisionedIps.remove(row.getIpAddress());
                            OnmsIpInterface iface = row.createInterfaceFromRow();
                            iface.setIpLastCapsdPoll(AgentScan.this.getScanStamp());
                            iface.setIsManaged("M");
                            List<IpInterfacePolicy> policies = AgentScan.this.getProvisionService().getIpInterfacePoliciesForForeignSource(AgentScan.this.getForeignSource() == null ? "default" : AgentScan.this.getForeignSource());
                            for (IpInterfacePolicy policy : policies) {
                                if (iface == null) continue;
                                iface = policy.apply(iface);
                            }
                            if (iface != null) {
                                currentPhase.add(AgentScan.this.ipUpdater(currentPhase, iface), "write");
                            }
                        }
                    }
                };
                SnmpWalker walker = SnmpUtils.createWalker((SnmpAgentConfig)agentConfig, (String)"ipAddrTable", (CollectionTracker)ipIfTracker);
                walker.start();
                try {
                    walker.waitFor();
                    if (walker.timedOut()) {
                        this.abort("Aborting node scan : Agent timedout while scanning the ipAddrTable");
                    } else if (walker.failed()) {
                        this.abort("Aborting node scan : Agent failed while scanning the ipAddrTable : " + walker.getErrorMessage());
                    } else {
                        for (String ipAddr : provisionedIps) {
                            OnmsIpInterface iface = this.getNode().getIpInterfaceByIpAddress(ipAddr);
                            iface.setIpLastCapsdPoll(this.getScanStamp());
                            iface.setIsManaged("M");
                            currentPhase.add(this.ipUpdater(currentPhase, iface), "write");
                        }
                        LogUtils.debugf((Object)this, (String)"Finished phase %s", (Object[])new Object[]{currentPhase});
                    }
                }
                catch (InterruptedException e) {
                    this.abort("Aborting node scan : Scan thread failed while waiting for ipAddrTable");
                }
            }
        }

        public void detectPhysicalInterfaces(final BatchTask currentPhase) {
            if (this.isAborted()) {
                return;
            }
            SnmpAgentConfig agentConfig = this.getAgentConfigFactory().getAgentConfig(this.getAgentAddress());
            Assert.notNull((Object)this.getAgentConfigFactory(), (String)"agentConfigFactory was not injected");
            PhysInterfaceTableTracker physIfTracker = new PhysInterfaceTableTracker(){

                public void processPhysicalInterfaceRow(PhysInterfaceTableTracker.PhysicalInterfaceRow row) {
                    System.out.println("Processing row for ifIndex " + row.getIfIndex());
                    OnmsSnmpInterface snmpIface = row.createInterfaceFromRow();
                    snmpIface.setLastCapsdPoll(AgentScan.this.getScanStamp());
                    List<SnmpInterfacePolicy> policies = AgentScan.this.getProvisionService().getSnmpInterfacePoliciesForForeignSource(AgentScan.this.getForeignSource() == null ? "default" : AgentScan.this.getForeignSource());
                    for (SnmpInterfacePolicy policy : policies) {
                        if (snmpIface == null) continue;
                        snmpIface = policy.apply(snmpIface);
                    }
                    if (snmpIface != null) {
                        final OnmsSnmpInterface snmpIfaceResult = snmpIface;
                        Runnable r = new Runnable(){

                            public void run() {
                                AgentScan.this.getProvisionService().updateSnmpInterfaceAttributes(AgentScan.this.getNodeId(), snmpIfaceResult);
                            }
                        };
                        currentPhase.add(r, "write");
                    }
                }
            };
            SnmpWalker walker = SnmpUtils.createWalker((SnmpAgentConfig)agentConfig, (String)"ifTable/ifXTable", (CollectionTracker)physIfTracker);
            walker.start();
            try {
                walker.waitFor();
                if (walker.timedOut()) {
                    this.abort("Aborting node scan : Agent timedout while scanning the interfaces table");
                } else if (walker.failed()) {
                    this.abort("Aborting node scan : Agent failed while scanning the interfaces table: " + walker.getErrorMessage());
                } else {
                    LogUtils.debugf((Object)this, (String)"Finished phase %s", (Object[])new Object[]{currentPhase});
                }
            }
            catch (InterruptedException e) {
                this.abort("Aborting node scan : Scan thread interrupted while waiting for interfaces table");
            }
        }

        public void run(ContainerTask<?> parent) {
            parent.getBuilder().addSequence(new RunInBatch[]{new NodeInfoScan(this.getNode(), this.getAgentAddress(), this.getForeignSource(), this, this.getAgentConfigFactory(), this.getProvisionService()), new RunInBatch(){

                public void run(BatchTask phase) {
                    AgentScan.this.detectPhysicalInterfaces(phase);
                }
            }, new RunInBatch(){

                public void run(BatchTask phase) {
                    AgentScan.this.detectIpInterfaces(phase);
                }
            }, new RunInBatch(){

                public void run(BatchTask phase) {
                    AgentScan.this.deleteObsoleteResources();
                }
            }, new RunInBatch(){

                public void run(BatchTask phase) {
                    AgentScan.this.completed();
                }
            }});
        }
    }
}

