/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.provision.service;

import java.net.InetAddress;
import java.util.List;
import org.opennms.core.tasks.BatchTask;
import org.opennms.core.tasks.RunInBatch;
import org.opennms.netmgt.dao.SnmpAgentConfigFactory;
import org.opennms.netmgt.model.OnmsNode;
import org.opennms.netmgt.provision.NodePolicy;
import org.opennms.netmgt.provision.service.ProvisionService;
import org.opennms.netmgt.provision.service.ScanProgress;
import org.opennms.netmgt.provision.service.snmp.SystemGroup;
import org.opennms.netmgt.snmp.CollectionTracker;
import org.opennms.netmgt.snmp.SnmpAgentConfig;
import org.opennms.netmgt.snmp.SnmpUtils;
import org.opennms.netmgt.snmp.SnmpWalker;
import org.springframework.util.Assert;

final class NodeInfoScan
implements RunInBatch {
    private final SnmpAgentConfigFactory m_agentConfigFactory;
    private final InetAddress m_agentAddress;
    private final String m_foreignSource;
    private OnmsNode m_node;
    private final ProvisionService m_provisionService;
    private final ScanProgress m_scanProgress;

    NodeInfoScan(OnmsNode node, InetAddress agentAddress, String foreignSource, ScanProgress scanProgress, SnmpAgentConfigFactory agentConfigFactory, ProvisionService provisionService) {
        this.m_node = node;
        this.m_agentAddress = agentAddress;
        this.m_foreignSource = foreignSource;
        this.m_scanProgress = scanProgress;
        this.m_agentConfigFactory = agentConfigFactory;
        this.m_provisionService = provisionService;
    }

    public void run(BatchTask phase) {
        phase.getBuilder().addSequence(new RunInBatch[]{new RunInBatch(){

            public void run(BatchTask batch) {
                NodeInfoScan.this.collectNodeInfo();
            }
        }, new RunInBatch(){

            public void run(BatchTask phase) {
                NodeInfoScan.this.doPersistNodeInfo();
            }
        }});
    }

    private InetAddress getAgentAddress() {
        return this.m_agentAddress;
    }

    private SnmpAgentConfig getAgentConfig(InetAddress primaryAddress) {
        return this.getAgentConfigFactory().getAgentConfig(primaryAddress);
    }

    private SnmpAgentConfigFactory getAgentConfigFactory() {
        return this.m_agentConfigFactory;
    }

    private String getForeignSource() {
        return this.m_foreignSource;
    }

    private ProvisionService getProvisionService() {
        return this.m_provisionService;
    }

    private void abort(String reason) {
        this.m_scanProgress.abort(reason);
    }

    private OnmsNode getNode() {
        return this.m_node;
    }

    private void setNode(OnmsNode node) {
        this.m_node = node;
    }

    private void collectNodeInfo() {
        Assert.notNull((Object)this.getAgentConfigFactory(), (String)"agentConfigFactory was not injected");
        InetAddress primaryAddress = this.getAgentAddress();
        SnmpAgentConfig agentConfig = this.getAgentConfig(primaryAddress);
        SystemGroup systemGroup = new SystemGroup(primaryAddress);
        SnmpWalker walker = SnmpUtils.createWalker((SnmpAgentConfig)agentConfig, (String)"systemGroup", (CollectionTracker)systemGroup);
        walker.start();
        try {
            walker.waitFor();
            if (walker.timedOut()) {
                this.abort("Aborting node scan : Agent timedout while scanning the system table");
            } else if (walker.failed()) {
                this.abort("Aborting node scan : Agent failed while scanning the system table: " + walker.getErrorMessage());
            } else {
                systemGroup.updateSnmpDataForNode(this.getNode());
                List<NodePolicy> nodePolicies = this.getProvisionService().getNodePoliciesForForeignSource(this.getEffectiveForeignSource());
                OnmsNode node = this.getNode();
                for (NodePolicy policy : nodePolicies) {
                    if (node == null) continue;
                    node = policy.apply(node);
                }
                if (node == null) {
                    String reason = "Aborted scan of node due to configured policy";
                    this.abort(reason);
                } else {
                    this.setNode(node);
                }
            }
        }
        catch (InterruptedException e) {
            this.abort("Aborting node scan : Scan thread interrupted!");
        }
    }

    private String getEffectiveForeignSource() {
        return this.getForeignSource() == null ? "default" : this.getForeignSource();
    }

    private void doPersistNodeInfo() {
        if (!this.isAborted()) {
            this.getProvisionService().updateNodeAttributes(this.getNode());
        }
    }

    private boolean isAborted() {
        return this.m_scanProgress.isAborted();
    }
}

