/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.provision.service;

import java.net.InetAddress;
import org.opennms.core.tasks.BatchTask;
import org.opennms.core.tasks.DefaultTaskCoordinator;
import org.opennms.core.tasks.RunInBatch;
import org.opennms.core.tasks.Task;
import org.opennms.core.utils.LogUtils;
import org.opennms.netmgt.dao.SnmpAgentConfigFactory;
import org.opennms.netmgt.model.OnmsNode;
import org.opennms.netmgt.model.events.EventForwarder;
import org.opennms.netmgt.provision.service.IpInterfaceScan;
import org.opennms.netmgt.provision.service.NodeInfoScan;
import org.opennms.netmgt.provision.service.NodeScan;
import org.opennms.netmgt.provision.service.ProvisionService;
import org.opennms.netmgt.provision.service.ScanProgress;

public class NewSuspectScan
implements RunInBatch {
    private InetAddress m_ipAddress;
    private ProvisionService m_provisionService;
    private EventForwarder m_eventForwarder;
    private SnmpAgentConfigFactory m_agentConfigFactory;
    private DefaultTaskCoordinator m_taskCoordinator;

    public NewSuspectScan(InetAddress ipAddress, ProvisionService provisionService, EventForwarder eventForwarder, SnmpAgentConfigFactory agentConfigFactory, DefaultTaskCoordinator taskCoordinator) {
        this.m_ipAddress = ipAddress;
        this.m_provisionService = provisionService;
        this.m_eventForwarder = eventForwarder;
        this.m_agentConfigFactory = agentConfigFactory;
        this.m_taskCoordinator = taskCoordinator;
    }

    public Task createTask() {
        return this.m_taskCoordinator.createBatch().add(new RunInBatch[]{this}).get();
    }

    public void run(BatchTask phase) {
        this.scanUndiscoveredNode(phase);
    }

    protected void scanUndiscoveredNode(BatchTask phase) {
        OnmsNode node = this.m_provisionService.createUndiscoveredNode(this.m_ipAddress.getHostAddress());
        if (node != null) {
            phase.getBuilder().addSequence(new RunInBatch[]{new NodeInfoScan(node, this.m_ipAddress, null, this.createScanProgress(), this.m_agentConfigFactory, this.m_provisionService), new IpInterfaceScan(node.getId(), this.m_ipAddress, null, this.m_provisionService), new NodeScan(node.getId(), null, null, this.m_provisionService, this.m_eventForwarder, this.m_agentConfigFactory, this.m_taskCoordinator)});
        }
    }

    private ScanProgress createScanProgress() {
        return new ScanProgress(){
            private boolean m_aborted = false;

            public void abort(String message) {
                this.m_aborted = true;
                LogUtils.infof((Object)this, (String)message, (Object[])new Object[0]);
            }

            public boolean isAborted() {
                return this.m_aborted;
            }
        };
    }

    protected void reparentNodes(BatchTask batch, Integer nodeId) {
    }
}

