/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.provision.service;

import java.net.InetAddress;
import java.util.List;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.opennms.core.tasks.Async;
import org.opennms.core.tasks.BatchTask;
import org.opennms.core.tasks.Callback;
import org.opennms.core.tasks.ContainerTask;
import org.opennms.core.tasks.RunInBatch;
import org.opennms.core.tasks.Task;
import org.opennms.core.utils.LogUtils;
import org.opennms.netmgt.provision.AsyncServiceDetector;
import org.opennms.netmgt.provision.DetectorMonitor;
import org.opennms.netmgt.provision.ServiceDetector;
import org.opennms.netmgt.provision.SyncServiceDetector;
import org.opennms.netmgt.provision.service.AsyncDetectorRunner;
import org.opennms.netmgt.provision.service.ProvisionService;
import org.opennms.netmgt.provision.support.NullDetectorMonitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IpInterfaceScan
implements RunInBatch {
    private ProvisionService m_provisionService;
    private InetAddress m_address;
    private Integer m_nodeId;
    private String m_foreignSource;

    public IpInterfaceScan(Integer nodeId, InetAddress address, String foreignSource, ProvisionService provisionService) {
        this.m_nodeId = nodeId;
        this.m_address = address;
        this.m_foreignSource = foreignSource;
        this.m_provisionService = provisionService;
    }

    public String getForeignSource() {
        return this.m_foreignSource;
    }

    public Integer getNodeId() {
        return this.m_nodeId;
    }

    public InetAddress getAddress() {
        return this.m_address;
    }

    public ProvisionService getProvisionService() {
        return this.m_provisionService;
    }

    public String toString() {
        return new ToStringBuilder((Object)this).append("address", (Object)this.m_address).append("foreign source", (Object)this.m_foreignSource).append("node ID", (Object)this.m_nodeId).toString();
    }

    public Callback<Boolean> servicePersister(final BatchTask currentPhase, final String serviceName) {
        return new Callback<Boolean>(){

            public void complete(Boolean serviceDetected) {
                LogUtils.infof((Object)this, (String)"Attempted to detect service %s on address %s: %s", (Object[])new Object[]{serviceName, IpInterfaceScan.this.getAddress().getHostAddress(), serviceDetected});
                if (serviceDetected.booleanValue()) {
                    currentPhase.getBuilder().addSequence(new RunInBatch[]{new RunInBatch(){

                        public void run(BatchTask batch) {
                            if ("SNMP".equals(serviceName)) {
                                IpInterfaceScan.this.setupAgentInfo(currentPhase);
                            }
                        }
                    }, new RunInBatch(){

                        public void run(BatchTask batch) {
                            IpInterfaceScan.this.getProvisionService().addMonitoredService(IpInterfaceScan.this.getNodeId(), IpInterfaceScan.this.getAddress().getHostAddress(), serviceName);
                        }
                    }});
                }
            }

            public void handleException(Throwable t) {
                LogUtils.infof((Object)this, (Throwable)t, (String)"Exception occurred while trying to detect service %s on address %s", (Object[])new Object[]{serviceName, IpInterfaceScan.this.getAddress().getHostAddress()});
            }
        };
    }

    Runnable runDetector(final SyncServiceDetector detector, final Callback<Boolean> cb) {
        return new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                try {
                    LogUtils.infof((Object)this, (String)"Attemping to detect service %s on address %s", (Object[])new Object[]{detector.getServiceName(), IpInterfaceScan.this.getAddress().getHostAddress()});
                    cb.complete((Object)detector.isServiceDetected(IpInterfaceScan.this.getAddress(), (DetectorMonitor)new NullDetectorMonitor()));
                }
                catch (Throwable t) {
                    cb.handleException(t);
                }
                finally {
                    detector.dispose();
                }
            }

            public String toString() {
                return String.format("Run detector %s on address %s", detector.getServiceName(), IpInterfaceScan.this.getAddress().getHostAddress());
            }
        };
    }

    Async<Boolean> runDetector(AsyncServiceDetector detector) {
        return new AsyncDetectorRunner(this, detector);
    }

    Task createDetectorTask(BatchTask currentPhase, ServiceDetector detector) {
        if (detector instanceof SyncServiceDetector) {
            return this.createSyncDetectorTask(currentPhase, (SyncServiceDetector)detector);
        }
        return this.createAsyncDetectorTask(currentPhase, (AsyncServiceDetector)detector);
    }

    private Task createAsyncDetectorTask(BatchTask currentPhase, AsyncServiceDetector asyncDetector) {
        return currentPhase.getCoordinator().createTask((ContainerTask)currentPhase, this.runDetector(asyncDetector), this.servicePersister(currentPhase, asyncDetector.getServiceName()));
    }

    private Task createSyncDetectorTask(BatchTask currentPhase, SyncServiceDetector syncDetector) {
        return currentPhase.getCoordinator().createTask((ContainerTask)currentPhase, this.runDetector(syncDetector, this.servicePersister(currentPhase, syncDetector.getServiceName())));
    }

    public void run(BatchTask currentPhase) {
        List<ServiceDetector> detectors = this.getProvisionService().getDetectorsForForeignSource(this.getForeignSource() == null ? "default" : this.getForeignSource());
        LogUtils.debugf((Object)this, (String)"detectServices for %d : %s: found %d detectors", (Object[])new Object[]{this.getNodeId(), this.getAddress().getHostAddress(), detectors.size()});
        for (ServiceDetector detector : detectors) {
            currentPhase.add(this.createDetectorTask(currentPhase, detector));
        }
    }

    private void setupAgentInfo(BatchTask currentphase) {
        this.getProvisionService().setIsPrimaryFlag(this.getNodeId(), this.getAddress().getHostAddress());
    }
}

