/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.provision.service;

import java.net.MalformedURLException;
import java.net.URL;
import java.text.ParseException;
import java.util.Arrays;
import org.opennms.core.utils.ThreadCategory;
import org.opennms.netmgt.config.provisiond.RequisitionDef;
import org.opennms.netmgt.dao.ProvisiondConfigurationDao;
import org.opennms.netmgt.provision.service.ImportJob;
import org.opennms.netmgt.provision.service.Provisioner;
import org.opennms.netmgt.provision.service.dns.DnsUrlFactory;
import org.quartz.CronTrigger;
import org.quartz.JobDetail;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.Trigger;
import org.quartz.spi.JobFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.dao.DataAccessResourceFailureException;
import org.springframework.util.StringUtils;

public class ImportScheduler
implements InitializingBean {
    protected static final String JOB_GROUP = "Provisiond";
    @Autowired
    private Scheduler m_scheduler;
    @Autowired
    private Provisioner m_provisioner;
    @Autowired
    private ProvisiondConfigurationDao m_configDao;
    private Object m_lock = new Object();
    private JobFactory m_importJobFactory;

    protected ImportScheduler(Scheduler scheduler) {
        this.m_scheduler = scheduler;
    }

    public void afterPropertiesSet() {
        try {
            this.getScheduler().setJobFactory(this.getImportJobFactory());
        }
        catch (SchedulerException e) {
            this.log().fatal("afterPropertiesSet: couldn't set proper JobFactory for scheduler: " + (Object)((Object)e), (Throwable)e);
        }
        try {
            new URL("dns://host/zone");
        }
        catch (MalformedURLException e) {
            URL.setURLStreamHandlerFactory(new DnsUrlFactory());
        }
        this.buildImportSchedule();
    }

    public void start() throws SchedulerException {
        this.getScheduler().start();
    }

    public void pause() throws SchedulerException {
        this.getScheduler().pauseAll();
    }

    public void standBy() throws SchedulerException {
        this.getScheduler().standby();
    }

    public void resume() throws SchedulerException {
        this.getScheduler().resumeAll();
    }

    public void stop() throws SchedulerException {
        this.getScheduler().shutdown();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void rebuildImportSchedule() throws Exception {
        this.log().info("rebuildImportSchedule: acquiring lock...");
        Object object = this.m_lock;
        synchronized (object) {
            this.log().debug("rebuildImportSchedule: lock acquired.  reloading configuration.");
            try {
                this.m_configDao.reloadConfiguration();
                this.log().debug("rebuildImportSchedule: removing current import jobs from schedule...");
                this.removeCurrentJobsFromSchedule();
                this.log().debug("rebuildImportSchedule: recreating import schedule based on configuration...");
                this.buildImportSchedule();
                this.printCurrentSchedule();
            }
            catch (DataAccessResourceFailureException e) {
                this.log().error("rebuildImportSchedule: " + e.getLocalizedMessage(), (Throwable)e);
                throw new IllegalStateException(e);
            }
            catch (SchedulerException e) {
                this.log().error("rebuildImportSchedule: " + e.getLocalizedMessage(), (Throwable)e);
                throw e;
            }
        }
        this.log().info("rebuildImportSchedule: schedule rebuilt and lock released.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeCurrentJobsFromSchedule() throws SchedulerException {
        this.printCurrentSchedule();
        Object object = this.m_lock;
        synchronized (object) {
            for (String jobName : Arrays.asList(this.m_scheduler.getJobNames(JOB_GROUP))) {
                try {
                    this.getScheduler().deleteJob(jobName, JOB_GROUP);
                }
                catch (SchedulerException e) {
                    this.log().error("removeCurrentJobsFromSchedule: " + e.getLocalizedMessage(), (Throwable)e);
                }
            }
        }
        this.printCurrentSchedule();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void buildImportSchedule() {
        Object object = this.m_lock;
        synchronized (object) {
            for (RequisitionDef def : this.m_configDao.getDefs()) {
                JobDetail detail = null;
                CronTrigger trigger = null;
                try {
                    detail = new JobDetail(def.getImportName(), JOB_GROUP, ImportJob.class, false, false, false);
                    detail.getJobDataMap().put("url", def.getImportUrlResource());
                    trigger = new CronTrigger(def.getImportName(), JOB_GROUP, def.getCronSchedule());
                    trigger.setMisfireInstruction(2);
                    this.getScheduler().scheduleJob(detail, (Trigger)trigger);
                }
                catch (ParseException e) {
                    this.log().error("buildImportSchedule: " + e.getLocalizedMessage(), (Throwable)e);
                }
                catch (SchedulerException e) {
                    this.log().error("buildImportSchedule: " + e.getLocalizedMessage(), (Throwable)e);
                }
            }
        }
        this.printCurrentSchedule();
    }

    public Scheduler getScheduler() {
        return this.m_scheduler;
    }

    public void setProvisioner(Provisioner provisioner) {
        this.m_provisioner = provisioner;
    }

    protected final Provisioner getProvisioner() {
        return this.m_provisioner;
    }

    public void setImportJobFactory(JobFactory importJobFactory) {
        this.m_importJobFactory = importJobFactory;
    }

    public JobFactory getImportJobFactory() {
        return this.m_importJobFactory;
    }

    private void printCurrentSchedule() {
        try {
            this.log().info("calendarNames: " + StringUtils.arrayToCommaDelimitedString((Object[])this.getScheduler().getCalendarNames()));
            this.log().info("current executing jobs: " + StringUtils.arrayToCommaDelimitedString((Object[])this.getScheduler().getCurrentlyExecutingJobs().toArray()));
            this.log().info("current job names: " + StringUtils.arrayToCommaDelimitedString((Object[])this.getScheduler().getJobNames(JOB_GROUP)));
            this.log().info("scheduler metadata: " + this.getScheduler().getMetaData());
            this.log().info("trigger names: " + StringUtils.arrayToCommaDelimitedString((Object[])this.getScheduler().getTriggerNames(JOB_GROUP)));
            for (String triggerName : Arrays.asList(this.getScheduler().getTriggerNames(JOB_GROUP))) {
                CronTrigger t = (CronTrigger)this.getScheduler().getTrigger(triggerName, JOB_GROUP);
                StringBuilder sb = new StringBuilder("trigger: ");
                sb.append(triggerName);
                sb.append(", calendar name: ");
                sb.append(t.getCalendarName());
                sb.append(", cron expression: ");
                sb.append(t.getCronExpression());
                sb.append(", URL: ");
                sb.append(t.getJobDataMap().get((Object)"url"));
                sb.append(", next fire time: ");
                sb.append(t.getNextFireTime());
                sb.append(", previous fire time: ");
                sb.append(t.getPreviousFireTime());
                sb.append(", time zone: ");
                sb.append(t.getTimeZone());
                sb.append(", priority: ");
                sb.append(t.getPriority());
                this.log().info(sb.toString());
            }
        }
        catch (Exception e) {
            this.log().error("printCurrentSchedule: " + e.getLocalizedMessage(), (Throwable)e);
        }
    }

    private ThreadCategory log() {
        return ThreadCategory.getInstance(this.getClass());
    }
}

