/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.provision.service;

import org.apache.mina.core.future.IoFutureListener;
import org.opennms.core.tasks.Async;
import org.opennms.core.tasks.Callback;
import org.opennms.core.utils.LogUtils;
import org.opennms.netmgt.provision.AsyncServiceDetector;
import org.opennms.netmgt.provision.DetectFuture;
import org.opennms.netmgt.provision.DetectorMonitor;
import org.opennms.netmgt.provision.service.IpInterfaceScan;
import org.opennms.netmgt.provision.support.NullDetectorMonitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class AsyncDetectorRunner
implements Async<Boolean> {
    private final IpInterfaceScan m_ifaceScan;
    private final AsyncServiceDetector m_detector;

    public AsyncDetectorRunner(IpInterfaceScan ifaceScan, AsyncServiceDetector detector) {
        this.m_ifaceScan = ifaceScan;
        this.m_detector = detector;
    }

    public void submit(Callback<Boolean> cb) {
        try {
            LogUtils.infof((Object)this, (String)"Attemping to detect service %s on address %s", (Object[])new Object[]{this.m_detector.getServiceName(), this.m_ifaceScan.getAddress().getHostAddress()});
            DetectFuture future = this.m_detector.isServiceDetected(this.m_ifaceScan.getAddress(), (DetectorMonitor)new NullDetectorMonitor());
            future.addListener(this.listener(cb));
        }
        catch (Throwable e) {
            cb.handleException(e);
        }
    }

    public String toString() {
        return String.format("Run detector %s on address %s", this.m_detector.getServiceName(), this.m_ifaceScan.getAddress().getHostAddress());
    }

    private IoFutureListener<DetectFuture> listener(final Callback<Boolean> cb) {
        return new IoFutureListener<DetectFuture>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void operationComplete(DetectFuture future) {
                try {
                    if (future.getException() != null) {
                        cb.handleException(future.getException());
                    } else {
                        cb.complete((Object)future.isServiceDetected());
                    }
                }
                finally {
                    AsyncDetectorRunner.this.m_detector.dispose();
                }
            }
        };
    }
}

