/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xml.serializer;

import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.BitSet;
import java.util.Hashtable;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.xml.transform.Transformer;
import org.apache.xml.res.XMLMessages;
import org.apache.xml.serializer.CharInfo;
import org.apache.xml.serializer.Encodings;
import org.apache.xml.serializer.OutputPropertiesFactory;
import org.apache.xml.serializer.OutputPropertyUtils;
import org.apache.xml.serializer.SerializerBase;
import org.apache.xml.serializer.SerializerTraceWriter;
import org.apache.xml.serializer.WriterToASCI;
import org.apache.xml.serializer.WriterToUTF8;
import org.apache.xml.serializer.WriterToUTF8Buffered;
import org.apache.xml.utils.BoolStack;
import org.apache.xml.utils.DOM2Helper;
import org.apache.xml.utils.FastStringBuffer;
import org.apache.xml.utils.TreeWalker;
import org.apache.xml.utils.WrappedRuntimeException;
import org.w3c.dom.Node;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public abstract class ToStream
extends SerializerBase {
    private static final String COMMENT_BEGIN = "<!--";
    private static final String COMMENT_END = "-->";
    protected BoolStack m_disableOutputEscapingStates = new BoolStack();
    boolean m_triedToGetConverter = false;
    Method m_canConvertMeth;
    Object m_charToByteConverter = null;
    protected BoolStack m_preserves = new BoolStack();
    protected boolean m_ispreserve = false;
    protected boolean m_isprevtext = false;
    protected int m_maxCharacter = Encodings.getLastPrintable();
    protected final char[] m_lineSep = System.getProperty("line.separator").toCharArray();
    protected final int m_lineSepLen = this.m_lineSep.length;
    protected CharInfo m_charInfo;
    boolean m_shouldFlush = true;
    protected boolean m_spaceBeforeClose = false;
    boolean m_startNewLine;
    protected boolean m_inDoctype = false;
    boolean m_isUTF8 = false;
    protected Properties m_format;
    protected boolean m_cdataStartCalled = false;
    private boolean m_escaping = true;

    protected void closeCDATA() throws SAXException {
        try {
            this.m_writer.write("]]>");
            this.m_cdataTagOpen = false;
        }
        catch (IOException e) {
            throw new SAXException(e);
        }
    }

    public void serialize(Node node) throws IOException {
        try {
            TreeWalker walker = new TreeWalker(this, new DOM2Helper());
            walker.traverse(node);
        }
        catch (SAXException se) {
            throw new WrappedRuntimeException(se);
        }
    }

    static final boolean isUTF16Surrogate(char c) {
        return (c & 0xFC00) == 55296;
    }

    protected final void flushWriter() throws SAXException {
        if (null != this.m_writer) {
            try {
                if (this.m_writer instanceof WriterToUTF8Buffered) {
                    if (this.m_shouldFlush) {
                        ((WriterToUTF8Buffered)this.m_writer).flush();
                    } else {
                        ((WriterToUTF8Buffered)this.m_writer).flushBuffer();
                    }
                }
                if (this.m_writer instanceof WriterToUTF8) {
                    if (this.m_shouldFlush) {
                        this.m_writer.flush();
                    }
                } else if (this.m_writer instanceof WriterToASCI) {
                    if (this.m_shouldFlush) {
                        this.m_writer.flush();
                    }
                } else {
                    this.m_writer.flush();
                }
            }
            catch (IOException ioe) {
                throw new SAXException(ioe);
            }
        }
    }

    public OutputStream getOutputStream() {
        if (this.m_writer instanceof WriterToUTF8Buffered) {
            return ((WriterToUTF8Buffered)this.m_writer).getOutputStream();
        }
        if (this.m_writer instanceof WriterToUTF8) {
            return ((WriterToUTF8)this.m_writer).getOutputStream();
        }
        if (this.m_writer instanceof WriterToASCI) {
            return ((WriterToASCI)this.m_writer).getOutputStream();
        }
        return null;
    }

    public void elementDecl(String name, String model) throws SAXException {
        if (this.m_inExternalDTD) {
            return;
        }
        try {
            if (this.m_inDoctype) {
                this.m_writer.write(" [");
                this.m_writer.write(this.m_lineSep, 0, this.m_lineSepLen);
                this.m_inDoctype = false;
            }
            this.m_writer.write("<!ELEMENT ");
            this.m_writer.write(name);
            this.m_writer.write(32);
            this.m_writer.write(model);
            this.m_writer.write(62);
            this.m_writer.write(this.m_lineSep, 0, this.m_lineSepLen);
        }
        catch (IOException e) {
            throw new SAXException(e);
        }
    }

    public void internalEntityDecl(String name, String value) throws SAXException {
        if (this.m_inExternalDTD) {
            return;
        }
        try {
            if (this.m_inDoctype) {
                this.m_writer.write(" [");
                this.m_writer.write(this.m_lineSep, 0, this.m_lineSepLen);
                this.m_inDoctype = false;
            }
            this.outputEntityDecl(name, value);
        }
        catch (IOException e) {
            throw new SAXException(e);
        }
    }

    void outputEntityDecl(String name, String value) throws IOException {
        this.m_writer.write("<!ENTITY ");
        this.m_writer.write(name);
        this.m_writer.write(" \"");
        this.m_writer.write(value);
        this.m_writer.write("\">");
        this.m_writer.write(this.m_lineSep, 0, this.m_lineSepLen);
    }

    protected final void outputLineSep() throws IOException {
        this.m_writer.write(this.m_lineSep, 0, this.m_lineSepLen);
    }

    public void setOutputFormat(Properties format) {
        boolean shouldFlush = this.m_shouldFlush;
        this.init(this.m_writer, format, false, false);
        this.m_shouldFlush = shouldFlush;
    }

    private synchronized void init(Writer writer, Properties format, boolean defaultProperties, boolean shouldFlush) {
        String encoding;
        this.m_shouldFlush = shouldFlush;
        this.m_writer = this.m_tracer != null && !(writer instanceof SerializerTraceWriter) ? new SerializerTraceWriter(writer, this.m_tracer) : writer;
        this.m_format = format;
        this.setCdataSectionElements("cdata-section-elements", format);
        this.setIndentAmount(OutputPropertyUtils.getIntProperty("{http://xml.apache.org/xalan}indent-amount", format));
        this.setIndent(OutputPropertyUtils.getBooleanProperty("indent", format));
        boolean shouldNotWriteXMLHeader = OutputPropertyUtils.getBooleanProperty("omit-xml-declaration", format);
        this.setOmitXMLDeclaration(shouldNotWriteXMLHeader);
        this.setDoctypeSystem(format.getProperty("doctype-system"));
        String doctypePublic = format.getProperty("doctype-public");
        this.setDoctypePublic(doctypePublic);
        if (((Hashtable)format).get("standalone") != null) {
            String val = format.getProperty("standalone");
            if (defaultProperties) {
                this.setStandaloneInternal(val);
            } else {
                this.setStandalone(val);
            }
        }
        this.setMediaType(format.getProperty("media-type"));
        if (null != doctypePublic && doctypePublic.startsWith("-//W3C//DTD XHTML")) {
            this.m_spaceBeforeClose = true;
        }
        if (null == (encoding = this.getEncoding())) {
            encoding = Encodings.getMimeEncoding(format.getProperty("encoding"));
            this.setEncoding(encoding);
        }
        this.m_isUTF8 = encoding.equals("UTF-8");
        this.m_maxCharacter = Encodings.getLastPrintable(encoding);
        String entitiesFileName = (String)((Hashtable)format).get("{http://xml.apache.org/xalan}entities");
        if (null != entitiesFileName) {
            this.m_charInfo = CharInfo.getCharInfo(entitiesFileName);
        }
    }

    private synchronized void init(Writer writer, Properties format) {
        this.init(writer, format, false, false);
    }

    protected synchronized void init(OutputStream output, Properties format, boolean defaultProperties) throws UnsupportedEncodingException {
        String encoding = this.getEncoding();
        if (encoding == null) {
            encoding = Encodings.getMimeEncoding(format.getProperty("encoding"));
            this.setEncoding(encoding);
        }
        if (encoding.equalsIgnoreCase("UTF-8")) {
            this.m_isUTF8 = true;
            if (output instanceof BufferedOutputStream || output.getClass().getName().endsWith("BufferedServletOutputStream")) {
                this.init(new WriterToUTF8(output), format, defaultProperties, true);
            } else {
                this.init(new WriterToUTF8Buffered(output), format, defaultProperties, true);
            }
        } else if (encoding.equals("WINDOWS-1250") || encoding.equals("US-ASCII") || encoding.equals("ASCII")) {
            this.init(new WriterToASCI(output), format, defaultProperties, true);
        } else {
            Writer osw;
            try {
                osw = Encodings.getWriter(output, encoding);
            }
            catch (UnsupportedEncodingException uee) {
                System.out.println("Warning: encoding \"" + encoding + "\" not supported" + ", using " + "UTF-8");
                encoding = "UTF-8";
                this.setEncoding(encoding);
                osw = Encodings.getWriter(output, encoding);
            }
            this.m_maxCharacter = Encodings.getLastPrintable(encoding);
            this.init(osw, format, defaultProperties, true);
        }
    }

    public Properties getOutputFormat() {
        return this.m_format;
    }

    public void setWriter(Writer writer) {
        this.m_writer = this.m_tracer != null && !(writer instanceof SerializerTraceWriter) ? new SerializerTraceWriter(writer, this.m_tracer) : writer;
    }

    public void setOutputStream(OutputStream output) {
        try {
            Properties format = null == this.m_format ? OutputPropertiesFactory.getDefaultMethodProperties("xml") : this.m_format;
            this.init(output, format, true);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
    }

    public boolean setEscaping(boolean escape) {
        boolean temp = this.m_escaping;
        this.m_escaping = escape;
        return temp;
    }

    protected void indent() throws IOException {
        if (this.m_startNewLine) {
            this.outputLineSep();
        }
        if (this.m_indentAmount > 0) {
            this.printSpace(this.m_currentElemDepth * this.m_indentAmount);
        }
    }

    private void printSpace(int n) throws IOException {
        int i = 0;
        while (i < n) {
            this.m_writer.write(32);
            ++i;
        }
    }

    public void attributeDecl(String eName, String aName, String type, String valueDefault, String value) throws SAXException {
        if (this.m_inExternalDTD) {
            return;
        }
        try {
            if (this.m_inDoctype) {
                this.m_writer.write(" [");
                this.m_writer.write(this.m_lineSep, 0, this.m_lineSepLen);
                this.m_inDoctype = false;
            }
            this.m_writer.write("<!ATTLIST ");
            this.m_writer.write(eName);
            this.m_writer.write(" ");
            this.m_writer.write(aName);
            this.m_writer.write(" ");
            this.m_writer.write(type);
            if (valueDefault != null) {
                this.m_writer.write(" ");
                this.m_writer.write(valueDefault);
            }
            this.m_writer.write(">");
            this.m_writer.write(this.m_lineSep, 0, this.m_lineSepLen);
        }
        catch (IOException e) {
            throw new SAXException(e);
        }
    }

    public Writer getWriter() {
        return this.m_writer;
    }

    public void externalEntityDecl(String name, String publicId, String systemId) throws SAXException {
    }

    protected boolean escapingNotNeeded(char ch) {
        if (ch < '\u007f') {
            return ch >= ' ' || '\n' == ch || '\r' == ch || '\t' == ch;
        }
        if (null == this.m_charToByteConverter && !this.m_triedToGetConverter) {
            this.m_triedToGetConverter = true;
            try {
                this.m_charToByteConverter = Encodings.getCharToByteConverter(this.getEncoding());
                if (null != this.m_charToByteConverter) {
                    Class[] argsTypes = new Class[]{Character.TYPE};
                    Class<?> convClass = this.m_charToByteConverter.getClass();
                    this.m_canConvertMeth = convClass.getMethod("canConvert", argsTypes);
                }
            }
            catch (Exception e) {
                System.err.println("Warning: " + e.getMessage());
            }
        }
        if (null != this.m_charToByteConverter) {
            try {
                Object[] args = new Object[]{new Character(ch)};
                Boolean bool = (Boolean)this.m_canConvertMeth.invoke(this.m_charToByteConverter, args);
                return bool.booleanValue() ? !Character.isISOControl(ch) : false;
            }
            catch (InvocationTargetException ite) {
                System.err.println("Warning: InvocationTargetException in canConvert!");
            }
            catch (IllegalAccessException iae) {
                System.err.println("Warning: IllegalAccessException in canConvert!");
            }
        }
        return ch <= this.m_maxCharacter;
    }

    protected int writeUTF16Surrogate(char c, char[] ch, int i, int end) throws IOException {
        int surrogateValue = this.getURF16SurrogateValue(c, ch, i, end);
        this.m_writer.write(38);
        this.m_writer.write(35);
        this.m_writer.write(Integer.toString(surrogateValue));
        this.m_writer.write(59);
        return ++i;
    }

    int getURF16SurrogateValue(char c, char[] ch, int i, int end) throws IOException {
        int next;
        if (i + 1 >= end) {
            throw new IOException(XMLMessages.createXMLMessage("ER_INVALID_UTF16_SURROGATE", new Object[]{Integer.toHexString(c)}));
        }
        if (56320 > (next = ch[++i]) || next >= 57344) {
            throw new IOException(XMLMessages.createXMLMessage("ER_INVALID_UTF16_SURROGATE", new Object[]{Integer.toHexString(c) + " " + Integer.toHexString(next)}));
        }
        next = (c - 55296 << 10) + next - 56320 + 65536;
        return next;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected int accumDefaultEntity(Writer writer, char ch, int i, char[] chars, int len, boolean escLF) throws IOException {
        if (!escLF && '\n' == ch) {
            writer.write(this.m_lineSep, 0, this.m_lineSepLen);
            return i + 1;
        } else {
            if (!this.m_charInfo.isSpecial(ch)) return i;
            String entityRef = this.m_charInfo.getEntityNameForChar(ch);
            if (null == entityRef) return i;
            writer.write(38);
            writer.write(entityRef);
            writer.write(59);
        }
        return i + 1;
    }

    void writeNormalizedChars(char[] ch, int start, int length, boolean isCData) throws IOException, SAXException {
        int end = start + length;
        int i = start;
        while (i < end) {
            String intStr;
            char c = ch[i];
            if ('\n' == c) {
                this.m_writer.write(this.m_lineSep, 0, this.m_lineSepLen);
            } else if (isCData && !this.escapingNotNeeded(c)) {
                if (this.m_cdataTagOpen) {
                    this.closeCDATA();
                }
                if (ToStream.isUTF16Surrogate(c)) {
                    i = this.writeUTF16Surrogate(c, ch, i, end);
                } else {
                    this.m_writer.write("&#");
                    intStr = Integer.toString(c);
                    this.m_writer.write(intStr);
                    this.m_writer.write(59);
                }
            } else if (isCData && i < end - 2 && ']' == c && ']' == ch[i + 1] && '>' == ch[i + 2]) {
                this.m_writer.write("]]]]><![CDATA[>");
                i += 2;
            } else if (this.escapingNotNeeded(c)) {
                if (isCData && !this.m_cdataTagOpen) {
                    this.m_writer.write("<![CDATA[");
                    this.m_cdataTagOpen = true;
                }
                this.m_writer.write(c);
            } else if (ToStream.isUTF16Surrogate(c)) {
                if (this.m_cdataTagOpen) {
                    this.closeCDATA();
                }
                i = this.writeUTF16Surrogate(c, ch, i, end);
            } else {
                if (this.m_cdataTagOpen) {
                    this.closeCDATA();
                }
                this.m_writer.write("&#");
                intStr = Integer.toString(c);
                this.m_writer.write(intStr);
                this.m_writer.write(59);
            }
            ++i;
        }
    }

    public void endNonEscaping() throws SAXException {
        this.m_disableOutputEscapingStates.pop();
    }

    public void startNonEscaping() throws SAXException {
        this.m_disableOutputEscapingStates.push(true);
    }

    protected void cdata(char[] ch, int start, int length) throws SAXException {
        try {
            boolean writeCDataBrackets;
            int old_start = start;
            if (this.m_startTagOpen) {
                this.closeStartTag();
                this.m_startTagOpen = false;
            }
            this.m_ispreserve = true;
            if (this.shouldIndent()) {
                this.indent();
            }
            boolean bl = writeCDataBrackets = length >= 1 && this.escapingNotNeeded(ch[start]);
            if (writeCDataBrackets && !this.m_cdataTagOpen) {
                this.m_writer.write("<![CDATA[");
                this.m_cdataTagOpen = true;
            }
            if (this.isEscapingDisabled()) {
                this.charactersRaw(ch, start, length);
            } else {
                this.writeNormalizedChars(ch, start, length, true);
            }
            if (writeCDataBrackets && ch[start + length - 1] == ']') {
                this.closeCDATA();
            }
            if (this.m_tracer != null) {
                super.fireCDATAEvent(ch, old_start, length);
            }
        }
        catch (IOException ioe) {
            throw new SAXException(XMLMessages.createXMLMessage("ER_OIERROR", null), ioe);
        }
    }

    private boolean isEscapingDisabled() {
        return this.m_disableOutputEscapingStates.peekOrFalse();
    }

    protected void charactersRaw(char[] ch, int start, int length) throws SAXException {
        if (this.m_inEntityRef) {
            return;
        }
        try {
            if (this.m_startTagOpen) {
                this.closeStartTag();
                this.m_startTagOpen = false;
            }
            this.m_ispreserve = true;
            this.m_writer.write(ch, start, length);
        }
        catch (IOException e) {
            throw new SAXException(e);
        }
    }

    public void characters(char[] chars, int start, int length) throws SAXException {
        if (0 == length) {
            if (this.m_tracer != null) {
                super.fireCharEvent(chars, start, length);
            }
            return;
        }
        if (this.m_startTagOpen) {
            this.closeStartTag();
            this.m_startTagOpen = false;
        } else if (this.m_needToCallStartDocument) {
            this.startDocumentInternal();
        }
        if (this.m_cdataStartCalled || this.m_cdataSectionStates.peekOrFalse()) {
            this.cdata(chars, start, length);
            return;
        }
        if (this.m_cdataTagOpen) {
            this.closeCDATA();
        }
        if (this.m_disableOutputEscapingStates.peekOrFalse() || !this.m_escaping) {
            this.charactersRaw(chars, start, length);
            if (this.m_tracer != null) {
                super.fireCharEvent(chars, start, length);
            }
            return;
        }
        if (this.m_startTagOpen) {
            this.closeStartTag();
            this.m_startTagOpen = false;
        }
        int startClean = start;
        int lengthClean = 0;
        int end = start + length;
        boolean checkWhite = true;
        int maxCharacter = this.m_maxCharacter;
        BitSet specialsMap = this.m_charInfo.m_specialsMap;
        try {
            int i = start;
            while (i < end) {
                char ch = chars[i];
                if (checkWhite && (ch > ' ' || ch != ' ' && ch != '\t' && ch != '\r' && ch != '\n')) {
                    this.m_ispreserve = true;
                    checkWhite = false;
                }
                if (ch < '\u007f' && (' ' <= ch || '\n' == ch || '\r' == ch || '\t' == ch) && !specialsMap.get(ch) || '\"' == ch) {
                    ++lengthClean;
                } else if (this.escapingNotNeeded(ch) && !specialsMap.get(ch) || '\"' == ch) {
                    ++lengthClean;
                } else {
                    if (lengthClean > 0) {
                        this.m_writer.write(chars, startClean, lengthClean);
                        lengthClean = 0;
                    }
                    if ('\n' == ch) {
                        this.m_writer.write(this.m_lineSep, 0, this.m_lineSepLen);
                        startClean = i + 1;
                    } else {
                        startClean = this.accumDefaultEscape(this.m_writer, ch, i, chars, end, false);
                        i = startClean - 1;
                    }
                }
                ++i;
            }
            if (lengthClean > 0) {
                this.m_writer.write(chars, startClean, lengthClean);
            }
            this.m_isprevtext = true;
        }
        catch (IOException e) {
            throw new SAXException(e);
        }
        if (this.m_tracer != null) {
            super.fireCharEvent(chars, start, length);
        }
    }

    public void characters(String s) throws SAXException {
        this.characters(s.toCharArray(), 0, s.length());
    }

    protected int accumDefaultEscape(Writer writer, char ch, int i, char[] chars, int len, boolean escLF) throws IOException {
        int pos = this.accumDefaultEntity(writer, ch, i, chars, len, escLF);
        if (i == pos) {
            ++pos;
            if ('\ud800' <= ch && ch < '\udc00') {
                int next;
                if (i + 1 >= len) {
                    throw new IOException(XMLMessages.createXMLMessage("ER_INVALID_UTF16_SURROGATE", new Object[]{Integer.toHexString(ch)}));
                }
                if (56320 > (next = chars[++i]) || next >= 57344) {
                    throw new IOException(XMLMessages.createXMLMessage("ER_INVALID_UTF16_SURROGATE", new Object[]{Integer.toHexString(ch) + " " + Integer.toHexString(next)}));
                }
                next = (ch - 55296 << 10) + next - 56320 + 65536;
                writer.write("&#");
                writer.write(Integer.toString(next));
                writer.write(";");
            } else if (!this.escapingNotNeeded(ch) || this.m_charInfo.isSpecial(ch)) {
                writer.write("&#");
                writer.write(Integer.toString(ch));
                writer.write(";");
            } else {
                writer.write(ch);
            }
        }
        return pos;
    }

    public void startElement(String namespaceURI, String localName, String name, Attributes atts) throws SAXException {
        if (this.m_inEntityRef) {
            return;
        }
        if (this.m_needToCallStartDocument) {
            this.startDocumentInternal();
            this.m_needToCallStartDocument = false;
        } else if (this.m_cdataTagOpen) {
            this.closeCDATA();
        }
        try {
            if (this.m_needToOutputDocTypeDecl && null != this.getDoctypeSystem()) {
                this.outputDocTypeDecl(name, true);
            }
            this.m_needToOutputDocTypeDecl = false;
            if (this.m_startTagOpen) {
                this.closeStartTag();
                this.m_startTagOpen = false;
            }
            if (namespaceURI != null) {
                this.ensurePrefixIsDeclared(namespaceURI, name);
            }
            this.m_elementLocalName = localName;
            this.m_elementURI = namespaceURI;
            this.m_elementName = name;
            this.m_ispreserve = false;
            if (this.shouldIndent() && this.m_startNewLine) {
                this.indent();
            }
            this.m_startNewLine = true;
            this.m_writer.write(60);
            this.m_writer.write(name);
        }
        catch (IOException e) {
            throw new SAXException(e);
        }
        if (atts != null) {
            this.addAttributes(atts);
        }
        this.m_startTagOpen = true;
        ++this.m_currentElemDepth;
        this.m_isprevtext = false;
    }

    public void startElement(String elementNamespaceURI, String elementLocalName, String elementName) throws SAXException {
        this.startElement(elementNamespaceURI, elementLocalName, elementName, null);
    }

    public void startElement(String elementName) throws SAXException {
        this.startElement(null, null, elementName, null);
    }

    void outputDocTypeDecl(String name, boolean closeDecl) throws SAXException {
        if (this.m_cdataTagOpen) {
            this.closeCDATA();
        }
        try {
            boolean dothis;
            String doctypeSystem;
            this.m_writer.write("<!DOCTYPE ");
            this.m_writer.write(name);
            String doctypePublic = this.getDoctypePublic();
            if (null != doctypePublic) {
                this.m_writer.write(" PUBLIC \"");
                this.m_writer.write(doctypePublic);
                this.m_writer.write(34);
            }
            if (null != (doctypeSystem = this.getDoctypeSystem())) {
                if (null == doctypePublic) {
                    this.m_writer.write(" SYSTEM \"");
                } else {
                    this.m_writer.write(" \"");
                }
                this.m_writer.write(doctypeSystem);
                if (closeDecl) {
                    this.m_writer.write("\">");
                    this.m_writer.write(this.m_lineSep, 0, this.m_lineSepLen);
                    closeDecl = false;
                } else {
                    this.m_writer.write(34);
                }
            }
            if ((dothis = false) && closeDecl) {
                this.m_writer.write(">");
                this.m_writer.write(this.m_lineSep, 0, this.m_lineSepLen);
            }
        }
        catch (IOException e) {
            throw new SAXException(e);
        }
    }

    public void processAttributes(int nAttrs) throws IOException, SAXException {
        String encoding = this.getEncoding();
        int i = 0;
        while (i < nAttrs) {
            String name = this.m_attributes.getQName(i);
            String value = this.m_attributes.getValue(i);
            this.m_writer.write(32);
            this.m_writer.write(name);
            this.m_writer.write("=\"");
            this.writeAttrString(this.m_writer, value, encoding);
            this.m_writer.write(34);
            ++i;
        }
        this.m_attributes.clear();
    }

    public void writeAttrString(Writer writer, String string, String encoding) throws IOException {
        char[] stringChars = string.toCharArray();
        int len = stringChars.length;
        int i = 0;
        while (i < len) {
            char ch = stringChars[i];
            if (this.escapingNotNeeded(ch) && !this.m_charInfo.isSpecial(ch)) {
                writer.write(ch);
            } else {
                if (CharInfo.S_CARRIAGERETURN == ch && i + 1 < len && '\n' == stringChars[i + 1]) {
                    ++i;
                    ch = '\n';
                }
                this.accumDefaultEscape(writer, ch, i, stringChars, len, true);
            }
            ++i;
        }
    }

    public void endElement(String namespaceURI, String localName, String name) throws SAXException {
        if (this.m_inEntityRef) {
            return;
        }
        this.m_prefixMap.popNamespaces(this.m_currentElemDepth);
        --this.m_currentElemDepth;
        try {
            if (this.m_startTagOpen) {
                int nAttrs;
                if (this.m_tracer != null) {
                    super.fireStartElem(this.m_elementName);
                }
                if ((nAttrs = this.m_attributes.getLength()) > 0) {
                    this.processAttributes(nAttrs);
                }
                if (this.m_spaceBeforeClose) {
                    this.m_writer.write(" />");
                } else {
                    this.m_writer.write("/>");
                }
            } else {
                if (this.m_cdataTagOpen) {
                    this.closeCDATA();
                }
                if (this.shouldIndent()) {
                    this.indent();
                }
                this.m_writer.write(60);
                this.m_writer.write(47);
                this.m_writer.write(name);
                this.m_writer.write(62);
                if (this.m_cdataSectionElements != null) {
                    this.m_cdataSectionStates.pop();
                }
            }
        }
        catch (IOException e) {
            throw new SAXException(e);
        }
        if (!this.m_startTagOpen && this.m_doIndent) {
            this.m_ispreserve = this.m_preserves.isEmpty() ? false : this.m_preserves.pop();
        }
        this.m_isprevtext = false;
        this.m_startTagOpen = false;
        this.m_elementURI = null;
        this.m_elementLocalName = null;
        if (this.m_tracer != null) {
            super.fireEndElem(name);
        }
    }

    public void endElement(String name) throws SAXException {
        this.endElement(null, null, name);
    }

    public void startPrefixMapping(String prefix, String uri) throws SAXException {
        this.startPrefixMapping(prefix, uri, true);
    }

    public boolean startPrefixMapping(String prefix, String uri, boolean shouldFlush) throws SAXException {
        int pushDepth;
        if (shouldFlush) {
            this.flushPending();
            pushDepth = this.m_currentElemDepth + 1;
        } else {
            pushDepth = this.m_currentElemDepth;
        }
        boolean pushed = this.m_prefixMap.pushNamespace(prefix, uri, pushDepth);
        if (pushed) {
            if ("".equals(prefix)) {
                String name = "xmlns";
                this.addAttributeAlways("http://www.w3.org/2000/xmlns/", prefix, name, "CDATA", uri);
            } else if (!"".equals(uri)) {
                String name = "xmlns:" + prefix;
                this.addAttributeAlways("http://www.w3.org/2000/xmlns/", prefix, name, "CDATA", uri);
            }
        }
        return pushed;
    }

    public void comment(char[] ch, int start, int length) throws SAXException {
        int start_old = start;
        if (this.m_inEntityRef) {
            return;
        }
        if (this.m_startTagOpen) {
            this.closeStartTag();
            this.m_startTagOpen = false;
        } else if (this.m_needToCallStartDocument) {
            this.startDocumentInternal();
            this.m_needToCallStartDocument = false;
        }
        try {
            if (this.shouldIndent()) {
                this.indent();
            }
            int limit = start + length;
            boolean wasDash = false;
            if (this.m_cdataTagOpen) {
                this.closeCDATA();
            }
            this.m_writer.write(COMMENT_BEGIN);
            int i = start;
            while (i < limit) {
                if (wasDash && ch[i] == '-') {
                    this.m_writer.write(ch, start, i - start);
                    this.m_writer.write(" -");
                    start = i + 1;
                }
                wasDash = ch[i] == '-';
                ++i;
            }
            if (length > 0) {
                int remainingChars = limit - start;
                if (remainingChars > 0) {
                    this.m_writer.write(ch, start, remainingChars);
                }
                if (ch[limit - 1] == '-') {
                    this.m_writer.write(32);
                }
            }
            this.m_writer.write(COMMENT_END);
        }
        catch (IOException e) {
            throw new SAXException(e);
        }
        this.m_startNewLine = true;
        if (this.m_tracer != null) {
            super.fireCommentEvent(ch, start_old, length);
        }
    }

    public void endCDATA() throws SAXException {
        if (this.m_cdataTagOpen) {
            this.closeCDATA();
        }
        this.m_cdataStartCalled = false;
    }

    public void endDTD() throws SAXException {
        try {
            if (this.m_needToOutputDocTypeDecl) {
                this.outputDocTypeDecl(this.m_elementName, false);
                this.m_needToOutputDocTypeDecl = false;
            }
            if (!this.m_inDoctype) {
                this.m_writer.write("]>");
            } else {
                this.m_writer.write(62);
            }
            this.m_writer.write(this.m_lineSep, 0, this.m_lineSepLen);
        }
        catch (IOException e) {
            throw new SAXException(e);
        }
    }

    public void endPrefixMapping(String prefix) throws SAXException {
    }

    public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
        if (0 == length) {
            return;
        }
        this.characters(ch, start, length);
    }

    public void skippedEntity(String name) throws SAXException {
    }

    public void startCDATA() throws SAXException {
        this.m_cdataStartCalled = true;
    }

    public void startEntity(String name) throws SAXException {
        if (name.equals("[dtd]")) {
            this.m_inExternalDTD = true;
        }
        this.m_inEntityRef = true;
    }

    protected void closeStartTag() throws SAXException {
        if (this.m_startTagOpen) {
            try {
                int nAttrs;
                if (this.m_tracer != null) {
                    super.fireStartElem(this.m_elementName);
                }
                if ((nAttrs = this.m_attributes.getLength()) > 0) {
                    this.processAttributes(nAttrs);
                }
                this.m_writer.write(62);
            }
            catch (IOException e) {
                throw new SAXException(e);
            }
            if (this.m_cdataSectionElements != null) {
                this.pushCdataSectionState();
            }
            if (this.m_doIndent) {
                this.m_isprevtext = false;
                this.m_preserves.push(this.m_ispreserve);
            }
        }
    }

    public void startDTD(String name, String publicId, String systemId) throws SAXException {
        this.setDoctypeSystem(systemId);
        this.setDoctypePublic(publicId);
        this.m_elementName = name;
        this.m_inDoctype = true;
    }

    public int getIndentAmount() {
        return this.m_indentAmount;
    }

    public void setIndentAmount(int m_indentAmount) {
        this.m_indentAmount = m_indentAmount;
    }

    protected boolean shouldIndent() {
        return this.m_doIndent && !this.m_ispreserve && !this.m_isprevtext;
    }

    private void setCdataSectionElements(String key, Properties props) {
        block6: {
            String s = props.getProperty(key);
            if (null == s) break block6;
            Vector v = new Vector();
            int l = s.length();
            boolean inCurly = false;
            FastStringBuffer buf = new FastStringBuffer();
            int i = 0;
            while (i < l) {
                block9: {
                    char c;
                    block8: {
                        block7: {
                            c = s.charAt(i);
                            if (!Character.isWhitespace(c)) break block7;
                            if (inCurly) break block8;
                            if (buf.length() > 0) {
                                this.addCdataSectionElement(buf.toString(), v);
                                buf.reset();
                            }
                            break block9;
                        }
                        if ('{' == c) {
                            inCurly = true;
                        } else if ('}' == c) {
                            inCurly = false;
                        }
                    }
                    buf.append(c);
                }
                ++i;
            }
            if (buf.length() > 0) {
                this.addCdataSectionElement(buf.toString(), v);
                buf.reset();
            }
            this.setCdataSectionElements(v);
        }
    }

    private void addCdataSectionElement(String URI_and_localName, Vector v) {
        String s2;
        StringTokenizer tokenizer = new StringTokenizer(URI_and_localName, "{}", false);
        String s1 = tokenizer.nextToken();
        String string = s2 = tokenizer.hasMoreTokens() ? tokenizer.nextToken() : null;
        if (null == s2) {
            v.addElement(null);
            v.addElement(s1);
        } else {
            v.addElement(s1);
            v.addElement(s2);
        }
    }

    public void setCdataSectionElements(Vector URI_and_localNames) {
        this.m_cdataSectionElements = URI_and_localNames;
    }

    protected String ensureAttributesNamespaceIsDeclared(String ns, String localName, String rawName) throws SAXException {
        if (ns != null && ns.length() > 0) {
            String prefixFromRawName;
            int index = 0;
            index = rawName.indexOf(":");
            String string = prefixFromRawName = index < 0 ? "" : rawName.substring(0, index);
            if (index > 0) {
                String uri = this.m_prefixMap.lookupNamespace(prefixFromRawName);
                if (uri != null && uri.equals(ns)) {
                    return null;
                }
                this.startPrefixMapping(prefixFromRawName, ns, false);
                this.addAttribute("http://www.w3.org/2000/xmlns/", prefixFromRawName, "xmlns:" + prefixFromRawName, "CDATA", ns);
                return prefixFromRawName;
            }
            String prefix = this.m_prefixMap.lookupPrefix(ns);
            if (prefix == null) {
                prefix = this.m_prefixMap.generateNextPrefix();
                this.startPrefixMapping(prefix, ns, false);
                this.addAttribute("http://www.w3.org/2000/xmlns/", prefix, "xmlns:" + prefix, "CDATA", ns);
            }
            return prefix;
        }
        return null;
    }

    private void ensurePrefixIsDeclared(String ns, String rawName) throws SAXException {
        if (ns != null && ns.length() > 0) {
            String foundURI;
            String prefix;
            int index = rawName.indexOf(":");
            String string = prefix = index < 0 ? "" : rawName.substring(0, index);
            if (!(null == prefix || null != (foundURI = this.m_prefixMap.lookupNamespace(prefix)) && foundURI.equals(ns))) {
                this.startPrefixMapping(prefix, ns);
                this.addAttributeAlways("http://www.w3.org/2000/xmlns/", prefix, "xmlns" + (prefix.length() == 0 ? "" : ":") + prefix, "CDATA", ns);
            }
        }
    }

    public void flushPending() {
        try {
            if (this.m_needToCallStartDocument) {
                this.startDocumentInternal();
                this.m_needToCallStartDocument = false;
            }
            if (this.m_startTagOpen) {
                this.closeStartTag();
                this.m_startTagOpen = false;
            }
            if (this.m_cdataTagOpen) {
                this.closeCDATA();
                this.m_cdataTagOpen = false;
            }
        }
        catch (SAXException sAXException) {
            // empty catch block
        }
    }

    public void setContentHandler(ContentHandler ch) {
    }

    public void addAttributeAlways(String uri, String localName, String rawName, String type, String value) {
        int index = this.m_attributes.getIndex(rawName);
        if (index >= 0) {
            String old_value = null;
            if (this.m_tracer != null && value.equals(old_value = this.m_attributes.getValue(index))) {
                old_value = null;
            }
            this.m_attributes.setValue(index, value);
            if (old_value != null) {
                this.firePseudoAttributes();
            }
        } else {
            this.m_attributes.addAttribute(uri, localName, rawName, type, value);
            if (this.m_tracer != null) {
                this.firePseudoAttributes();
            }
        }
    }

    protected void firePseudoAttributes() {
        int nAttrs;
        if (this.m_tracer != null && (nAttrs = this.m_attributes.getLength()) > 0) {
            String encoding = this.getEncoding();
            StringBuffer sb = new StringBuffer();
            WritertoStringBuffer writer = new WritertoStringBuffer(sb);
            try {
                int i = 0;
                while (i < nAttrs) {
                    String name = this.m_attributes.getQName(i);
                    String value = this.m_attributes.getValue(i);
                    sb.append(' ');
                    sb.append(name);
                    sb.append("=\"");
                    this.writeAttrString(writer, value, encoding);
                    sb.append('\"');
                    ++i;
                }
            }
            catch (IOException ioe) {
                // empty catch block
            }
            char[] ch = sb.toString().toCharArray();
            this.m_tracer.fireGenerateEvent(11, ch, 0, ch.length);
        }
    }

    public void setTransformer(Transformer transformer) {
        super.setTransformer(transformer);
        if (this.m_tracer != null && !(this.m_writer instanceof SerializerTraceWriter)) {
            this.m_writer = new SerializerTraceWriter(this.m_writer, this.m_tracer);
        }
    }

    public boolean reset() {
        boolean wasReset = false;
        if (super.reset()) {
            this.resetToStream();
            wasReset = true;
        }
        return wasReset;
    }

    private void resetToStream() {
        this.m_canConvertMeth = null;
        this.m_cdataStartCalled = false;
        this.m_charInfo = null;
        this.m_charToByteConverter = null;
        this.m_disableOutputEscapingStates.clear();
        this.m_escaping = false;
        this.m_inDoctype = false;
        this.m_ispreserve = false;
        this.m_ispreserve = false;
        this.m_isprevtext = false;
        this.m_isUTF8 = false;
        this.m_maxCharacter = Encodings.getLastPrintable();
        this.m_preserves.clear();
        this.m_shouldFlush = true;
        this.m_spaceBeforeClose = false;
        this.m_startNewLine = false;
        this.m_triedToGetConverter = false;
    }

    private class WritertoStringBuffer
    extends Writer {
        private final StringBuffer m_stringbuf;

        WritertoStringBuffer(StringBuffer sb) {
            this.m_stringbuf = sb;
        }

        public void write(char[] arg0, int arg1, int arg2) throws IOException {
            this.m_stringbuf.append(arg0, arg1, arg2);
        }

        public void flush() throws IOException {
        }

        public void close() throws IOException {
        }

        public void write(int i) {
            this.m_stringbuf.append((char)i);
        }

        public void write(String s) {
            this.m_stringbuf.append(s);
        }
    }
}

