/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.provision.detector.ssh.client;

import java.io.IOException;
import java.net.InetAddress;
import java.util.HashMap;
import java.util.Map;
import org.opennms.netmgt.provision.detector.ssh.request.NullRequest;
import org.opennms.netmgt.provision.detector.ssh.response.SshResponse;
import org.opennms.netmgt.provision.support.Client;
import org.opennms.netmgt.provision.support.ssh.SshMonitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SshClient
implements Client<NullRequest, SshResponse> {
    private boolean m_isAvailable = false;
    private Map<String, Object> m_parameters = new HashMap<String, Object>();

    public void close() {
    }

    public void connect(InetAddress address, int port, int timeout) throws IOException, Exception {
        SshMonitor m = new SshMonitor();
        this.m_parameters.put("port", port);
        this.m_isAvailable = m.poll(address, this.m_parameters).isAvailable();
    }

    public SshResponse receiveBanner() throws IOException, Exception {
        SshResponse response = new SshResponse();
        response.receive(this.m_isAvailable);
        return response;
    }

    public SshResponse sendRequest(NullRequest request) throws IOException, Exception {
        return null;
    }

    public void setBanner(String banner) {
        this.m_parameters.put("banner", banner);
    }

    public void setMatch(String match) {
        this.m_parameters.put("match", match);
    }

    public void setClientBanner(String clientBanner) {
        this.m_parameters.put("client-banner", clientBanner);
    }
}

