/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.reporting.jasperreports.svclayer;

import java.io.OutputStream;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import net.sf.jasperreports.engine.JRDataSource;
import net.sf.jasperreports.engine.JREmptyDataSource;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRExporterParameter;
import net.sf.jasperreports.engine.JasperCompileManager;
import net.sf.jasperreports.engine.JasperExportManager;
import net.sf.jasperreports.engine.JasperFillManager;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.JasperReport;
import net.sf.jasperreports.engine.export.JRXmlExporter;
import net.sf.jasperreports.engine.xml.JRPrintXmlLoader;
import org.opennms.api.reporting.ReportException;
import org.opennms.api.reporting.ReportFormat;
import org.opennms.api.reporting.ReportService;
import org.opennms.api.reporting.parameter.ReportParameters;
import org.opennms.core.utils.ThreadCategory;
import org.opennms.netmgt.config.DataSourceFactory;
import org.opennms.netmgt.dao.JasperReportConfigDao;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JasperReportService
implements ReportService {
    private static final String LOG4J_CATEGORY = "OpenNMS.Report";
    private JasperReportConfigDao m_jasperReportConfigDao;
    private final ThreadCategory log;

    public JasperReportService() {
        String oldPrefix = ThreadCategory.getPrefix();
        ThreadCategory.setPrefix((String)LOG4J_CATEGORY);
        this.log = ThreadCategory.getInstance(JasperReportService.class);
        ThreadCategory.setPrefix((String)oldPrefix);
    }

    public List<ReportFormat> getFormats(String reportId) {
        ArrayList<ReportFormat> formats = new ArrayList<ReportFormat>();
        formats.add(ReportFormat.PDF);
        return formats;
    }

    public ReportParameters getParameters(String ReportId) {
        return new ReportParameters();
    }

    public void render(String ReportId, String location, ReportFormat format, OutputStream outputStream) throws ReportException {
        try {
            JasperPrint jasperPrint = JRPrintXmlLoader.load((String)location);
            switch (format) {
                case PDF: {
                    this.log.debug("rendering as PDF");
                    JasperExportManager.exportReportToPdfStream((JasperPrint)jasperPrint, (OutputStream)outputStream);
                    break;
                }
                default: {
                    this.log.debug("rendering as PDF as no valid format found");
                    JasperExportManager.exportReportToPdfStream((JasperPrint)jasperPrint, (OutputStream)outputStream);
                    break;
                }
            }
        }
        catch (JRException e) {
            this.log.error("unable to render report", (Throwable)e);
            throw new ReportException("unable to render report", (Throwable)e);
        }
    }

    public String run(HashMap<String, Object> reportParms, String reportId) throws ReportException {
        String baseDir = System.getProperty("opennms.report.dir");
        JasperReport jasperReport = null;
        JasperPrint jasperPrint = null;
        String outputFileName = null;
        String sourceFileName = this.m_jasperReportConfigDao.getTemplateLocation(reportId);
        if (sourceFileName != null) {
            try {
                jasperReport = JasperCompileManager.compileReport((String)(System.getProperty("opennms.home") + "/etc/report-templates/" + sourceFileName));
            }
            catch (JRException e) {
                this.log.error("unable to compile jasper report", (Throwable)e);
                throw new ReportException("unable to compile jasperReport", (Throwable)e);
            }
            outputFileName = new String(baseDir + "/" + jasperReport.getName() + ".jrpxml");
            this.log.debug("jrpcml output file: " + outputFileName);
            if (this.m_jasperReportConfigDao.getEngine(reportId).equals("jdbc")) {
                try {
                    Connection connection = DataSourceFactory.getDataSource().getConnection();
                    jasperPrint = JasperFillManager.fillReport((JasperReport)jasperReport, reportParms, (Connection)connection);
                    JRXmlExporter exporter = new JRXmlExporter();
                    exporter.setParameter(JRExporterParameter.JASPER_PRINT, (Object)jasperPrint);
                    exporter.setParameter(JRExporterParameter.OUTPUT_FILE_NAME, (Object)outputFileName);
                    exporter.exportReport();
                    connection.close();
                }
                catch (SQLException e) {
                    this.log.error("sql exception getting or closing datasource ", (Throwable)e);
                    throw new ReportException("sql exception getting or closing datasource", (Throwable)e);
                }
                catch (JRException e) {
                    this.log.error("jasper report exception ", (Throwable)e);
                    throw new ReportException("unable to run emptyDataSource jasperReport", (Throwable)e);
                }
            } else if (this.m_jasperReportConfigDao.getEngine(reportId).equals("null")) {
                try {
                    jasperPrint = JasperFillManager.fillReport((JasperReport)jasperReport, reportParms, (JRDataSource)new JREmptyDataSource());
                    JRXmlExporter exporter = new JRXmlExporter();
                    exporter.setParameter(JRExporterParameter.JASPER_PRINT, (Object)jasperPrint);
                    exporter.setParameter(JRExporterParameter.OUTPUT_FILE_NAME, (Object)outputFileName);
                    exporter.exportReport();
                }
                catch (JRException e) {
                    this.log.error("jasper report exception ", (Throwable)e);
                    throw new ReportException("unable to run emptyDataSource jasperReport", (Throwable)e);
                }
            } else {
                throw new ReportException("no suitable datasource configured for reportId: " + reportId);
            }
        }
        return outputFileName;
    }

    public void runAndRender(HashMap<String, Object> reportParms, String reportId, ReportFormat format, OutputStream outputStream) throws ReportException {
        JasperReport jasperReport = null;
        JasperPrint jasperPrint = null;
        String sourceFileName = this.m_jasperReportConfigDao.getTemplateLocation(reportId);
        if (sourceFileName != null) {
            try {
                jasperReport = JasperCompileManager.compileReport((String)(System.getProperty("opennms.home") + "/etc/report-templates/" + sourceFileName));
            }
            catch (JRException e) {
                this.log.error("unable to compile jasper report", (Throwable)e);
                throw new ReportException("unable to compile jasperReport", (Throwable)e);
            }
            if (this.m_jasperReportConfigDao.getEngine(reportId).equals("jdbc")) {
                try {
                    Connection connection = DataSourceFactory.getDataSource().getConnection();
                    jasperPrint = JasperFillManager.fillReport((JasperReport)jasperReport, reportParms, (Connection)connection);
                    JasperExportManager.exportReportToPdfStream((JasperPrint)jasperPrint, (OutputStream)outputStream);
                    connection.close();
                }
                catch (SQLException e) {
                    this.log.error("sql exception getting or closing datasource ", (Throwable)e);
                    throw new ReportException("sql exception getting or closing datasource", (Throwable)e);
                }
                catch (JRException e) {
                    this.log.error("jasper report exception ", (Throwable)e);
                    throw new ReportException("unable to run or render jdbc jasperReport", (Throwable)e);
                }
            }
            if (this.m_jasperReportConfigDao.getEngine(reportId).equals("null")) {
                try {
                    jasperPrint = JasperFillManager.fillReport((JasperReport)jasperReport, reportParms, (JRDataSource)new JREmptyDataSource());
                    JasperExportManager.exportReportToPdfStream((JasperPrint)jasperPrint, (OutputStream)outputStream);
                }
                catch (JRException e) {
                    this.log.error("jasper report exception ", (Throwable)e);
                    throw new ReportException("unable to run or render emptyDataSource jasperReport", (Throwable)e);
                }
            }
        }
    }

    public boolean validate(HashMap<String, Object> reportParms, String reportId) {
        return true;
    }

    public void setConfigDao(JasperReportConfigDao jasperReportConfigDao) {
        this.m_jasperReportConfigDao = jasperReportConfigDao;
    }
}

