/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.api.reporting.parameter;

import java.io.Serializable;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import org.opennms.api.reporting.ReportFormat;
import org.opennms.api.reporting.parameter.ReportDateParm;
import org.opennms.api.reporting.parameter.ReportIntParm;
import org.opennms.api.reporting.parameter.ReportStringParm;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReportParameters
implements Serializable {
    private static final long serialVersionUID = -3848794546173077375L;
    protected String m_reportId;
    protected ReportFormat m_format;
    protected String m_displayName;
    protected List<ReportDateParm> m_dateParms;
    protected List<ReportStringParm> m_stringParms;
    protected List<ReportIntParm> m_intParms;

    public List<ReportDateParm> getDateParms() {
        return this.m_dateParms;
    }

    public void setDateParms(List<ReportDateParm> dateParms) {
        this.m_dateParms = dateParms;
    }

    public List<ReportStringParm> getStringParms() {
        return this.m_stringParms;
    }

    public void setStringParms(List<ReportStringParm> strings) {
        this.m_stringParms = strings;
    }

    public List<ReportIntParm> getIntParms() {
        return this.m_intParms;
    }

    public void setIntParms(List<ReportIntParm> ints) {
        this.m_intParms = ints;
    }

    public void setReportId(String reportId) {
        this.m_reportId = reportId;
    }

    public String getReportId() {
        return this.m_reportId;
    }

    public void setDisplayName(String displayName) {
        this.m_displayName = displayName;
    }

    public String getDisplayName() {
        return this.m_displayName;
    }

    public void setFormat(ReportFormat format) {
        this.m_format = format;
    }

    public ReportFormat getFormat() {
        return this.m_format;
    }

    public HashMap<String, Object> getReportParms() {
        HashMap<String, Object> parmMap = new HashMap<String, Object>();
        if (this.m_stringParms != null) {
            for (ReportStringParm reportStringParm : this.m_stringParms) {
                parmMap.put(reportStringParm.getName(), reportStringParm.getValue());
            }
        }
        if (this.m_dateParms != null) {
            for (ReportDateParm reportDateParm : this.m_dateParms) {
                Calendar cal = Calendar.getInstance();
                if (reportDateParm.getUseAbsoluteDate().booleanValue()) {
                    cal.setTime(reportDateParm.getValue());
                } else {
                    int amount = 0 - reportDateParm.getCount();
                    if (reportDateParm.getInterval().equals("year")) {
                        cal.add(1, amount);
                    } else if (reportDateParm.getInterval().equals("month")) {
                        cal.add(2, amount);
                    } else {
                        cal.add(5, amount);
                    }
                }
                cal.set(11, reportDateParm.getHours());
                cal.set(12, reportDateParm.getMinutes());
                cal.set(13, 0);
                cal.set(14, 0);
                parmMap.put(reportDateParm.getName(), cal.getTime());
            }
        }
        if (this.m_intParms != null) {
            for (ReportIntParm reportIntParm : this.m_intParms) {
                parmMap.put(reportIntParm.getName(), reportIntParm.getValue());
            }
        }
        return parmMap;
    }
}

