/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.web.category;

import java.io.IOException;
import java.util.Date;
import org.exolab.castor.xml.MarshalException;
import org.exolab.castor.xml.ValidationException;
import org.opennms.core.resource.Vault;
import org.opennms.core.utils.ThreadCategory;
import org.opennms.netmgt.EventConstants;
import org.opennms.netmgt.config.ViewsDisplayFactory;
import org.opennms.netmgt.config.viewsdisplay.Section;
import org.opennms.netmgt.config.viewsdisplay.View;
import org.opennms.netmgt.model.events.EventProxy;
import org.opennms.netmgt.model.events.EventProxyException;
import org.opennms.netmgt.xml.event.Event;
import org.opennms.netmgt.xml.event.Parm;
import org.opennms.netmgt.xml.event.Parms;
import org.opennms.netmgt.xml.event.Value;
import org.opennms.web.api.Util;

public class RTCPostSubscriber {
    protected EventProxy m_proxy = Util.createEventProxy();
    protected String m_url;
    protected String m_username = "rtc";
    protected String m_password = "rtc";
    protected static ThreadCategory log = ThreadCategory.getInstance((String)"RTC");

    public static void sendSubscribeEvent(EventProxy proxy, String url, String username, String password, String categoryName) throws IllegalArgumentException, EventProxyException {
        if (proxy == null || url == null || username == null || password == null || categoryName == null) {
            throw new IllegalArgumentException("Cannot take null parameters.");
        }
        Event event = new Event();
        event.setSource("RTCPostSubscriber");
        event.setUei("uei.opennms.org/internal/rtc/subscribe");
        event.setHost("host");
        event.setTime(EventConstants.formatToString((Date)new Date()));
        Parms parms = new Parms();
        Value value = new Value();
        value.setContent(url);
        Parm parm = new Parm();
        parm.setParmName("url");
        parm.setValue(value);
        parms.addParm(parm);
        value = new Value();
        value.setContent(username);
        parm = new Parm();
        parm.setParmName("user");
        parm.setValue(value);
        parms.addParm(parm);
        value = new Value();
        value.setContent(password);
        parm = new Parm();
        parm.setParmName("passwd");
        parm.setValue(value);
        parms.addParm(parm);
        value = new Value();
        value.setContent(categoryName);
        parm = new Parm();
        parm.setParmName("catlabel");
        parm.setValue(value);
        parms.addParm(parm);
        event.setParms(parms);
        proxy.send(event);
        log.info("Subscription requested for " + username + " to " + url);
    }

    public static void sendUnsubscribeEvent(EventProxy proxy, String url) throws IllegalArgumentException, EventProxyException {
        if (proxy == null || url == null) {
            throw new IllegalArgumentException("Cannot take null parameters.");
        }
        Event event = new Event();
        event.setSource("RTCPostSubscriber");
        event.setUei("uei.opennms.org/internal/rtc/unsubscribe");
        event.setHost("host");
        event.setTime(EventConstants.formatToString((Date)new Date()));
        Parms parms = new Parms();
        Value value = new Value();
        value.setContent(url);
        Parm parm = new Parm();
        parm.setParmName("url");
        parm.setValue(value);
        parms.addParm(parm);
        event.setParms(parms);
        proxy.send(event);
        log.info("Unsubscription sent for " + url);
    }

    public String subscribe(String categoryName) throws IllegalArgumentException, EventProxyException {
        if (categoryName == null) {
            throw new IllegalArgumentException("Cannot take null parameters.");
        }
        this.initFromRtcPropertyFile(categoryName);
        RTCPostSubscriber.sendSubscribeEvent(this.m_proxy, this.m_url, this.m_username, this.m_password, categoryName);
        return this.m_url;
    }

    public void unsubscribe() throws IllegalArgumentException, EventProxyException {
        RTCPostSubscriber.sendUnsubscribeEvent(this.m_proxy, this.m_url);
    }

    public void close() {
        this.m_proxy = null;
    }

    protected void initFromRtcPropertyFile(String categoryName) {
        String baseUrl;
        String password;
        if (categoryName == null) {
            throw new IllegalArgumentException("categoryName can not be null");
        }
        String username = Vault.getProperty((String)"opennms.rtc-client.http-post.username");
        if (username != null) {
            this.m_username = username;
        }
        if ((password = Vault.getProperty((String)"opennms.rtc-client.http-post.password")) != null) {
            this.m_password = password;
        }
        if ((baseUrl = Vault.getProperty((String)"opennms.rtc-client.http-post.base-url")) == null) {
            baseUrl = "http://localhost:8080/opennms/rtc/post";
        }
        this.m_url = baseUrl.endsWith("/") ? baseUrl + Util.encode(categoryName) : baseUrl + "/" + Util.encode(categoryName);
        log.debug("RTCPostSubscriber initialized: url=" + this.m_url + ", user=" + this.m_username);
    }

    public static void subscribeAll(String viewName) throws IOException, MarshalException, ValidationException, EventProxyException {
        if (viewName == null) {
            throw new IllegalArgumentException("Cannot take null parameters.");
        }
        ViewsDisplayFactory.init();
        ViewsDisplayFactory factory = ViewsDisplayFactory.getInstance();
        View view = factory.getView(viewName);
        if (view != null) {
            Section[] sections = view.getSection();
            RTCPostSubscriber subscriber = new RTCPostSubscriber();
            for (int i = 0; i < sections.length; ++i) {
                Section section = sections[i];
                String[] categories = section.getCategory();
                for (int j = 0; j < categories.length; ++j) {
                    subscriber.subscribe(categories[j]);
                    log.info("Sent subscription event to RTC for category: " + categories[j]);
                }
            }
            subscriber.close();
        }
    }
}

