/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.web.category;

import java.io.IOException;
import java.util.Date;
import java.util.Enumeration;
import org.exolab.castor.xml.MarshalException;
import org.exolab.castor.xml.ValidationException;
import org.opennms.netmgt.xml.rtc.Node;
import org.opennms.web.category.CategoryUtil;

public class Category {
    protected org.opennms.netmgt.config.categories.Category m_categoryDef;
    protected org.opennms.netmgt.xml.rtc.Category m_rtcCategory;
    protected Date m_lastUpdated;
    protected Long m_serviceCount;
    protected Long m_serviceDownCount;
    protected Double m_servicePercentage;

    protected Category(String categoryName) {
        this.m_categoryDef = new org.opennms.netmgt.config.categories.Category();
        this.m_categoryDef.setLabel(categoryName);
    }

    protected Category(org.opennms.netmgt.config.categories.Category categoryDef, org.opennms.netmgt.xml.rtc.Category rtcCategory, Date lastUpdated) {
        if (categoryDef == null || rtcCategory == null || lastUpdated == null) {
            throw new IllegalArgumentException("Cannot take null parameters.");
        }
        if (categoryDef.getLabel() == null || !categoryDef.getLabel().equals(rtcCategory.getCatlabel())) {
            throw new IllegalArgumentException("Cannot take category definition and rtc category value whose names do not match.");
        }
        this.m_categoryDef = categoryDef;
        this.m_rtcCategory = rtcCategory;
        this.m_lastUpdated = lastUpdated;
        this.m_serviceCount = null;
        this.m_serviceDownCount = null;
    }

    public String getName() {
        return this.m_categoryDef.getLabel();
    }

    public double getNormalThreshold() {
        return this.m_categoryDef.getNormal();
    }

    public double getWarningThreshold() {
        return this.m_categoryDef.getWarning();
    }

    public String getComment() {
        return this.m_categoryDef.getComment();
    }

    public Date getLastUpdated() {
        return this.m_lastUpdated;
    }

    public double getValue() {
        if (this.m_rtcCategory == null) {
            return 0.0;
        }
        return this.m_rtcCategory.getCatvalue();
    }

    org.opennms.netmgt.xml.rtc.Category getRtcCategory() {
        return this.m_rtcCategory;
    }

    public long getServiceCount() {
        if (this.m_serviceCount == null) {
            if (this.m_rtcCategory == null) {
                this.m_serviceCount = new Long(0L);
                this.m_serviceDownCount = new Long(0L);
                this.m_servicePercentage = new Double(0.0);
            } else {
                long[] counts = Category.getServiceCounts(this.m_rtcCategory);
                this.m_serviceCount = new Long(counts[0]);
                this.m_serviceDownCount = new Long(counts[1]);
                this.m_servicePercentage = this.m_serviceCount == 0L ? new Double(100.0) : new Double((double)(this.m_serviceCount - this.m_serviceDownCount) / (double)this.m_serviceCount.longValue() * 100.0);
            }
        }
        return this.m_serviceCount;
    }

    public long getServiceDownCount() {
        if (this.m_serviceDownCount == null) {
            this.getServiceCount();
        }
        return this.m_serviceDownCount;
    }

    public double getServicePercentage() {
        if (this.m_servicePercentage == null) {
            this.getServiceCount();
        }
        return this.m_servicePercentage;
    }

    public String getOutageColor() throws IOException, MarshalException, ValidationException {
        if (this.m_lastUpdated == null) {
            return "lightblue";
        }
        return CategoryUtil.getCategoryColor(this, this.getServicePercentage());
    }

    public String getAvailColor() throws IOException, MarshalException, ValidationException {
        if (this.m_lastUpdated == null) {
            return "lightblue";
        }
        return CategoryUtil.getCategoryColor(this);
    }

    public String getOutageClass() throws IOException, MarshalException, ValidationException {
        if (this.m_lastUpdated == null) {
            return "lightblue";
        }
        return CategoryUtil.getCategoryClass(this, this.getServicePercentage());
    }

    public String getAvailClass() throws IOException, MarshalException, ValidationException {
        if (this.m_lastUpdated == null) {
            return "lightblue";
        }
        return CategoryUtil.getCategoryClass(this);
    }

    public String getOutageText() {
        if (this.m_lastUpdated == null) {
            return "Calculating...";
        }
        return this.getServiceDownCount() + " of " + this.getServiceCount();
    }

    public String getAvailText() {
        if (this.m_lastUpdated == null) {
            return "Calculating...";
        }
        return CategoryUtil.valueFormat.format(this.getValue()) + "%";
    }

    public String getTitle() {
        if (this.getComment() != null) {
            return this.getComment();
        }
        return this.getName();
    }

    public Enumeration enumerateNode() {
        return this.m_rtcCategory.enumerateNode();
    }

    protected static long[] getServiceCounts(org.opennms.netmgt.xml.rtc.Category category) {
        if (category == null) {
            throw new IllegalArgumentException("Cannot take null parameters.");
        }
        long count = 0L;
        long downCount = 0L;
        Enumeration nodeEnum = category.enumerateNode();
        while (nodeEnum.hasMoreElements()) {
            Node node = (Node)nodeEnum.nextElement();
            count += node.getNodesvccount();
            downCount += node.getNodesvcdowncount();
        }
        return new long[]{count, downCount};
    }
}

