/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.web;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.Properties;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.sql.DataSource;
import org.opennms.core.resource.Vault;
import org.opennms.core.resource.db.DbConnectionFactory;
import org.opennms.core.utils.ThreadCategory;
import org.opennms.netmgt.config.DataSourceFactory;

public class ServletInitializer {
    protected static DbConnectionFactory factory;

    private ServletInitializer() {
    }

    public static synchronized void init(ServletContext context) throws ServletException {
        if (context == null) {
            throw new IllegalArgumentException("Cannot take null parameters.");
        }
        ThreadCategory.setPrefix((String)"OpenNMS.WEB");
        if (factory == null) {
            Properties properties = new Properties(System.getProperties());
            try {
                if (properties.getProperty("opennms.home") == null) {
                    ServletInitializer.loadPropertiesFromContextResource(context, properties, "/WEB-INF/configuration.properties");
                    if (properties.getProperty("opennms.home") == null) {
                        throw new ServletException("The opennms.home context parameter must be set.");
                    }
                }
            }
            catch (IOException e) {
                throw new ServletException("Could not load configuration.properties", (Throwable)e);
            }
            String homeDir = properties.getProperty("opennms.home");
            Properties opennmsProperties = new Properties();
            try {
                ServletInitializer.loadPropertiesFromFile(opennmsProperties, homeDir + File.separator + "etc" + File.separator + "opennms.properties");
            }
            catch (IOException e) {
                throw new ServletException("Could not load opennms.properties", (Throwable)e);
            }
            try {
                ServletInitializer.loadPropertiesFromContextResource(context, opennmsProperties, "/WEB-INF/version.properties");
            }
            catch (IOException e) {
                throw new ServletException("Could not load version.properties", (Throwable)e);
            }
            Enumeration<Object> opennmsKeys = opennmsProperties.keys();
            while (opennmsKeys.hasMoreElements()) {
                Object key = opennmsKeys.nextElement();
                if (properties.containsKey(key)) continue;
                properties.put(key, opennmsProperties.get(key));
            }
            Enumeration initParamNames = context.getInitParameterNames();
            while (initParamNames.hasMoreElements()) {
                String name = (String)initParamNames.nextElement();
                properties.put(name, context.getInitParameter(name));
            }
            Vault.setProperties((Properties)properties);
            Vault.setHomeDir((String)homeDir);
            try {
                DataSourceFactory.init();
            }
            catch (Exception e) {
                throw new ServletException("Could not initialize data source factory: " + e, (Throwable)e);
            }
            Vault.setDataSource((DataSource)DataSourceFactory.getInstance());
        }
    }

    private static void loadPropertiesFromFile(Properties opennmsProperties, String propertiesFile) throws FileNotFoundException, ServletException, IOException {
        FileInputStream configurationStream = new FileInputStream(propertiesFile);
        if (configurationStream == null) {
            throw new ServletException("Could not load properties from file '" + propertiesFile + "'");
        }
        opennmsProperties.load(configurationStream);
        ((InputStream)configurationStream).close();
    }

    private static void loadPropertiesFromContextResource(ServletContext context, Properties properties, String propertiesResource) throws ServletException, IOException {
        InputStream configurationStream = context.getResourceAsStream(propertiesResource);
        if (configurationStream == null) {
            throw new ServletException("Could not load properties from resource '" + propertiesResource + "'");
        }
        properties.load(configurationStream);
        configurationStream.close();
    }

    public static synchronized void destroy(ServletContext context) throws ServletException {
        try {
            if (factory != null) {
                factory.destroy();
                factory = null;
            }
        }
        catch (Exception e) {
            throw new ServletException("Could not destroy the database connection factory", (Throwable)e);
        }
    }

    public static String getHomeDir() {
        return Vault.getHomeDir();
    }
}

