/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.sms.gateways.internal;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Properties;
import org.opennms.sms.gateways.internal.GatewayGroupRegistrar;
import org.opennms.sms.reflector.smsservice.GatewayGroup;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.smslib.AGateway;
import org.smslib.modem.SerialModemGateway;
import org.springframework.beans.factory.InitializingBean;

public class GatewayGroupLoader
implements InitializingBean {
    private static Logger log = LoggerFactory.getLogger(GatewayGroupLoader.class);
    private Properties m_configProperties;
    private GatewayGroup[] m_gatewayGroups;
    private GatewayGroupRegistrar m_gatewayGroupRegistrar;

    public GatewayGroupLoader(GatewayGroupRegistrar gatewayGroupRegistrar, URL configURL) {
        this(gatewayGroupRegistrar, GatewayGroupLoader.loadProperties(configURL));
    }

    public GatewayGroupLoader(GatewayGroupRegistrar gatewayGroupRegistrar, Properties configProperties) {
        this.m_gatewayGroupRegistrar = gatewayGroupRegistrar;
        this.m_configProperties = configProperties;
    }

    public GatewayGroup[] getGatewayGroups() {
        return this.m_gatewayGroups;
    }

    public void load() {
        Properties modemProperties = this.m_configProperties;
        String modems = System.getProperty("org.opennms.sms.gateways.modems");
        if (modems == null || "".equals(modems.trim())) {
            modems = modemProperties.getProperty("modems");
        }
        String[] tokens = modems.split("\\s+");
        final AGateway[] gateways = new AGateway[tokens.length];
        if (tokens.length == 0) {
            this.m_gatewayGroups = new GatewayGroup[0];
        } else {
            for (int i = 0; i < tokens.length; ++i) {
                String modemId = tokens[i];
                String port = modemProperties.getProperty(modemId + ".port");
                if (port == null) {
                    throw new IllegalArgumentException("No port defined for modem with id " + modemId);
                }
                int baudRate = Integer.parseInt(modemProperties.getProperty(modemId + ".baudrate", "9600"));
                String manufacturer = modemProperties.getProperty(modemId + ".manufacturer");
                String model = modemProperties.getProperty(modemId + ".model");
                String pin = modemProperties.getProperty(modemId + ".pin", "0000");
                this.infof("Create SerialModemGateway(%s, %s, %d, %s, %s)", modemId, port, baudRate, manufacturer, model);
                SerialModemGateway gateway = new SerialModemGateway(modemId, port, baudRate, manufacturer, model);
                gateway.setProtocol(AGateway.Protocols.PDU);
                gateway.setInbound(true);
                gateway.setOutbound(true);
                gateway.setSimPin(pin);
                gateways[i] = gateway;
            }
            GatewayGroup gatewayGroup = new GatewayGroup(){

                public AGateway[] getGateways() {
                    return gateways;
                }
            };
            this.m_gatewayGroups = new GatewayGroup[]{gatewayGroup};
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Properties loadProperties(URL configURL) {
        Properties modemProperties = new Properties();
        InputStream in = null;
        try {
            in = configURL.openStream();
            modemProperties.load(in);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return modemProperties;
    }

    private void infof(String fmt, Object ... args) {
        if (log.isInfoEnabled()) {
            log.info(String.format(fmt, args));
        }
    }

    public void afterPropertiesSet() throws Exception {
        this.load();
        for (GatewayGroup group : this.getGatewayGroups()) {
            this.m_gatewayGroupRegistrar.registerGatewayGroup(group);
        }
    }
}

