/*
 * Decompiled with CFR 0.152.
 */
package org.drools.ruleflow.core.impl;

import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.drools.ruleflow.core.Connection;
import org.drools.ruleflow.core.Constraint;
import org.drools.ruleflow.core.Split;
import org.drools.ruleflow.core.impl.NodeImpl;

public class SplitImpl
extends NodeImpl
implements Split {
    private static final long serialVersionUID = 400L;
    private int type;
    private Map constraints;

    public SplitImpl() {
        this.type = 0;
        this.constraints = new HashMap();
    }

    public SplitImpl(int type) {
        this.type = type;
        this.constraints = new HashMap();
    }

    public void setType(int type) {
        this.type = type;
    }

    public int getType() {
        return this.type;
    }

    public Constraint getConstraint(Connection connection) {
        if (connection == null) {
            throw new IllegalArgumentException("connection is null");
        }
        HashMap newMap = new HashMap();
        Iterator it = this.constraints.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry entry = it.next();
            newMap.put(entry.getKey(), entry.getValue());
        }
        this.constraints = newMap;
        if (this.type == 3 || this.type == 2) {
            return (Constraint)this.constraints.get(connection);
        }
        throw new UnsupportedOperationException("Constraints are only supported with XOR or OR split types, not with: " + this.getType());
    }

    public void setConstraint(Connection connection, Constraint constraint) {
        if (this.type == 3 || this.type == 2) {
            if (connection == null) {
                throw new IllegalArgumentException("connection is null");
            }
            if (!this.getOutgoingConnections().contains(connection)) {
                throw new IllegalArgumentException("connection is unknown:" + connection);
            }
        } else {
            throw new UnsupportedOperationException("Constraints are only supported with XOR or OR split types, not with type:" + this.getType());
        }
        this.constraints.put(connection, constraint);
    }

    public Map getConstraints() {
        if (this.type == 3 || this.type == 2) {
            return Collections.unmodifiableMap(this.constraints);
        }
        throw new UnsupportedOperationException("Constraints are only supported with XOR or OR split types, not with: " + this.getType());
    }

    public Connection getFrom() {
        if (this.getIncomingConnections().size() > 0) {
            return (Connection)this.getIncomingConnections().get(0);
        }
        return null;
    }

    protected void validateAddIncomingConnection(Connection connection) {
        super.validateAddIncomingConnection(connection);
        if (this.getIncomingConnections().size() > 0) {
            throw new IllegalArgumentException("A split cannot have more than one incoming connection");
        }
    }

    protected void validateAddOutgoingConnection(Connection connection) {
        super.validateAddOutgoingConnection(connection);
        if (connection.getType() != 1) {
            throw new IllegalArgumentException("Unknown connection type :" + connection.getType() + ", only NORMAL is allowed as outgoing connection.");
        }
    }

    public void removeOutgoingConnection(Connection connection) {
        super.removeOutgoingConnection(connection);
        this.constraints.remove(connection);
    }
}

