/*
 * Decompiled with CFR 0.152.
 */
package org.drools.rule;

import java.util.Arrays;
import org.drools.RuntimeDroolsException;
import org.drools.common.InternalFactHandle;
import org.drools.common.InternalWorkingMemory;
import org.drools.reteoo.ReteTuple;
import org.drools.rule.ContextEntry;
import org.drools.rule.Declaration;
import org.drools.spi.AlphaNodeFieldConstraint;
import org.drools.spi.BetaNodeFieldConstraint;
import org.drools.spi.PredicateExpression;

public class PredicateConstraint
implements BetaNodeFieldConstraint,
AlphaNodeFieldConstraint {
    private static final long serialVersionUID = 400L;
    private PredicateExpression expression;
    private final Declaration[] requiredDeclarations;
    private final Declaration[] previousDeclarations;
    private final Declaration[] localDeclarations;
    private final String[] requiredGlobals;
    private static final Declaration[] EMPTY_DECLARATIONS = new Declaration[0];
    private static final String[] EMPTY_GLOBALS = new String[0];

    public PredicateConstraint(PredicateExpression evaluator) {
        this(evaluator, null, null, null);
    }

    public PredicateConstraint(Declaration[] previousDeclarations, Declaration[] localDeclarations) {
        this(null, previousDeclarations, localDeclarations, null);
    }

    public PredicateConstraint(PredicateExpression expression, Declaration[] previousDeclarations, Declaration[] localDeclarations, String[] requiredGlobals) {
        this.expression = expression;
        this.previousDeclarations = previousDeclarations == null ? EMPTY_DECLARATIONS : previousDeclarations;
        this.localDeclarations = localDeclarations == null ? EMPTY_DECLARATIONS : localDeclarations;
        this.requiredGlobals = requiredGlobals == null ? EMPTY_GLOBALS : requiredGlobals;
        this.requiredDeclarations = new Declaration[this.previousDeclarations.length + this.localDeclarations.length];
        System.arraycopy(this.previousDeclarations, 0, this.requiredDeclarations, 0, this.previousDeclarations.length);
        System.arraycopy(this.localDeclarations, 0, this.requiredDeclarations, this.previousDeclarations.length, this.localDeclarations.length);
    }

    public Declaration[] getRequiredDeclarations() {
        return this.requiredDeclarations;
    }

    public Declaration[] getPreviousDeclarations() {
        return this.previousDeclarations;
    }

    public Declaration[] getLocalDeclarations() {
        return this.localDeclarations;
    }

    public void replaceDeclaration(Declaration oldDecl, Declaration newDecl) {
        int i;
        for (i = 0; i < this.requiredDeclarations.length; ++i) {
            if (this.requiredDeclarations[i] != oldDecl) continue;
            this.requiredDeclarations[i] = newDecl;
        }
        for (i = 0; i < this.previousDeclarations.length; ++i) {
            if (this.previousDeclarations[i] != oldDecl) continue;
            this.previousDeclarations[i] = newDecl;
        }
        for (i = 0; i < this.localDeclarations.length; ++i) {
            if (this.localDeclarations[i] != oldDecl) continue;
            this.localDeclarations[i] = newDecl;
        }
    }

    public void setPredicateExpression(PredicateExpression expression) {
        this.expression = expression;
    }

    public PredicateExpression getPredicateExpression() {
        return this.expression;
    }

    public String toString() {
        return "[PredicateConstraint previousDeclarations=" + this.previousDeclarations + " localDeclarations=" + this.localDeclarations + "]";
    }

    public int hashCode() {
        return this.expression.hashCode();
    }

    public boolean equals(Object object) {
        int i;
        if (object == this) {
            return true;
        }
        if (object == null || object.getClass() != PredicateConstraint.class) {
            return false;
        }
        PredicateConstraint other = (PredicateConstraint)object;
        if (this.previousDeclarations.length != other.previousDeclarations.length) {
            return false;
        }
        if (this.localDeclarations.length != other.localDeclarations.length) {
            return false;
        }
        if (this.requiredGlobals.length != other.requiredGlobals.length) {
            return false;
        }
        int length = this.previousDeclarations.length;
        for (i = 0; i < length; ++i) {
            if (this.previousDeclarations[i].getPattern().getOffset() != other.previousDeclarations[i].getPattern().getOffset()) {
                return false;
            }
            if (this.previousDeclarations[i].getExtractor().equals(other.previousDeclarations[i].getExtractor())) continue;
            return false;
        }
        length = this.localDeclarations.length;
        for (i = 0; i < length; ++i) {
            if (this.localDeclarations[i].getPattern().getOffset() != other.localDeclarations[i].getPattern().getOffset()) {
                return false;
            }
            if (this.localDeclarations[i].getExtractor().equals(other.localDeclarations[i].getExtractor())) continue;
            return false;
        }
        if (!Arrays.equals(this.requiredGlobals, other.requiredGlobals)) {
            return false;
        }
        return this.expression.equals(other.expression);
    }

    public ContextEntry getContextEntry() {
        return new PredicateContextEntry();
    }

    public boolean isAllowed(Object object, InternalWorkingMemory workingMemory) {
        try {
            return this.expression.evaluate(object, null, this.previousDeclarations, this.localDeclarations, workingMemory);
        }
        catch (Exception e) {
            throw new RuntimeDroolsException("Exception executing predicate " + this.expression, e);
        }
    }

    public boolean isAllowedCachedLeft(ContextEntry context, Object object) {
        try {
            PredicateContextEntry ctx = (PredicateContextEntry)context;
            return this.expression.evaluate(object, ctx.leftTuple, this.previousDeclarations, this.localDeclarations, ctx.workingMemory);
        }
        catch (Exception e) {
            throw new RuntimeDroolsException("Exception executing predicate " + this.expression, e);
        }
    }

    public boolean isAllowedCachedRight(ReteTuple tuple, ContextEntry context) {
        try {
            PredicateContextEntry ctx = (PredicateContextEntry)context;
            return this.expression.evaluate(ctx.rightObject, tuple, this.previousDeclarations, this.localDeclarations, ctx.workingMemory);
        }
        catch (Exception e) {
            throw new RuntimeDroolsException("Exception executing predicate " + this.expression, e);
        }
    }

    public static class PredicateContextEntry
    implements ContextEntry {
        private static final long serialVersionUID = 400L;
        public ReteTuple leftTuple;
        public Object rightObject;
        public InternalWorkingMemory workingMemory;
        private ContextEntry entry;

        public ContextEntry getNext() {
            return this.entry;
        }

        public void setNext(ContextEntry entry) {
            this.entry = entry;
        }

        public void updateFromFactHandle(InternalWorkingMemory workingMemory, InternalFactHandle handle) {
            this.workingMemory = workingMemory;
            this.rightObject = handle.getObject();
        }

        public void updateFromTuple(InternalWorkingMemory workingMemory, ReteTuple tuple) {
            this.workingMemory = workingMemory;
            this.leftTuple = tuple;
        }
    }
}

