/*
 * Decompiled with CFR 0.152.
 */
package org.drools.reteoo;

import org.drools.common.InternalFactHandle;
import org.drools.common.InternalWorkingMemory;
import org.drools.reteoo.ReteTuple;
import org.drools.reteoo.TupleSink;
import org.drools.reteoo.TupleSinkNode;
import org.drools.reteoo.TupleSinkNodeList;
import org.drools.reteoo.TupleSinkPropagator;
import org.drools.spi.PropagationContext;

public class CompositeTupleSinkAdapter
implements TupleSinkPropagator {
    private TupleSinkNodeList sinks = new TupleSinkNodeList();

    public void addTupleSink(TupleSink sink) {
        this.sinks.add((TupleSinkNode)sink);
    }

    public void removeTupleSink(TupleSink sink) {
        this.sinks.remove((TupleSinkNode)sink);
    }

    public void propagateAssertTuple(ReteTuple tuple, InternalFactHandle handle, PropagationContext context, InternalWorkingMemory workingMemory) {
        for (TupleSinkNode sink = this.sinks.getFirst(); sink != null; sink = sink.getNextTupleSinkNode()) {
            sink.assertTuple(new ReteTuple(tuple, handle), context, workingMemory);
        }
    }

    public void propagateAssertTuple(ReteTuple tuple, PropagationContext context, InternalWorkingMemory workingMemory) {
        for (TupleSinkNode sink = this.sinks.getFirst(); sink != null; sink = sink.getNextTupleSinkNode()) {
            sink.assertTuple(new ReteTuple(tuple), context, workingMemory);
        }
    }

    public void propagateRetractTuple(ReteTuple tuple, InternalFactHandle handle, PropagationContext context, InternalWorkingMemory workingMemory) {
        for (TupleSinkNode sink = this.sinks.getFirst(); sink != null; sink = sink.getNextTupleSinkNode()) {
            sink.retractTuple(new ReteTuple(tuple, handle), context, workingMemory);
        }
    }

    public void propagateRetractTuple(ReteTuple tuple, PropagationContext context, InternalWorkingMemory workingMemory) {
        for (TupleSinkNode sink = this.sinks.getFirst(); sink != null; sink = sink.getNextTupleSinkNode()) {
            sink.retractTuple(new ReteTuple(tuple), context, workingMemory);
        }
    }

    public void createAndPropagateAssertTuple(InternalFactHandle handle, PropagationContext context, InternalWorkingMemory workingMemory) {
        for (TupleSinkNode sink = this.sinks.getFirst(); sink != null; sink = sink.getNextTupleSinkNode()) {
            sink.assertTuple(new ReteTuple(handle), context, workingMemory);
        }
    }

    public void createAndPropagateRetractTuple(InternalFactHandle handle, PropagationContext context, InternalWorkingMemory workingMemory) {
        for (TupleSinkNode sink = this.sinks.getFirst(); sink != null; sink = sink.getNextTupleSinkNode()) {
            sink.retractTuple(new ReteTuple(handle), context, workingMemory);
        }
    }

    public TupleSink[] getSinks() {
        TupleSink[] sinkArray = new TupleSink[this.sinks.size()];
        int i = 0;
        for (TupleSinkNode sink = this.sinks.getFirst(); sink != null; sink = sink.getNextTupleSinkNode()) {
            sinkArray[i++] = sink;
        }
        return sinkArray;
    }

    public int size() {
        return this.sinks.size();
    }
}

