/*
 * Decompiled with CFR 0.152.
 */
package org.drools.reteoo;

import java.util.Arrays;
import java.util.Collection;
import org.drools.common.BetaConstraints;
import org.drools.common.InternalFactHandle;
import org.drools.common.InternalWorkingMemory;
import org.drools.reteoo.BetaMemory;
import org.drools.reteoo.BetaNode;
import org.drools.reteoo.ObjectSink;
import org.drools.reteoo.ObjectSource;
import org.drools.reteoo.ReteTuple;
import org.drools.reteoo.TupleSink;
import org.drools.reteoo.TupleSource;
import org.drools.reteoo.builder.BuildContext;
import org.drools.rule.Collect;
import org.drools.spi.AlphaNodeFieldConstraint;
import org.drools.spi.PropagationContext;
import org.drools.util.ArrayUtils;
import org.drools.util.Entry;
import org.drools.util.FactEntry;
import org.drools.util.Iterator;
import org.drools.util.ObjectHashMap;

public class CollectNode
extends BetaNode
implements TupleSink,
ObjectSink {
    private static final long serialVersionUID = 400L;
    private final Collect collect;
    private final AlphaNodeFieldConstraint[] resultConstraints;
    private final BetaConstraints resultsBinder;
    private final boolean unwrapRightObject;

    public CollectNode(int id, TupleSource leftInput, ObjectSource rightInput, AlphaNodeFieldConstraint[] resultConstraints, BetaConstraints sourceBinder, BetaConstraints resultsBinder, Collect collect, boolean unwrapRight, BuildContext context) {
        super(id, leftInput, rightInput, sourceBinder);
        this.resultsBinder = resultsBinder;
        this.resultConstraints = resultConstraints;
        this.collect = collect;
        this.unwrapRightObject = unwrapRight;
        this.tupleMemoryEnabled = context.isTupleMemoryEnabled();
    }

    public void assertTuple(ReteTuple leftTuple, PropagationContext context, InternalWorkingMemory workingMemory) {
        BetaMemory memory = (BetaMemory)workingMemory.getNodeMemory(this);
        Collection result = this.collect.instantiateResultObject();
        InternalFactHandle resultHandle = workingMemory.getFactHandleFactory().newFactHandle(result);
        CollectResult colresult = new CollectResult();
        colresult.handle = resultHandle;
        colresult.propagated = false;
        if (this.tupleMemoryEnabled) {
            memory.getTupleMemory().add(leftTuple);
            memory.getCreatedHandles().put(leftTuple, colresult, false);
        }
        Iterator it = memory.getFactHandleMemory().iterator(leftTuple);
        this.constraints.updateFromTuple(workingMemory, leftTuple);
        FactEntry entry = (FactEntry)it.next();
        while (entry != null) {
            InternalFactHandle handle = entry.getFactHandle();
            if (this.constraints.isAllowedCachedLeft(handle.getObject())) {
                if (this.unwrapRightObject) {
                    handle = ((ReteTuple)handle.getObject()).getLastHandle();
                }
                result.add(handle.getObject());
            }
            entry = (FactEntry)it.next();
        }
        boolean isAllowed = true;
        int length = this.resultConstraints.length;
        for (int i = 0; i < length; ++i) {
            if (this.resultConstraints[i].isAllowed(result, workingMemory)) continue;
            isAllowed = false;
            break;
        }
        if (isAllowed) {
            this.resultsBinder.updateFromTuple(workingMemory, leftTuple);
            if (this.resultsBinder.isAllowedCachedLeft(result)) {
                colresult.propagated = true;
                this.sink.propagateAssertTuple(leftTuple, resultHandle, context, workingMemory);
            }
        }
    }

    public void retractTuple(ReteTuple leftTuple, PropagationContext context, InternalWorkingMemory workingMemory) {
        BetaMemory memory = (BetaMemory)workingMemory.getNodeMemory(this);
        memory.getTupleMemory().remove(leftTuple);
        CollectResult result = (CollectResult)memory.getCreatedHandles().remove(leftTuple);
        InternalFactHandle handle = result.handle;
        if (result.propagated) {
            this.sink.propagateRetractTuple(leftTuple, handle, context, workingMemory);
            workingMemory.getFactHandleFactory().destroyFactHandle(handle);
        }
    }

    public void assertObject(InternalFactHandle handle, PropagationContext context, InternalWorkingMemory workingMemory) {
        BetaMemory memory = (BetaMemory)workingMemory.getNodeMemory(this);
        memory.getFactHandleMemory().add(handle);
        if (!this.tupleMemoryEnabled) {
            return;
        }
        this.constraints.updateFromFactHandle(workingMemory, handle);
        Entry[] tuples = memory.getTupleMemory().toArray();
        for (int i = 0; i < tuples.length; ++i) {
            ReteTuple tuple = (ReteTuple)tuples[i];
            if (!this.constraints.isAllowedCachedRight(tuple)) continue;
            this.modifyTuple(true, tuple, handle, context, workingMemory);
        }
    }

    public void retractObject(InternalFactHandle handle, PropagationContext context, InternalWorkingMemory workingMemory) {
        BetaMemory memory = (BetaMemory)workingMemory.getNodeMemory(this);
        if (!memory.getFactHandleMemory().remove(handle)) {
            return;
        }
        this.constraints.updateFromFactHandle(workingMemory, handle);
        Entry[] tuples = memory.getTupleMemory().toArray();
        for (int i = 0; i < tuples.length; ++i) {
            ReteTuple tuple = (ReteTuple)tuples[i];
            if (!this.constraints.isAllowedCachedRight(tuple)) continue;
            this.modifyTuple(false, tuple, handle, context, workingMemory);
        }
    }

    public void modifyTuple(boolean isAssert, ReteTuple leftTuple, InternalFactHandle handle, PropagationContext context, InternalWorkingMemory workingMemory) {
        BetaMemory memory = (BetaMemory)workingMemory.getNodeMemory(this);
        CollectResult result = (CollectResult)memory.getCreatedHandles().get(leftTuple);
        if (result.propagated) {
            this.sink.propagateRetractTuple(leftTuple, result.handle, context, workingMemory);
            result.propagated = false;
        }
        if (this.unwrapRightObject) {
            handle = ((ReteTuple)handle.getObject()).getLastHandle();
        }
        if (context.getType() == 0) {
            ((Collection)result.handle.getObject()).add(handle.getObject());
        } else if (context.getType() == 1) {
            ((Collection)result.handle.getObject()).remove(handle.getObject());
        } else if (context.getType() == 2) {
            if (isAssert) {
                ((Collection)result.handle.getObject()).add(handle.getObject());
            } else {
                ((Collection)result.handle.getObject()).remove(handle.getObject());
            }
        }
        boolean isAllowed = true;
        int length = this.resultConstraints.length;
        for (int i = 0; i < length; ++i) {
            if (this.resultConstraints[i].isAllowed(result.handle.getObject(), workingMemory)) continue;
            isAllowed = false;
            break;
        }
        if (isAllowed) {
            this.resultsBinder.updateFromTuple(workingMemory, leftTuple);
            if (this.resultsBinder.isAllowedCachedLeft(result.handle.getObject())) {
                result.propagated = true;
                this.sink.propagateAssertTuple(leftTuple, result.handle, context, workingMemory);
            }
        }
    }

    public void updateSink(TupleSink sink, PropagationContext context, InternalWorkingMemory workingMemory) {
        BetaMemory memory = (BetaMemory)workingMemory.getNodeMemory(this);
        Iterator it = memory.getCreatedHandles().iterator();
        ObjectHashMap.ObjectEntry entry = (ObjectHashMap.ObjectEntry)it.next();
        while (entry != null) {
            CollectResult result = (CollectResult)entry.getValue();
            sink.assertTuple(new ReteTuple((ReteTuple)entry.getKey(), result.handle), context, workingMemory);
            entry = (ObjectHashMap.ObjectEntry)it.next();
        }
    }

    public int hashCode() {
        return this.leftInput.hashCode() ^ this.rightInput.hashCode() ^ this.collect.hashCode() ^ this.resultsBinder.hashCode() ^ ArrayUtils.hashCode(this.resultConstraints);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || !(object instanceof CollectNode)) {
            return false;
        }
        CollectNode other = (CollectNode)object;
        if (!(this.getClass() == other.getClass() && this.leftInput.equals(other.leftInput) && this.rightInput.equals(other.rightInput) && this.constraints.equals(other.constraints))) {
            return false;
        }
        return this.collect.equals(other.collect) && this.resultsBinder.equals(other.resultsBinder) && Arrays.equals(this.resultConstraints, other.resultConstraints);
    }

    public String toString() {
        return "[ " + this.getClass().getName() + "(" + this.id + ") ]";
    }

    private static class CollectResult {
        public InternalFactHandle handle;
        public boolean propagated;

        private CollectResult() {
        }
    }
}

