/*
 * Decompiled with CFR 0.152.
 */
package org.drools.event;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.drools.WorkingMemory;
import org.drools.common.InternalWorkingMemory;
import org.drools.event.ActivationCancelledEvent;
import org.drools.event.ActivationCreatedEvent;
import org.drools.event.AfterActivationFiredEvent;
import org.drools.event.AgendaEventListener;
import org.drools.event.AgendaGroupPoppedEvent;
import org.drools.event.AgendaGroupPushedEvent;
import org.drools.event.BeforeActivationFiredEvent;
import org.drools.spi.Activation;
import org.drools.spi.AgendaGroup;

public class AgendaEventSupport
implements Serializable {
    private static final long serialVersionUID = 400L;
    private final List listeners = Collections.synchronizedList(new ArrayList());

    public void addEventListener(AgendaEventListener listener) {
        if (!this.listeners.contains(listener)) {
            this.listeners.add(listener);
        }
    }

    public void removeEventListener(AgendaEventListener listener) {
        this.listeners.remove(listener);
    }

    public List getEventListeners() {
        return Collections.unmodifiableList(this.listeners);
    }

    public int size() {
        return this.listeners.size();
    }

    public boolean isEmpty() {
        return this.listeners.isEmpty();
    }

    public void fireActivationCreated(Activation activation, WorkingMemory workingMemory) {
        if (this.listeners.isEmpty()) {
            return;
        }
        ActivationCreatedEvent event = new ActivationCreatedEvent(activation);
        int size = this.listeners.size();
        for (int i = 0; i < size; ++i) {
            ((AgendaEventListener)this.listeners.get(i)).activationCreated(event, workingMemory);
        }
    }

    public void fireActivationCancelled(Activation activation, WorkingMemory workingMemory) {
        if (this.listeners.isEmpty()) {
            return;
        }
        ActivationCancelledEvent event = new ActivationCancelledEvent(activation);
        int size = this.listeners.size();
        for (int i = 0; i < size; ++i) {
            ((AgendaEventListener)this.listeners.get(i)).activationCancelled(event, workingMemory);
        }
    }

    public void fireBeforeActivationFired(Activation activation, WorkingMemory workingMemory) {
        if (this.listeners.isEmpty()) {
            return;
        }
        BeforeActivationFiredEvent event = new BeforeActivationFiredEvent(activation);
        int size = this.listeners.size();
        for (int i = 0; i < size; ++i) {
            ((AgendaEventListener)this.listeners.get(i)).beforeActivationFired(event, workingMemory);
        }
    }

    public void fireAfterActivationFired(Activation activation, InternalWorkingMemory workingMemory) {
        if (this.listeners.isEmpty()) {
            return;
        }
        AfterActivationFiredEvent event = new AfterActivationFiredEvent(activation);
        int size = this.listeners.size();
        for (int i = 0; i < size; ++i) {
            ((AgendaEventListener)this.listeners.get(i)).afterActivationFired(event, workingMemory);
        }
    }

    public void fireAgendaGroupPopped(AgendaGroup agendaGroup, InternalWorkingMemory workingMemory) {
        if (this.listeners.isEmpty()) {
            return;
        }
        AgendaGroupPoppedEvent event = new AgendaGroupPoppedEvent(agendaGroup);
        int size = this.listeners.size();
        for (int i = 0; i < size; ++i) {
            ((AgendaEventListener)this.listeners.get(i)).agendaGroupPopped(event, workingMemory);
        }
    }

    public void fireAgendaGroupPushed(AgendaGroup agendaGroup, InternalWorkingMemory workingMemory) {
        if (this.listeners.isEmpty()) {
            return;
        }
        AgendaGroupPushedEvent event = new AgendaGroupPushedEvent(agendaGroup);
        int size = this.listeners.size();
        for (int i = 0; i < size; ++i) {
            ((AgendaEventListener)this.listeners.get(i)).agendaGroupPushed(event, workingMemory);
        }
    }
}

