/*
 * Decompiled with CFR 0.152.
 */
package org.drools.base.accumulators;

import org.drools.base.accumulators.AccumulateFunction;

public class AverageAccumulateFunction
implements AccumulateFunction {
    public Object createContext() {
        return new AverageData();
    }

    public void init(Object context) throws Exception {
        AverageData data = (AverageData)context;
        data.count = 0;
        data.total = 0.0;
    }

    public void accumulate(Object context, Object value) {
        AverageData data = (AverageData)context;
        ++data.count;
        data.total += ((Number)value).doubleValue();
    }

    public void reverse(Object context, Object value) throws Exception {
        AverageData data = (AverageData)context;
        --data.count;
        data.total -= ((Number)value).doubleValue();
    }

    public Object getResult(Object context) throws Exception {
        AverageData data = (AverageData)context;
        return new Double(data.count == 0 ? 0.0 : data.total / (double)data.count);
    }

    public boolean supportsReverse() {
        return true;
    }

    protected static class AverageData {
        public int count = 0;
        public double total = 0.0;

        protected AverageData() {
        }
    }
}

