/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.shell.dev;

import java.util.concurrent.TimeoutException;
import org.apache.felix.gogo.commands.Argument;
import org.apache.felix.gogo.commands.Command;
import org.apache.felix.gogo.commands.Option;
import org.apache.karaf.shell.console.OsgiCommandSupport;
import org.osgi.framework.Filter;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.util.tracker.ServiceTracker;

@Command(scope="dev", name="wait-for-service", description="Wait for a given OSGi service.")
public class WaitForService
extends OsgiCommandSupport {
    @Option(name="-e", aliases={"--exception"}, description="throw an exception if the service is not found after the timeout")
    boolean exception;
    @Option(name="-t", aliases={"--timeout"}, description="timeout to wait for the service (in milliseconds, negative to not wait at all, zero to wait forever)")
    long timeout = 0L;
    @Argument(name="service", description="The service class or filter", required=true, multiValued=false)
    String service;

    protected Object doExecute() throws Exception {
        ServiceTracker tracker = null;
        try {
            String filter = this.service;
            if (!filter.startsWith("(")) {
                if (!filter.contains("=")) {
                    filter = "objectClass=" + filter;
                }
                filter = "(" + filter + ")";
            }
            Filter osgiFilter = FrameworkUtil.createFilter((String)filter);
            tracker = new ServiceTracker(this.bundleContext, osgiFilter, null);
            tracker.open(true);
            Object svc = tracker.getService();
            if (this.timeout >= 0L) {
                svc = tracker.waitForService(this.timeout);
            }
            if (this.exception && svc == null) {
                throw new TimeoutException("Can not find service '" + this.service + "' in the OSGi registry");
            }
            Boolean bl = svc != null;
            return bl;
        }
        catch (InvalidSyntaxException e) {
            throw new IllegalArgumentException("Invalid filter", e);
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        finally {
            if (tracker != null) {
                tracker.close();
            }
        }
    }
}

